/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SeriesCoreInformationProvider
implements ISeriesDataProvider.ISeriesCoreInformationProvider {
    private final @NonNull Function<@NonNull String, @NonNull IBinDataProvider> binDataSupplier;
    private final @NonNull IntFunction<@NonNull Collection<@NonNull ProcessingElementReference>> clusterCoresFunction;
    private final @NonNull Supplier<@NonNull Set<@NonNull String>> sourcesSupplier;

    private static void accumulateChannelDescriptors(@NonNull Set<@NonNull ProcessingElementReference> coreSet, @NonNull DeviceType deviceType, boolean counterRecordIsPerCPU, int counterRecordCoreCount, @NonNull Collection<@NonNull ProcessingElementReference> channelDescriptors) {
        assert (channelDescriptors.stream().allMatch(channel -> channel.deviceType.equals((Object)deviceType))) : String.format("Expected all channels to match specified device type: %s vs %s", deviceType, channelDescriptors);
        if (deviceType.supportsMultipleCoresControlledByCounterRecord()) {
            int n = counterRecordIsPerCPU && counterRecordCoreCount > 1 ? counterRecordCoreCount : 1;
            channelDescriptors.stream().filter(pe -> pe.deviceNumber < n).forEach(coreSet::add);
        } else {
            coreSet.addAll(channelDescriptors);
        }
    }

    public SeriesCoreInformationProvider(@NonNull Supplier<@NonNull Set<@NonNull String>> sourcesSupplier, @NonNull Function<@NonNull String, @NonNull IBinDataProvider> binDataSupplier, @NonNull IntFunction<@NonNull Collection<@NonNull ProcessingElementReference>> clusterCoresFunction) {
        this.sourcesSupplier = sourcesSupplier;
        this.binDataSupplier = binDataSupplier;
        this.clusterCoresFunction = clusterCoresFunction;
    }

    @Override
    public @NonNull Set<@NonNull ProcessingElementReference> getChannelDescriptors() {
        @NonNull HashSet<@NonNull ProcessingElementReference> coreSet = new HashSet<ProcessingElementReference>();
        @NonNull Set<@NonNull String> sources = this.sourcesSupplier.get();
        for (String source : sources) {
            @NonNull IBinDataProvider provider = this.binDataSupplier.apply(source);
            @NonNull CounterRecord cr = provider.getCounterRecord();
            @Nullable Integer cluster = cr.getCluster();
            if (cluster == null) {
                SeriesCoreInformationProvider.accumulateChannelDescriptors(coreSet, cr.getDeviceTypeOrDefault(), cr.isPerCPU(), cr.getCores(), Arrays.asList(provider.getChannelDescriptors()));
                continue;
            }
            @NonNull HashSet<@NonNull ProcessingElementReference> perClusterProcessingElements = new HashSet<ProcessingElementReference>(this.clusterCoresFunction.apply(cluster));
            perClusterProcessingElements.retainAll(Arrays.asList(provider.getChannelDescriptors()));
            SeriesCoreInformationProvider.accumulateChannelDescriptors(coreSet, cr.getDeviceTypeOrDefault(), cr.isPerCPU(), cr.getCores(), perClusterProcessingElements);
        }
        return coreSet;
    }

    @Override
    public @Nullable DeviceType getDeviceType() {
        DeviceType deviceType = null;
        for (String source : this.sourcesSupplier.get()) {
            IBinDataProvider provider = this.binDataSupplier.apply(source);
            @NonNull DeviceType counterDeviceType = provider.getCounterRecord().getDeviceTypeOrDefault();
            if (deviceType == null) {
                deviceType = counterDeviceType;
                continue;
            }
            if (deviceType.equals((Object)counterDeviceType)) continue;
            return null;
        }
        return deviceType;
    }
}

