/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.utility.RGBUtils;
import com.arm.utils.NullChecking;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public final class SeriesConfigUtility {
    public static final @NonNull String NAME_SUFFIX = "${*}";
    private static final @NonNull RGB[] rgbChoosers = new RGB[]{new RGB(164, 71, 164), new RGB(246, 138, 51), new RGB(19, 148, 180), new RGB(217, 21, 74), new RGB(33, 141, 68)};

    public static final @NonNull String deriveSeriesConfNameFromWildcard(@NonNull String wildcardName, @NonNull String matchedContext, @NonNull String matchWithWildcardPattern) {
        String contextItd = matchedContext.replace(SeriesConfigUtility.getMatchPrefix(matchWithWildcardPattern), "");
        if (wildcardName.contains(NAME_SUFFIX)) {
            return wildcardName.replaceAll("\\Q${*}\\E", contextItd);
        }
        return wildcardName + " " + contextItd;
    }

    public static final @NonNull String getMatchPrefix(@NonNull String matchWith) {
        int start = matchWith.indexOf("$");
        int lastIndexOf = matchWith.lastIndexOf("*");
        return matchWith.substring(start + 1, lastIndexOf);
    }

    public static @NonNull RGB getNextColor(int count) {
        RGB rgb = rgbChoosers[count % rgbChoosers.length];
        return rgb;
    }

    public static @NonNull RGB getNextColorFromColorList(@NonNull List<@NonNull String> colorList, int pos) {
        return (RGB)NullChecking.neverNull((Object)RGBUtils.decode(colorList.get(pos % colorList.size())));
    }
}

