/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.templates.TemplateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public class SeriesConfig
extends AbstractSeriesConfig
implements Cloneable {
    private @NonNull String mExpression = "";
    private @NonNull List<@NonNull IListener> mListeners = new ArrayList<IListener>();
    private @Nullable WildcardSeriesConfig expandedFromWildCard;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getDisplay().hashCode();
        result = 31 * result + this.mExpression.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SeriesConfig other = (SeriesConfig)obj;
        if (this.getDisplay() != other.getDisplay()) {
            return false;
        }
        return this.mExpression.equals(other.mExpression);
    }

    public static @NonNull SeriesConfig create(String name, String description, String expression, CounterDisplay display, String units, RGB color) {
        SeriesConfig config = new SeriesConfig();
        config.setName(name);
        config.setDescriptionFormat(description);
        config.setExpression(expression);
        config.setDisplay(display);
        config.setUnits(units);
        config.setColor(color);
        return config;
    }

    public static @NonNull SeriesConfig create(String name, String description, String expression, CounterDisplay display, String units, RGB color, @Nullable WildcardSeriesConfig expandedfrom) {
        SeriesConfig config = new SeriesConfig();
        config.setName(name);
        config.setDescriptionFormat(description);
        config.setExpression(expression);
        config.setDisplay(display);
        config.setUnits(units);
        config.setColor(color);
        config.setExpandedFromWildCard(expandedfrom);
        return config;
    }

    @Override
    public final synchronized void addListener(IListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public final @NonNull SeriesConfig clone() {
        SeriesConfig series = new SeriesConfig();
        series.setName(this.getName());
        series.expandedFromWildCard = this.expandedFromWildCard;
        series.mExpression = this.mExpression;
        series.setDisplay(this.getDisplay());
        series.setUnits(this.getUnits());
        series.setDescriptionFormat(this.getDescriptionFormat());
        series.setColor(this.getColor());
        series.mListeners = new ArrayList<IListener>();
        return series;
    }

    @Override
    public final synchronized void removeListener(IListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public final @NonNull String getExpression() {
        return this.mExpression;
    }

    @Override
    public final void setExpression(@NonNull String expression) {
        if (!this.mExpression.equals(expression = expression.trim())) {
            this.mExpression = expression;
            this.notifyListeners();
        }
    }

    public final String toString() {
        return "Series Config: " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyListeners() {
        IListener[] listeners;
        SeriesConfig seriesConfig = this;
        synchronized (seriesConfig) {
            listeners = this.mListeners.toArray(new IListener[this.mListeners.size()]);
        }
        IListener[] iListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IListener listener = iListenerArray[n2];
            listener.expressionOrDisplayModified();
            ++n2;
        }
    }

    public @Nullable WildcardSeriesConfig getExpandedFromWildCard() {
        return this.expandedFromWildCard;
    }

    public void setExpandedFromWildCard(@Nullable WildcardSeriesConfig expandedFromWildCard) {
        this.expandedFromWildCard = expandedFromWildCard;
    }

    @Override
    public boolean matches(@NonNull AbstractSeriesConfig other) {
        return this.getName().equals(other.getName()) && other instanceof SeriesConfig && this.mExpression.equals(((SeriesConfig)other).getExpression()) && this.getDisplay().equals((Object)other.getDisplay()) && this.getDescriptionFormat().equals(other.getDescriptionFormat()) && this.getColor().equals((Object)other.getColor()) && this.getUnits().equals(other.getUnits());
    }

    @Override
    public boolean isExpandedSeries() {
        return this.getExpandedFromWildCard() != null;
    }

    @Override
    public @Nullable String getMatchWith() {
        return null;
    }

    @Override
    public @NonNull List<@NonNull SeriesConfig> createSeriesFromSources(@NonNull ICaptureDataProvider cdp) {
        return TemplateUtils.hasAllSources(this, cdp.getAllBinData()) ? List.of(this) : Collections.emptyList();
    }

    @Override
    public boolean isWildcardSeries() {
        return false;
    }

    @Override
    public @NonNull List<@NonNull SeriesConfig> createSeriesFromSources(@NonNull List<@NonNull String> sources) {
        return List.of(this);
    }

    public static interface IListener {
        public void expressionOrDisplayModified();
    }
}

