/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ChartCoreInformationProvider
implements IChartDataProvider.IChartCoreInformationProvider {
    private final @NonNull List<@NonNull ISeriesDataProvider> series;

    public ChartCoreInformationProvider(@NonNull List<@NonNull ISeriesDataProvider> series) {
        this.series = series;
    }

    @Override
    public @NonNull ProcessingElementReference @NonNull [] getChannelDescriptors() {
        @NonNull Set<@NonNull ProcessingElementReference> set = this.accumulateAllSeriesChannels();
        @NonNull Object @NonNull [] result = set.toArray(new ProcessingElementReference[set.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public @Nullable String getChannelName(@NonNull ProcessingElementReference peReference) {
        DeviceType device = peReference.deviceType;
        if (device.isCPU()) {
            return this.getCoreName(peReference);
        }
        return device.toString();
    }

    @Override
    public int getCoreColourIndex(@NonNull ProcessingElementReference processingElementReference) {
        if (processingElementReference.deviceType.isSystemWide()) {
            if (!this.hasMultipleVms()) {
                return -1;
            }
            return (int)processingElementReference.vmUID;
        }
        if (processingElementReference.deviceType.isCPU()) {
            return this.getCoreIndex(processingElementReference);
        }
        return (int)((long)processingElementReference.deviceNumber + processingElementReference.vmUID);
    }

    @Override
    public @Nullable DeviceType getDeviceType() {
        DeviceType deviceType = null;
        for (ISeriesDataProvider series : this.series) {
            if (!(deviceType == null ? (deviceType = series.getCoreInformationProvider().getDeviceType()) == null : !deviceType.equals((Object)series.getCoreInformationProvider().getDeviceType()))) continue;
            return null;
        }
        return deviceType;
    }

    protected abstract @NonNull IBinDataProvider getBinDataProvider(@NonNull String var1);

    protected abstract int getCoreIndex(@NonNull ProcessingElementReference var1);

    protected abstract @Nullable String getCoreName(@NonNull ProcessingElementReference var1);

    private @NonNull Set<@NonNull ProcessingElementReference> accumulateAllSeriesChannels() {
        switch (this.series.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return this.series.get(0).getCoreInformationProvider().getChannelDescriptors();
            }
        }
        HashSet<@NonNull ProcessingElementReference> set = new HashSet<ProcessingElementReference>();
        for (ISeriesDataProvider series : this.series) {
            set.addAll(series.getCoreInformationProvider().getChannelDescriptors());
        }
        return set;
    }
}

