/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.model.annotation.VisualAnnotationData;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.utils.text.NumericStringComparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ChartConfig
implements Cloneable,
Comparable<ChartConfig> {
    private @NonNull String mTitle = "";
    private SeriesComposition mSeriesComposition;
    private GraphRenderingType mRenderingType;
    private boolean mHeatMapLineEnabled;
    private boolean mAverageSelection;
    private boolean mAverageCores;
    private boolean mPercentage;
    private boolean mOpen;
    private boolean mAlignmentLinked;
    private long mAlignment;
    private int mHeight;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AbstractPerVmId.PerVmNonUniquePid mID;

    public ChartConfig() {
        this.reset();
    }

    public ChartConfig(@NonNull String mTitle, SeriesComposition mSeriesComposition, GraphRenderingType mRenderingType, boolean mHeatMapLineEnabled, boolean mAverageSelection, boolean mAverageCores, boolean mPercentage, boolean mOpen, boolean mAlignmentLinked, long mAlignment, int mHeight, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AbstractPerVmId.PerVmNonUniquePid mID) {
        this.reset();
        this.mTitle = mTitle;
        this.mSeriesComposition = mSeriesComposition;
        this.mRenderingType = mRenderingType;
        this.mAverageSelection = mAverageSelection;
        this.mAverageCores = mAverageCores;
        this.mPercentage = mPercentage;
        this.mAlignmentLinked = mAlignmentLinked;
        this.mAlignment = mAlignment;
        this.mOpen = mOpen;
        this.mHeatMapLineEnabled = mHeatMapLineEnabled;
        this.mHeight = mHeight;
        this.mID = mID;
    }

    public @NonNull ChartConfig clone() {
        ChartConfig chart = new ChartConfig();
        chart.mTitle = this.mTitle;
        chart.mSeriesComposition = this.mSeriesComposition;
        chart.mRenderingType = this.mRenderingType;
        chart.mAverageSelection = this.mAverageSelection;
        chart.mAverageCores = this.mAverageCores;
        chart.mPercentage = this.mPercentage;
        chart.mAlignmentLinked = this.mAlignmentLinked;
        chart.mAlignment = this.mAlignment;
        chart.mOpen = this.mOpen;
        chart.mHeatMapLineEnabled = this.mHeatMapLineEnabled;
        chart.mHeight = this.mHeight;
        chart.mID = this.mID;
        return chart;
    }

    @Override
    public int compareTo(ChartConfig other) {
        return NumericStringComparator.caselessCompareStrings((String)this.mTitle, (String)other.mTitle);
    }

    public long getAlignment() {
        return this.mAlignment;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AbstractPerVmId.PerVmNonUniquePid getID() {
        return this.mID;
    }

    public GraphRenderingType getRenderingType() {
        return this.mRenderingType;
    }

    public SeriesComposition getSeriesComposition() {
        return this.mSeriesComposition;
    }

    public @NonNull String getTitle() {
        return this.mTitle;
    }

    public boolean isAlignmentLinked() {
        return this.mAlignmentLinked;
    }

    public boolean isAverageCores() {
        return this.mAverageCores;
    }

    public boolean isAverageSelection() {
        return this.mAverageSelection;
    }

    public boolean isOpen() {
        return this.mOpen;
    }

    public boolean isPercentage() {
        return this.mPercentage;
    }

    public boolean isHeatMapLineEnabled() {
        return this.mHeatMapLineEnabled;
    }

    public void load(IChartDataProvider chart) {
        this.setTitle(chart.getTitleFormat());
        this.setSeriesComposition(chart.getSeriesComposition());
        this.setRenderingType(chart.getRenderingType());
        this.setAverageSelection(chart.isAverageSelection());
        this.setAverageCores(chart.isAverageCores());
        this.setPercentage(chart.isPercentage());
        this.setAlignment(chart.getAlignment());
        this.setOpen(chart.isOpen());
        this.setHeatMapLineEnabled(chart.isHeatMapLineEnabled());
        this.setHeight(chart.getHeight());
        @Nullable VisualAnnotationData visualAnnotationData = chart.getVisualAnnotationData();
        if (visualAnnotationData != null) {
            this.setID(visualAnnotationData.getID());
        }
    }

    public boolean matches(ChartConfig other) {
        return this.mTitle.equals(other.mTitle) && this.mSeriesComposition == other.mSeriesComposition && this.mRenderingType == other.mRenderingType && this.mAverageSelection == other.mAverageSelection && this.mAverageCores == other.mAverageCores && this.mPercentage == other.mPercentage && this.mAlignmentLinked == other.mAlignmentLinked && this.mAlignment == other.mAlignment && this.mOpen == other.mOpen && this.mHeatMapLineEnabled == other.mHeatMapLineEnabled && this.mHeight == other.mHeight && this.mID == other.mID;
    }

    public void reset() {
        this.mTitle = "";
        this.mSeriesComposition = SeriesComposition.DEFAULT;
        this.mRenderingType = GraphRenderingType.DEFAULT;
        this.mAverageSelection = false;
        this.mAverageCores = false;
        this.mPercentage = false;
        this.mAlignmentLinked = true;
        this.mAlignment = 0L;
        this.mOpen = false;
        this.mHeatMapLineEnabled = false;
        this.mHeight = 0;
        this.mID = null;
    }

    public void setAlignment(long alignment) {
        this.mAlignment = alignment;
    }

    public void setAlignmentLinked(boolean linked) {
        this.mAlignmentLinked = linked;
    }

    public void setAverageCores(boolean average) {
        this.mAverageCores = average;
    }

    public void setAverageSelection(boolean average) {
        this.mAverageSelection = average;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public void setID(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AbstractPerVmId.PerVmNonUniquePid value) {
        this.mID = value;
    }

    public void setOpen(boolean open) {
        this.mOpen = open;
    }

    public void setPercentage(boolean percentage) {
        this.mPercentage = percentage;
    }

    public void setRenderingType(GraphRenderingType type) {
        this.mRenderingType = type;
    }

    public void setSeriesComposition(SeriesComposition type) {
        this.mSeriesComposition = type;
    }

    public void setTitle(String name) {
        if (name == null) {
            StreamlinePlugin.info("investigate: title set to null");
            this.mTitle = "";
        } else {
            this.mTitle = name;
        }
    }

    public void setHeatMapLineEnabled(boolean misHeatMapLineEnabled) {
        this.mHeatMapLineEnabled = misHeatMapLineEnabled;
    }

    public String toString() {
        return "Chart Config: " + this.mTitle;
    }
}

