/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.VariableReplacerConstants;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.editortabs.timeline.common.charts.WildcardSeriesConfigUtility;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.utility.RGBUtils;
import com.arm.utils.NullChecking;
import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public class ChartAndSeriesXMLParser {
    public static final String TAG_CHART = "chart";
    public static final String TAG_SERIES = "series";
    public static final String DEFAULT_COLOR = "60,150,251";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_EXPRESSION = "expression";
    private static final String ATTR_AUTO_ROTATE_COLOR = "useAutomaticColorRotation";
    private static final String ATTR_COLOR_LIST = "colorList";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_COLOR = "color";
    private static final String ATTR_UNITS = "units";
    private static final String ATTR_DISPLAY = "display";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_SERIES_COMPOSITION = "series_composition";
    private static final String ATTR_RENDERING_TYPE = "rendering_type";
    private static final String ATTR_HEATMAPLINE_ENABLED = "heatmap_line_enabled";
    private static final String ATTR_AVERAGE_SELECTION = "average_selection";
    private static final String ATTR_AVERAGE_CORES = "average_cores";
    private static final String ATTR_PERCENTAGE = "percentage";
    private static final String ATTR_ALIGNMENT_LINKED = "alignment_linked";
    private static final String ATTR_ALIGNMENT = "alignment";
    private static final String ATTR_ID = "id";
    private static final String ATTR_OPEN = "open";
    private static final String ATTR_HEIGHT = "height";
    private static final String ATTR_VMUID = "vmuid";
    private static final String ATTR_MATCHWITH = "match_with";

    public static @NonNull List<@NonNull ChartAndSeriesConfig> load(@NonNull XMLParser in, boolean expandCluster, @NonNull Map<@NonNull String, @NonNull TIntSet> sourceClusterMap) throws IOException {
        String tag;
        @NonNull String sourceWithEmptyCluster = sourceClusterMap.entrySet().stream().filter(c -> ((TIntSet)c.getValue()).isEmpty()).map(src -> (String)src.getKey()).collect(Collectors.joining(","));
        if (!sourceWithEmptyCluster.isEmpty()) {
            throw new IllegalArgumentException("Error due to following source(s) mapped with empty cluster : " + sourceWithEmptyCluster);
        }
        @NonNull ArrayList<@NonNull ChartAndSeriesConfig> clusterConfigs = new ArrayList<ChartAndSeriesConfig>();
        AbstractPerVmId.PerVmNonUniquePid perVmNonUPID = null;
        if (in.hasAttribute(ATTR_ID)) {
            perVmNonUPID = new AbstractPerVmId.PerVmNonUniquePid((long)in.getIntegerAttribute(ATTR_VMUID, 0), in.getIntegerAttribute(ATTR_ID));
        }
        @NonNull String title = in.getAttribute(ATTR_TITLE, "");
        @NonNull SeriesComposition seriesComposition = SeriesComposition.get((String)in.getAttribute(ATTR_SERIES_COMPOSITION));
        @NonNull GraphRenderingType mRenderingType = GraphRenderingType.get((String)in.getAttribute(ATTR_RENDERING_TYPE, GraphRenderingType.DEFAULT.toString()));
        boolean isHeatMapLineEnabled = in.isAttributeSet(ATTR_HEATMAPLINE_ENABLED);
        boolean isAverageSelection = in.isAttributeSet(ATTR_AVERAGE_SELECTION);
        boolean isAvgCores = in.isAttributeSet(ATTR_AVERAGE_CORES);
        boolean isPercentage = in.isAttributeSet(ATTR_PERCENTAGE);
        boolean isChartsOpen = in.isAttributeSet(ATTR_OPEN);
        boolean isAlignmnetLinked = in.isAttributeSet(ATTR_ALIGNMENT_LINKED, true);
        long aligmentLength = in.getLongAttribute(ATTR_ALIGNMENT);
        int chartHeight = in.getIntegerAttribute(ATTR_HEIGHT);
        @NonNull ArrayList<@NonNull SeriesConfig> seriesConfigs = new ArrayList<SeriesConfig>();
        @NonNull TIntHashSet clustersToCreate = new TIntHashSet();
        String marker = in.getMarker();
        while ((tag = in.nextTag(marker)) != null) {
            if (TAG_SERIES.equals(tag)) {
                boolean matchWithAndExpressionBothProvided;
                RGB color = RGBUtils.decode(DEFAULT_COLOR);
                RGBUtils.decode(in.getAttribute(ATTR_COLOR, RGBUtils.encode(color)), color);
                @NonNull String seriesExpr = in.getAttribute(ATTR_EXPRESSION, "");
                @NonNull String name = in.getAttribute(ATTR_NAME, "");
                @NonNull String descp = in.getAttribute(ATTR_DESCRIPTION, "");
                @NonNull String units = in.getAttribute(ATTR_UNITS, "");
                @NonNull String display = in.getAttribute(ATTR_DISPLAY, "");
                @NonNull CounterDisplay counterDisplay = display.isEmpty() ? CounterDisplay.getDefault() : CounterDisplay.getDisplay((String)display);
                boolean hasAttributeMatchWith = in.hasAttribute(ATTR_MATCHWITH);
                boolean bl = in.hasAttribute(ATTR_EXPRESSION);
                boolean hasAttributeAutoRotate = in.hasAttribute(ATTR_AUTO_ROTATE_COLOR);
                boolean hasAtributeColorList = in.hasAttribute(ATTR_COLOR_LIST);
                @NonNull String colorList = in.getAttribute(ATTR_COLOR_LIST, "");
                @NonNull String matchwith = in.getAttribute(ATTR_MATCHWITH, "");
                boolean bl2 = matchWithAndExpressionBothProvided = hasAttributeMatchWith && bl;
                if (matchWithAndExpressionBothProvided) {
                    String warningMessage = String.format("Series %s contains both a %s tag and an %s tag, please only provide one", name, ATTR_MATCHWITH, ATTR_EXPRESSION);
                    StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)warningMessage, null);
                    continue;
                }
                AbstractSeriesConfig create = hasAttributeMatchWith ? WildcardSeriesConfig.create(name, descp, matchwith, counterDisplay, units, color, !hasAttributeAutoRotate && !hasAtributeColorList || in.isAttributeSet(ATTR_AUTO_ROTATE_COLOR), colorList) : SeriesConfig.create(name, descp, seriesExpr, counterDisplay, units, color);
                seriesConfigs.add((SeriesConfig)create);
                if (expandCluster) {
                    clustersToCreate.addAll((TIntCollection)ChartAndSeriesXMLParser.getExpandSeriesClusters(sourceClusterMap, seriesExpr));
                }
            }
            in.skip();
        }
        if (clustersToCreate.isEmpty()) {
            @NonNull ChartConfig config = new ChartConfig(title, seriesComposition, mRenderingType, isHeatMapLineEnabled, isAverageSelection, isAvgCores, isPercentage, isChartsOpen, isAlignmnetLinked, aligmentLength, chartHeight, perVmNonUPID);
            @NonNull ChartAndSeriesConfig chartAndSeriesConfig = new ChartAndSeriesConfig(config);
            chartAndSeriesConfig.addAllSeries(seriesConfigs);
            clusterConfigs.add(chartAndSeriesConfig);
        } else {
            int[] array = clustersToCreate.toArray();
            Arrays.sort(array);
            int[] nArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                int clusterId = nArray[n2];
                @NonNull String expandedTitle = title + VariableReplacerConstants.clusterTitleId((int)clusterId);
                @NonNull ChartConfig config = new ChartConfig(expandedTitle, seriesComposition, mRenderingType, isHeatMapLineEnabled, isAverageSelection, isAvgCores, isPercentage, isChartsOpen, isAlignmnetLinked, aligmentLength, chartHeight, perVmNonUPID);
                @NonNull ChartAndSeriesConfig chartAndSeriesConfig = new ChartAndSeriesConfig(config);
                for (AbstractSeriesConfig abstractSeriesConfig : seriesConfigs) {
                    Set<String> variableSetFromExpression;
                    String expression = abstractSeriesConfig.getExpression();
                    if (expression == null || !ChartAndSeriesXMLParser.canSeriesBeAdded(sourceClusterMap, variableSetFromExpression = ChartUtility.getVariableSetFromExpression(expression), clusterId)) continue;
                    for (String var : variableSetFromExpression) {
                        if (!sourceClusterMap.containsKey(var)) continue;
                        String expandedExpr = var + VariableReplacerConstants.clusterSuffixId((int)clusterId);
                        String regex = "(\\Q$\\E" + var + "\\b(?!\\Q.\\ECluster\\d+))";
                        expression = expression.replaceAll(regex, "\\$" + expandedExpr);
                    }
                    AbstractSeriesConfig clonedSeriesConfig = abstractSeriesConfig.clone();
                    clonedSeriesConfig.setExpression(expression);
                    chartAndSeriesConfig.addSeries(clonedSeriesConfig);
                }
                clusterConfigs.add(chartAndSeriesConfig);
                ++n2;
            }
        }
        return clusterConfigs;
    }

    private static boolean canSeriesBeAdded(@NonNull Map<@NonNull String, @NonNull TIntSet> sourceClusterMap, Set<@NonNull String> variableSetFromExpression, int clusterId) {
        int noClusterSourceCount = 0;
        for (String var : variableSetFromExpression) {
            if (sourceClusterMap.containsKey(var)) {
                if (!((TIntSet)NullChecking.neverNull((Object)sourceClusterMap.get(var))).contains(clusterId)) continue;
                return true;
            }
            ++noClusterSourceCount;
        }
        return noClusterSourceCount == variableSetFromExpression.size();
    }

    private static @NonNull TIntSet getExpandSeriesClusters(@NonNull Map<@NonNull String, @NonNull TIntSet> sourceClusterMap, @NonNull String seriesExpr) {
        @NonNull TIntHashSet totalClusterIds = new TIntHashSet();
        @NonNull Set<@NonNull String> variableSetFromExpression = ChartUtility.getVariableSetFromExpression(seriesExpr);
        for (String var : variableSetFromExpression) {
            if (!sourceClusterMap.containsKey(var)) continue;
            @NonNull TIntSet clusterIds = (TIntSet)NullChecking.neverNull((Object)sourceClusterMap.get(var));
            totalClusterIds.addAll((TIntCollection)clusterIds);
        }
        return totalClusterIds;
    }

    public static void save(XMLGenerator xml, @NonNull List<@NonNull ChartAndSeriesConfig> configs) throws IOException {
        for (ChartAndSeriesConfig config : configs) {
            @NonNull List<@NonNull AbstractSeriesConfig> series = config.getUnexpandedSeries();
            if (series.isEmpty()) {
                xml.startEmptyTag(TAG_CHART);
            } else {
                xml.startTag(TAG_CHART);
            }
            @NonNull ChartConfig chart = config.getChart();
            xml.addAttribute(ATTR_TITLE, chart.getTitle());
            SeriesComposition seriesComposition = chart.getSeriesComposition();
            xml.addAttribute(ATTR_SERIES_COMPOSITION, seriesComposition.toString());
            if (seriesComposition != SeriesComposition.VISUAL_ANNOTATION) {
                xml.addAttribute(ATTR_RENDERING_TYPE, chart.getRenderingType().toString());
            } else {
                // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable AbstractPerVmId.PerVmNonUniquePid perVmNonUPID = chart.getID();
                xml.addAttribute(ATTR_ID, ((AbstractPerVmId.PerVmNonUniquePid)NullChecking.neverNull((Object)perVmNonUPID)).id);
                xml.addAttribute(ATTR_VMUID, ((AbstractPerVmId.PerVmNonUniquePid)NullChecking.neverNull((Object)perVmNonUPID)).vmUID);
            }
            xml.addAttributeNot(ATTR_AVERAGE_SELECTION, chart.isAverageSelection(), false);
            xml.addAttributeNot(ATTR_AVERAGE_CORES, chart.isAverageCores(), false);
            xml.addAttributeNot(ATTR_PERCENTAGE, chart.isPercentage(), false);
            xml.addAttributeNot(ATTR_OPEN, chart.isOpen(), false);
            xml.addAttributeNot(ATTR_HEATMAPLINE_ENABLED, chart.isHeatMapLineEnabled(), false);
            xml.addAttributeNot(ATTR_HEIGHT, chart.getHeight(), 0);
            xml.addAttributeNot(ATTR_ALIGNMENT_LINKED, chart.isAlignmentLinked(), true);
            xml.addAttributeNot(ATTR_ALIGNMENT, chart.getAlignment(), 0L);
            if (series.isEmpty()) continue;
            List<@NonNull AbstractSeriesConfig> allUnExpandedSeries = ChartAndSeriesXMLParser.getAllUnexpandedSeries(series);
            for (AbstractSeriesConfig seriesTemplate : allUnExpandedSeries) {
                xml.startEmptyTag(TAG_SERIES);
                xml.addAttribute(ATTR_NAME, seriesTemplate.getName());
                if (seriesTemplate.isWildcardSeries()) {
                    xml.addAttribute(ATTR_MATCHWITH, seriesTemplate.getMatchWith());
                    xml.addAttribute(ATTR_AUTO_ROTATE_COLOR, seriesTemplate.isAutoRotateColor());
                    if (seriesTemplate.getColorList().size() > 0) {
                        xml.addAttribute(ATTR_COLOR_LIST, WildcardSeriesConfigUtility.getStringFromColorList(seriesTemplate.getColorList()));
                    }
                } else {
                    xml.addAttribute(ATTR_EXPRESSION, seriesTemplate.getExpression());
                }
                xml.addAttribute(ATTR_DESCRIPTION, seriesTemplate.getDescriptionFormat());
                xml.addAttribute(ATTR_DISPLAY, seriesTemplate.getDisplay().toString());
                xml.addAttribute(ATTR_COLOR, RGBUtils.encode(seriesTemplate.getColor()));
                xml.addAttributeNotEmpty(ATTR_UNITS, seriesTemplate.getUnits());
            }
            xml.endTag();
        }
    }

    private static @NonNull List<@NonNull AbstractSeriesConfig> getAllUnexpandedSeries(@NonNull List<@NonNull AbstractSeriesConfig> series) {
        return series.stream().map(c -> {
            if (c.isExpandedSeries()) {
                return (AbstractSeriesConfig)NullChecking.neverNull((Object)((SeriesConfig)c).getExpandedFromWildCard());
            }
            return c;
        }).distinct().collect(Collectors.toList());
    }
}

