/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.cam;

import com.arm.streamline.analysis.model.cam.ICAMDataProvider;
import com.arm.streamline.analysis.model.cam.ICAMTrackProvider;
import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.StreamUtils;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.cam.CAMData;
import com.arm.streamline.model.cam.CAMIcon;
import com.arm.streamline.model.cam.CAMJob;
import com.arm.streamline.model.cam.CAMTrack;
import com.arm.streamline.model.cam.CAMViewConfig;
import com.arm.streamline.utility.RGBUtils;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAM_Model
implements ICAMDataProvider {
    public static final String CAM_BASE_DIR = "cam" + FilePath.PATH_SEPARATOR;
    public static final String CAM_TRACKS_FILE = "tracks.bin";
    public static final String CAM_JOBS_FILE = "jobs.bin";
    public static final String CAM_COOKIES_FILE = "cookies.txt";
    private static final Integer GET_ALL_TRACKS = null;
    private CAMViewConfig mCAMViewConfig;
    private Analysis mAnalysis;
    private List<CAMTrack> mLoadedTracks = new ArrayList<CAMTrack>();
    private List<@NonNull CAMTrack> mTracks = new ArrayList<CAMTrack>();
    private TIntObjectHashMap<CAMJob> mJobs = new TIntObjectHashMap();
    private TIntObjectHashMap<String> mCookies = new TIntObjectHashMap();
    private TIntIntHashMap mPrimaryDependencies = new TIntIntHashMap();
    private final @NonNull ZoomLevel[] mZoomLevels;
    private CAMData[] mFiles;
    private int @NonNull [] mColorPalette = AnnotationColour.DARK_COLOR_PALETTE;
    private TIntHashSet mCyclicEvents = new TIntHashSet();
    private long mMaxDuration = 0L;
    private long mLastTime = 0L;
    private int mMaxDependencies = 0;
    private int mMaxCommandStringLength = 0;
    private int mMaxEventId = 0;
    private int mBinStart;
    private int mBinStop;
    private int mPrevStart;
    private int mPrevStop;
    private @Nullable ZoomLevel mPrevZoomLevel;
    private ArrayList<ArrayList<CAMJob>> mPrevJobs = new ArrayList();

    public static @NonNull File getCamPath(@NonNull File rootDirectory) {
        return new File(rootDirectory, CAM_BASE_DIR);
    }

    public static @NonNull File getVmPath(@NonNull File rootDirectory, long vmUID) {
        File camBaseDir = CAM_Model.getCamPath(rootDirectory);
        return new File(camBaseDir, Long.toString(vmUID));
    }

    public static @NonNull File getViewPath(@NonNull File rootDirectory, long vmUID, @NonNull String viewName) {
        File vmBaseDir = CAM_Model.getVmPath(rootDirectory, vmUID);
        File viewDir = new File(vmBaseDir, viewName);
        return viewDir;
    }

    public static @NonNull File findViewPath(@NonNull File rootDirectory, long vmUID, @NonNull String viewName) {
        File camBaseDir;
        File viewDir;
        File result = CAM_Model.getViewPath(rootDirectory, vmUID, viewName);
        if (!result.isDirectory() && vmUID == 0L && (viewDir = new File(camBaseDir = CAM_Model.getCamPath(rootDirectory), viewName)).isDirectory()) {
            result = viewDir;
        }
        return result;
    }

    public static int getCyclicColor(int c) {
        return AnnotationColour.DARK_COLOR_PALETTE[c];
    }

    private static @NonNull File getCookiesFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, CAM_COOKIES_FILE));
    }

    private static @NonNull File getItemsFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, CAM_JOBS_FILE));
    }

    private static @NonNull File getTracksFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, CAM_TRACKS_FILE));
    }

    public CAM_Model(Analysis analysis, @NonNull File reportDir, CAMViewConfig config) {
        this.mAnalysis = analysis;
        this.mCAMViewConfig = config;
        this.mZoomLevels = this.mAnalysis.getScales().getAvailableZoomLevels();
        this.mFiles = new CAMData[this.mZoomLevels.length];
        try {
            Object values;
            int length;
            DataInputStream in;
            Object var5_11;
            Throwable throwable;
            try {
                throwable = null;
                var5_11 = null;
                try {
                    in = new DataInputStream(StreamUtils.createBufferedAndDecompressedInput((File)CAM_Model.getCookiesFile(reportDir)));
                    try {
                        while (in.available() > 0) {
                            int cookieId = in.readInt();
                            length = in.readInt();
                            values = new byte[length];
                            in.readFully((byte[])values);
                            String cookie = new String((byte[])values, StandardCharsets.UTF_8);
                            this.mCookies.put(cookieId, (Object)cookie);
                            this.mMaxCommandStringLength = Math.max(this.mMaxCommandStringLength, cookie.length());
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            try {
                throwable = null;
                var5_11 = null;
                try {
                    in = new DataInputStream(StreamUtils.createBufferedAndDecompressedInput((File)CAM_Model.getTracksFile(reportDir)));
                    try {
                        while (in.available() > 0) {
                            int trackID = in.readInt();
                            length = in.readInt();
                            values = new byte[length];
                            in.readFully((byte[])values);
                            String title = new String((byte[])values, StandardCharsets.UTF_8);
                            int parentTrackId = in.readInt();
                            CAMTrack track = new CAMTrack(this, trackID, parentTrackId, title);
                            this.mLoadedTracks.add(track);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            Collections.sort(this.mLoadedTracks, new Comparator<CAMTrack>(){

                @Override
                public int compare(CAMTrack t1, CAMTrack t2) {
                    return Long.valueOf(t1.getId()).compareTo(Long.valueOf(t2.getId()));
                }
            });
            ArrayList<ArrayList<Integer>> children = new ArrayList<ArrayList<Integer>>();
            long captureDuration = Scales.mapDensestBinIndexToMicroseconds((int)this.mAnalysis.getLastBin(Scales.DENSEST_POSSIBLE_ZOOM_LEVEL)) * 1000L;
            try {
                Throwable trackID = null;
                Object length22 = null;
                try (DataInputStream in2 = new DataInputStream(StreamUtils.createBufferedAndDecompressedInput((File)CAM_Model.getItemsFile(reportDir)));){
                    while (in2.available() > 0) {
                        int uid = in2.readInt();
                        int track = in2.readInt();
                        int cookies = in2.readInt();
                        long startTime = in2.readLong();
                        long duration = in2.readLong();
                        int primaryDependency = in2.readInt();
                        int dependencyCount = in2.readInt();
                        TIntArrayList dependencies = new TIntArrayList();
                        int i = 0;
                        while (i < dependencyCount) {
                            int id = in2.readInt();
                            dependencies.add(id);
                            children.add(new ArrayList<Integer>(Arrays.asList(id, uid)));
                            ++i;
                        }
                        long stopTime = startTime + duration;
                        this.mMaxDependencies = Math.max(this.mMaxDependencies, dependencyCount);
                        this.mLastTime = Math.max(this.mLastTime, stopTime);
                        this.mMaxEventId = Math.max(this.mMaxEventId, uid);
                        int colorValue = in2.readInt();
                        int colorTemplate = colorValue >> 24 & 0xFF;
                        AnnotationColour annotationColour = new AnnotationColour(colorValue);
                        int color = switch (annotationColour.getClassification()) {
                            case AnnotationColour.AnnotationColourClassification.ROTATE -> {
                                this.mCyclicEvents.add(uid);
                                yield RGBUtils.toInt(RGBUtils.BLACK);
                            }
                            case AnnotationColour.AnnotationColourClassification.TEMPLATE_0, AnnotationColour.AnnotationColourClassification.TEMPLATE_1, AnnotationColour.AnnotationColourClassification.TEMPLATE_2, AnnotationColour.AnnotationColourClassification.TEMPLATE_3 -> this.mColorPalette[colorTemplate - 1];
                            default -> {
                                @Nullable Integer decodedColor = annotationColour.mapCounterColour();
                                yield decodedColor != null ? decodedColor : -3092272;
                            }
                        };
                        in2.readInt();
                        String detailText = in2.readUTF();
                        startTime = Math.max(startTime, 0L);
                        stopTime = Math.min(stopTime, captureDuration);
                        CAMJob job = new CAMJob(this, uid, track, cookies, startTime, stopTime, primaryDependency, dependencies.toArray(), color, colorTemplate, detailText);
                        this.mJobs.put(uid, (Object)job);
                        if (primaryDependency == -1) continue;
                        this.mPrimaryDependencies.put(primaryDependency, uid);
                    }
                }
                catch (Throwable length22) {
                    if (trackID == null) {
                        trackID = length22;
                    } else if (trackID != length22) {
                        trackID.addSuppressed(length22);
                    }
                    throw trackID;
                }
            }
            catch (EOFException trackID) {
                // empty catch block
            }
            Collections.sort(children, new Comparator<ArrayList<Integer>>(){

                @Override
                public int compare(ArrayList<Integer> t1, ArrayList<Integer> t2) {
                    return t1.get(0).compareTo(t2.get(0));
                }
            });
            int parentId = -1;
            TIntHashSet childEvents = new TIntHashSet();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                values = (ArrayList)iterator.next();
                int parent = (Integer)((ArrayList)values).get(0);
                int child = (Integer)((ArrayList)values).get(1);
                if (parent != parentId) {
                    if (childEvents.size() > 0 && this.mJobs.containsKey(parentId)) {
                        ((CAMJob)this.mJobs.get(parentId)).setDependents(childEvents.toArray());
                    }
                    parentId = parent;
                    childEvents.clear();
                }
                childEvents.add(child);
            }
            if (childEvents.size() > 0 && this.mJobs.containsKey(parentId)) {
                ((CAMJob)this.mJobs.get(parentId)).setDependents(childEvents.toArray());
            }
            TIntObjectIterator itr = this.mJobs.iterator();
            while (itr.hasNext()) {
                itr.advance();
                this.addPrimaryDependents((CAMJob)this.mJobs.get(itr.key()));
            }
            this.calculateMaxDuration();
        }
        catch (IOException exception) {
            this.mTracks = new ArrayList<CAMTrack>();
        }
        int index = 0;
        while (index < this.mZoomLevels.length) {
            ZoomLevel zoomLevel = this.mZoomLevels[index];
            this.mFiles[index] = new CAMData(reportDir, zoomLevel);
            ++index;
        }
        this.applyCyclicColors();
        this.applyPalettedColors();
        this.generateTrackHierarchy();
    }

    public TIntObjectHashMap<CAMJob> getAllJobsAsHashMap() {
        return this.mJobs;
    }

    public @NonNull List<@NonNull CAMJob> getAllJobsAsList() {
        return this.getAllTrackJobsAsList(GET_ALL_TRACKS);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull CAMJob> getAllTrackJobsAsList(@Nullable Integer trackID) {
        ArrayList<CAMJob> list;
        if (trackID != null) {
            list = new ArrayList<CAMJob>();
            TIntObjectIterator itr = this.mJobs.iterator();
            while (itr.hasNext()) {
                itr.advance();
                CAMJob item = (CAMJob)itr.value();
                assert (item != null);
                if (item.getTrackID() != trackID.intValue()) continue;
                list.add(item);
            }
        } else {
            @NonNull Collection jobsCollection = this.mJobs.valueCollection();
            list = new ArrayList(jobsCollection);
        }
        Collections.sort(list, new Comparator<CAMJob>(){

            @Override
            public int compare(@NonNull CAMJob i1, @NonNull CAMJob i2) {
                return Long.compare(i1.getStartTime(), i2.getStartTime());
            }
        });
        return list;
    }

    public String getCookie(int cookieId) {
        return (String)this.mCookies.get(cookieId);
    }

    public char getHotKey() {
        return this.mCAMViewConfig.getHotKey();
    }

    public CAMJob getJob(int jobID) {
        return (CAMJob)this.mJobs.get(jobID);
    }

    public ArrayList<ArrayList<CAMJob>> getJobsInRange() {
        @NonNull ZoomLevel zoomLevel = this.mAnalysis.getScales().getZoomLevel();
        if (zoomLevel.equals((Object)this.mPrevZoomLevel) && this.mBinStart == this.mPrevStart && this.mBinStop == this.mPrevStop) {
            return this.mPrevJobs;
        }
        int index = this.mZoomLevels.length - 1;
        while (index > 0) {
            if (zoomLevel.equals((Object)this.mZoomLevels[index])) break;
            --index;
        }
        CAMData file = this.mFiles[index];
        ArrayList<TIntArrayList> dataBlocks = file.getDataBlocks(this.mBinStart, this.mBinStop - this.mBinStart + 1);
        ArrayList<ArrayList<CAMJob>> result = new ArrayList<ArrayList<CAMJob>>();
        TIntHashSet cmdSet = new TIntHashSet();
        for (TIntArrayList binlist : dataBlocks) {
            ArrayList<CAMJob> commands = new ArrayList<CAMJob>();
            if (binlist != null) {
                int[] cmdlist;
                int[] nArray = cmdlist = binlist.toArray();
                int n = cmdlist.length;
                int n2 = 0;
                while (n2 < n) {
                    int cmd = nArray[n2];
                    if (cmd != -1 && !cmdSet.contains(cmd)) {
                        CAMJob eventItem = (CAMJob)this.mJobs.get(cmd);
                        if (eventItem != null) {
                            commands.add(eventItem);
                        }
                        cmdSet.add(cmd);
                    }
                    ++n2;
                }
            }
            result.add(commands);
        }
        this.mPrevZoomLevel = zoomLevel;
        this.mPrevStart = this.mBinStart;
        this.mPrevStop = this.mBinStop;
        this.mPrevJobs = result;
        return result;
    }

    public long getLastTime() {
        return this.mLastTime;
    }

    public int getMaxCommandStringLength() {
        return this.mMaxCommandStringLength;
    }

    public int getMaxDependencies() {
        return this.mMaxDependencies;
    }

    public long getMaxDuration() {
        return this.mMaxDuration;
    }

    public int getMaxEventId() {
        return this.mMaxEventId;
    }

    public String getName() {
        return this.mCAMViewConfig.getName();
    }

    public TIntIntHashMap getPrimaryDependencies() {
        return this.mPrimaryDependencies;
    }

    public void getPrimaryDependencies(CAMJob item, ArrayList<CAMJob> dependencies) {
        int dependencyId = item.getPrimaryDependencyID();
        while (dependencyId != -1) {
            CAMJob dependencyItem = (CAMJob)this.mJobs.get(dependencyId);
            dependencies.add(dependencyItem);
            dependencyId = dependencyItem.getPrimaryDependencyID() == dependencyId ? -1 : dependencyItem.getPrimaryDependencyID();
        }
    }

    public CAMTrack getTrack(int trackId) {
        for (CAMTrack track : this.mLoadedTracks) {
            if (track.getId() != trackId) continue;
            return track;
        }
        return null;
    }

    public List<CAMTrack> getTrackNonhierarchical() {
        return this.mLoadedTracks;
    }

    public @NonNull List<@NonNull ICAMTrackProvider> getTracks() {
        @NonNull ArrayList<@NonNull ICAMTrackProvider> list = new ArrayList<ICAMTrackProvider>();
        for (CAMTrack track : this.mTracks) {
            list.add(track);
        }
        return list;
    }

    public long initiatedTimeForEventChain(int eventId) {
        CAMJob job = this.getJob(eventId);
        while (job != null) {
            if (job.getPrimaryDependencyID() == -1) {
                return job.getStartTime();
            }
            job = this.getJob(job.getPrimaryDependencyID());
        }
        return -1L;
    }

    public boolean isClippedDependencyChain() {
        return this.mCAMViewConfig.isClipDependencyChain();
    }

    public boolean isOpenCL() {
        return this.mCAMViewConfig.getIcon() == CAMIcon.OPENCL;
    }

    public boolean isOpenGL() {
        return false;
    }

    public void removeJob(int itemId) {
        this.mJobs.remove(itemId);
    }

    public void setRange(int binStart, int binStop) {
        this.mBinStart = binStart;
        this.mBinStop = binStop;
    }

    public void switchPalette(StreamlineTheme theme) {
        switch (theme) {
            default: {
                this.mColorPalette = AnnotationColour.DARK_COLOR_PALETTE;
                break;
            }
            case LIGHT: {
                this.mColorPalette = AnnotationColour.LIGHT_COLOR_PALETTE;
            }
        }
        this.applyCyclicColors();
        this.applyPalettedColors();
    }

    private void addChildTracks(CAMTrack parentTrack) {
        for (CAMTrack track : this.mLoadedTracks) {
            if (track.getParentId() != parentTrack.getId()) continue;
            parentTrack.addChildTrack(track);
            if (track.getParentId() == -1) continue;
            this.addChildTracks(track);
        }
    }

    private void addPrimaryDependents(CAMJob item) {
        while (item.getPrimaryDependencyID() != -1) {
            CAMJob primaryDependencyItem = (CAMJob)this.mJobs.get(item.getPrimaryDependencyID());
            if (item.getPrimaryDependent() == primaryDependencyItem) continue;
            primaryDependencyItem.setPrimaryDependent(item.getId());
            item = primaryDependencyItem;
        }
    }

    private void applyCyclicColors() {
        int cyclicColor = 0;
        int cyclicColorMask = 3;
        TIntHashSet completed = new TIntHashSet();
        for (int eventId : this.mCyclicEvents) {
            CAMJob item = (CAMJob)this.mJobs.get(eventId);
            if (!completed.add(item.getId())) continue;
            item.setColor(this.mColorPalette[cyclicColor]);
            ArrayList<CAMJob> items = new ArrayList<CAMJob>();
            this.getPrimaryDependencies(item, items);
            for (CAMJob dependency : items) {
                dependency.setColor(this.mColorPalette[cyclicColor]);
                completed.add(dependency.getId());
            }
            ++cyclicColor;
            cyclicColor &= cyclicColorMask;
        }
    }

    private void applyPalettedColors() {
        TIntObjectIterator itr = this.mJobs.iterator();
        while (itr.hasNext()) {
            itr.advance();
            CAMJob eventItem = (CAMJob)itr.value();
            if (eventItem.getColorTemplate() < 1 || eventItem.getColorTemplate() > 4) continue;
            eventItem.setColor(this.mColorPalette[eventItem.getColorTemplate() - 1]);
        }
    }

    private void calculateMaxDuration() {
        TIntObjectIterator itr = this.mJobs.iterator();
        while (itr.hasNext()) {
            itr.advance();
            CAMJob eventItem = (CAMJob)itr.value();
            this.mMaxDuration = Math.max(this.mMaxDuration, eventItem.getStopTime() - this.initiatedTimeForEventChain(eventItem.getId()));
        }
    }

    private void generateTrackHierarchy() {
        for (CAMTrack track : this.mLoadedTracks) {
            if (track.getParentId() != -1) continue;
            this.mTracks.add(track);
            this.addChildTracks(track);
        }
    }

    public @Nullable Integer getOriginUtid() {
        return this.mCAMViewConfig.getOriginUtid();
    }
}

