/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.cam;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.report.model.IIndexedDataProvider;
import com.arm.streamline.report.model.IndexedFile;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;

public class CAMData
implements IIndexedDataProvider<TIntArrayList> {
    private IndexedFile<TIntArrayList> mFile;

    public CAMData(File reportDir, @NonNull ZoomLevel zoomLevel) {
        try {
            String path = "cam_" + zoomLevel.getBps() + ".bin";
            this.mFile = new IndexedFile(new File(reportDir, path), (IIndexedDataProvider)this, 512);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TIntArrayList getData(int index) {
        if (this.mFile != null) {
            try {
                return (TIntArrayList)this.mFile.getDataBlock((long)index);
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        return new TIntArrayList();
    }

    public ArrayList<TIntArrayList> getDataBlocks(int index, int count) {
        if (this.mFile != null) {
            try {
                return this.mFile.getDataBlocks(index, count);
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        ArrayList<TIntArrayList> empty = new ArrayList<TIntArrayList>();
        int i = 0;
        while (i < count) {
            empty.add(new TIntArrayList());
            ++i;
        }
        return empty;
    }

    public TIntArrayList loadData(byte[] data, boolean compressed) throws IOException {
        TIntArrayList result = new TIntArrayList();
        Throwable throwable = null;
        Object var5_6 = null;
        try (LittleEndianDataInputStream in = new LittleEndianDataInputStream(data, compressed);){
            while (in.available() > 0) {
                result.add(in.readLEInt());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }
}

