/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.bindata;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.report.model.IIndexedDataProvider;
import com.arm.streamline.report.model.IndexedFile;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BinDataAtScale
implements IIndexedDataProvider<byte[]> {
    public static final int BIN_DATA_CACHE_SIZE = 1024;
    private static final int NUMBER_OF_VALUES_PER_BLOCK = 3;
    private IndexedFile<byte[]> mFile;
    private boolean mAutoCloseFiles = true;
    public static final int SYSTEM_WIDE_UTID = -1;
    public static final int UNKNOWN_UTID = -1;

    public BinDataAtScale(File directory, String selection, @NonNull ZoomLevel zoomLevel) throws IOException {
        int binsPerSecond = zoomLevel.getBps();
        File indexFile = new File(directory, selection + binsPerSecond + ".bin");
        if (!indexFile.exists()) {
            indexFile = new File(directory, CounterDisplay.getSelectionDefault() + binsPerSecond + ".bin");
        }
        if (!indexFile.exists()) {
            throw new IOException();
        }
        this.mFile = new IndexedFile(indexFile, (IIndexedDataProvider)this, 1024);
    }

    public void closeFiles() {
        if (this.mFile != null) {
            this.mFile.cleanup();
        }
    }

    public int getDataBlockCount() {
        if (this.mFile != null) {
            return this.mFile.getDataBlockCount();
        }
        return 0;
    }

    public long getValue(long bin, int core, @Nullable TIntSet tids) {
        if (bin < 0L || bin >= (long)this.getDataBlockCount()) {
            return 0L;
        }
        long[] values = null;
        try {
            byte[] buffer = null;
            buffer = this.mAutoCloseFiles ? (byte[])this.mFile.getDataBlock((long)((int)bin)) : (byte[])this.mFile.getDataBlockNoCleanup((long)((int)bin));
            values = Compression.unpackIntsOptimized((byte[])buffer);
        }
        catch (Exception exception) {
            CommonPlugin.error((Throwable)exception);
            return 0L;
        }
        if (values == null) {
            return 0L;
        }
        long value = 0L;
        int i = 0;
        while (i < values.length) {
            int id = (int)values[i + 0];
            int c = (int)values[i + 1];
            long v = values[i + 2];
            if (c == core && (tids == null || tids.contains(id))) {
                value += v;
            }
            i += 3;
        }
        return value;
    }

    public byte[] loadData(byte[] data, boolean compressed) throws IOException {
        return data;
    }

    public void setAutoCloseFiles(boolean autoCloseFiles) {
        this.mAutoCloseFiles = autoCloseFiles;
    }
}

