/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.annotation;

import com.arm.streamline.analysis.model.AnnotationDataStructure;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class ChannelsFile {
    public static final @NonNull String CHANNELS_FILE = "channels.xml";
    private static final String TAG_CHANNELS = "channels";
    private static final String TAG_THREAD = "thread";
    private static final String ATTR_ID = "id";
    private static final String TAG_GROUP = "group";
    private static final String TAG_CHANNEL = "channel";
    private static final String ATTR_NUMBER = "number";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ORIGINAL = "original";
    private AnnotationDataStructure mADS;

    public ChannelsFile(@NonNull File reportDir) throws IOException {
        block11: {
            this.mADS = new AnnotationDataStructure();
            XMLParser in = null;
            try {
                String tag;
                File fullPath = new File(new File(reportDir, "annotate"), CHANNELS_FILE);
                File channelsFile = CommonFileUtils.getFile((File)fullPath);
                if (!channelsFile.isFile()) break block11;
                in = XMLParser.create((File)channelsFile);
                while ((tag = in.nextTag()) != null) {
                    if (TAG_CHANNELS.equals(tag)) {
                        String marker = in.getMarker();
                        while ((tag = in.nextTag(marker)) != null) {
                            if (TAG_THREAD.equals(tag)) {
                                int thread = in.getIntegerAttribute(ATTR_ID, 0);
                                String marker2 = in.getMarker();
                                while ((tag = in.nextTag(marker2)) != null) {
                                    if (TAG_GROUP.equals(tag)) {
                                        Integer originalGroupNumber;
                                        boolean hasOriginalGroupNumber = in.hasAttribute(ATTR_ORIGINAL);
                                        int groupNumber = in.getIntegerAttribute(ATTR_NUMBER, 0);
                                        String rawGroupName = in.getAttribute(ATTR_NAME, "");
                                        Integer n = originalGroupNumber = hasOriginalGroupNumber ? Integer.valueOf(in.getIntegerAttribute(ATTR_ORIGINAL)) : null;
                                        Object groupName = !rawGroupName.isEmpty() ? rawGroupName : (originalGroupNumber == null ? "Group " + groupNumber : "Group " + String.valueOf(originalGroupNumber));
                                        String marker3 = in.getMarker();
                                        while ((tag = in.nextTag(marker3)) != null) {
                                            if (TAG_CHANNEL.equals(tag)) {
                                                Integer originalChannelNumber;
                                                boolean hasOriginalChannelNumber = in.hasAttribute(ATTR_ORIGINAL);
                                                int channelNumber = in.getIntegerAttribute(ATTR_NUMBER, 0);
                                                String rawChannelName = in.getAttribute(ATTR_NAME, "");
                                                Integer n2 = originalChannelNumber = hasOriginalChannelNumber ? Integer.valueOf(in.getIntegerAttribute(ATTR_ORIGINAL)) : null;
                                                Object channelName = !rawChannelName.isEmpty() ? rawChannelName : (originalChannelNumber == null ? "Channel " + channelNumber : "Channel " + String.valueOf(originalChannelNumber));
                                                this.mADS.addGroupName(thread, groupNumber, (String)groupName, originalGroupNumber);
                                                this.mADS.addChannelName(thread, channelNumber, groupNumber, (String)channelName, originalGroupNumber, originalChannelNumber);
                                            }
                                            in.skip();
                                        }
                                        continue;
                                    }
                                    in.skip();
                                }
                                continue;
                            }
                            in.skip();
                        }
                        continue;
                    }
                    in.skip();
                }
            }
            finally {
                CommonFileUtils.ignoredClose(in);
            }
        }
    }

    public AnnotationDataStructure getAnnotationDataStructure() {
        return this.mADS;
    }
}

