/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.annotation;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.annotation.AnnotationTimesliceData;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IIndexedDataProvider;
import com.arm.streamline.report.model.IndexedFile;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;

public class Annotations
implements IIndexedDataProvider<HashMap<ICallPath, AnnotationTimesliceData>> {
    public static final String ANNOTATE = "annotate";
    public static final String LOG = "annotate/log";
    public static final String MAP = "annotate/map";
    public static final String IMAGES = "annotate/images";
    public static final String THUMBNAILS = "annotate/thumbnails";
    public static final String VISUAL = "annotate/visual";
    public static final String LOGGING = "annotate/log/logging.bin";
    public static final String STRINGS_MAP = "annotate/map/strings.bin";
    public static final String IMAGES_MAP = "annotate/map/images.bin";
    private static final int START_FRAME_MASK = 0x1000000;
    private static final int END_FRAME_MASK = 0x2000000;
    private static final int LINK_ID_MASK = 0xFFFFFF;
    private Analysis mAnalysis;
    private IndexedFile<HashMap<ICallPath, AnnotationTimesliceData>> mFile;

    public Annotations() {
    }

    public Annotations(Analysis analysis, @NonNull ZoomLevel zoomLevel) throws IOException {
        this.mAnalysis = analysis;
        this.mFile = new IndexedFile(new File(this.mAnalysis.getReportDirectory(), "annotate/log/data_" + zoomLevel.getBps() + ".bin"), (IIndexedDataProvider)this, 1024);
    }

    public HashMap<ICallPath, AnnotationTimesliceData> getData(int index) {
        if (this.mFile != null) {
            try {
                return (HashMap)this.mFile.getDataBlock((long)index);
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        return new HashMap<ICallPath, AnnotationTimesliceData>();
    }

    public ArrayList<HashMap<ICallPath, AnnotationTimesliceData>> getDataBlocks(int index, int count) {
        if (this.mFile != null) {
            try {
                return this.mFile.getDataBlocks(index, count);
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        ArrayList<HashMap<ICallPath, AnnotationTimesliceData>> empty = new ArrayList<HashMap<ICallPath, AnnotationTimesliceData>>();
        int i = 0;
        while (i < count) {
            empty.add(new HashMap());
            ++i;
        }
        return empty;
    }

    public int getSize() {
        return this.mFile != null ? this.mFile.getDataBlockCount() : 0;
    }

    /*
     * Unable to fully structure code
     */
    public HashMap<ICallPath, AnnotationTimesliceData> loadData(byte[] data, boolean compressed) throws IOException {
        result = new HashMap<ICallPath, AnnotationTimesliceData>();
        if (this.mAnalysis != null) {
            callPaths = this.mAnalysis.getInstructionCounterModel().getCallPaths();
            try {
                var5_5 = null;
                var6_8 = null;
                try {
                    in = new LittleEndianDataInputStream(data, compressed);
                    try {
                        block7: while (true) {
                            if ((id = in.readLEInt()) == -1) {
                                break;
                            }
                            startFrame = (id & 0x1000000) == 0x1000000;
                            endFrame = (id & 0x2000000) == 0x2000000;
                            callPath = callPaths.getCallPathByID(id & 0xFFFFFF);
                            channel = in.readLEInt();
                            recordCount = in.readLEUnsignedShort();
                            if (callPath != null) {
                                if (recordCount <= 0) continue;
                                annotationData = result.get(callPath);
                                if (annotationData == null) {
                                    annotationData = new AnnotationTimesliceData(callPath, channel, startFrame, endFrame);
                                    result.put(callPath, annotationData);
                                } else {
                                    annotationData.add(channel, startFrame, endFrame);
                                }
                                annotationData.prepareForMoreLabels(recordCount);
                                i = 0;
                                while (true) {
                                    if (i >= recordCount) continue block7;
                                    stringID = in.readLEInt();
                                    label = this.mAnalysis.getMessage(stringID);
                                    annotationData.addLabel(channel, label);
                                    ++i;
                                }
                            }
                            i = 0;
                            while (true) {
                                if (i < recordCount) ** break;
                                continue block7;
                                in.readLEInt();
                                ++i;
                            }
                            break;
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable var6_9) {
                    if (var5_5 == null) {
                        var5_5 = var6_9;
                    } else if (var5_5 != var6_9) {
                        var5_5.addSuppressed(var6_9);
                    }
                    throw var5_5;
                }
            }
            catch (EOFException var5_7) {
                // empty catch block
            }
        }
        return result;
    }
}

