/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.utility.io.EditorInputUtils;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class SourceFileUiUtils {
    public static @Nullable IEditorInput createEditorInput(@NonNull SourceFile sourceFile) {
        IEditorInput input;
        if (!sourceFile.isBinary() && (input = EditorInputUtils.createWorkspaceInput(new File(sourceFile.getFullPath()))) != null && input.exists()) {
            return input;
        }
        return null;
    }

    public static String getEditorID(IFileStore fileStore) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(fileStore.getName(), SourceFileUiUtils.getContentType(fileStore));
        if (descriptor == null && editorRegistry.isSystemInPlaceEditorAvailable(fileStore.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (descriptor == null && editorRegistry.isSystemExternalEditorAvailable(fileStore.getName())) {
            descriptor = editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public static @Nullable IEditorPart open(@NonNull ISourceReference reference) throws CoreException {
        IEditorPart editor = SourceFileUiUtils.open(reference.getSourceFile());
        if (editor instanceof ITextEditor) {
            SourceFileUiUtils.select((ITextEditor)editor, reference);
        }
        return editor;
    }

    public static @Nullable IEditorPart open(@NonNull SourceFile sourceFile) throws CoreException {
        return SourceFileUiUtils.openWithDefaultEditor(SourceFileUiUtils.createEditorInput(sourceFile));
    }

    public static @Nullable IEditorPart openWithDefaultEditor(@Nullable IEditorInput input) throws PartInitException {
        return input != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, SourceFileUiUtils.getEditorID(EditorInputUtils.getFileStore(input))) : null;
    }

    public static void select(@NonNull ITextEditor editor, @NonNull ISourceReference reference) {
        int startLine = reference.getStartLine();
        if (startLine > 0) {
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int start = doc.getLineOffset(startLine - 1);
                int column = reference.getStartColumn();
                if (column > 0) {
                    start += column - 1;
                }
                editor.selectAndReveal(start, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static @Nullable IContentType getContentType(@Nullable IFileStore fileStore) {
        if (fileStore != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream stream = fileStore.openInputStream(0, null);){
                    return Platform.getContentTypeManager().findContentTypeFor(stream, fileStore.getName());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

