/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import java.nio.charset.StandardCharsets;
import org.eclipse.swt.graphics.RGB;

public class RGBString {
    public static final RGB DEFAULT = new RGB(96, 96, 96);
    private static final int ESCAPE_CODE = 27;
    private RGB mRGB;
    private String mString;

    public RGBString() {
        this.mRGB = DEFAULT;
        this.mString = "";
    }

    public RGBString(byte[] buffer) {
        int length = buffer.length;
        if (length > 3) {
            this.mRGB = buffer[0] == 27 ? new RGB(buffer[1] & 0xFF, buffer[2] & 0xFF, buffer[3] & 0xFF) : DEFAULT;
            this.mString = length > 4 ? new String(buffer, 4, length - 4, StandardCharsets.UTF_8) : "";
        } else {
            this.mRGB = DEFAULT;
            this.mString = new String(buffer, StandardCharsets.UTF_8);
        }
    }

    public RGB getRGB() {
        return this.mRGB;
    }

    public String getString() {
        return this.mString;
    }

    public String toString() {
        return this.mString;
    }
}

