/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.CountedInputStream;
import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.LogEntry;
import com.arm.streamline.model.ModelMessages;
import com.arm.streamline.model.annotation.AnnotationThread;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class LogEntriesFile {
    private @NonNull List<@NonNull LogEntry> mAllLogEntries = new ArrayList<LogEntry>();
    private @NonNull List<@NonNull LogEntry> mCurrentLogEntries = new ArrayList<LogEntry>();
    private long mLargestDuration;
    private long mLastTimelineMarker;
    private int mLongestMessage;
    private int mLongestGroup;
    private int mLongestChannel;

    private static @NonNull File getFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, "annotate/log/logging.bin"));
    }

    public LogEntriesFile(Analysis analysis, IProgressTracker tracker) throws IOException, InterruptedException {
        tracker.setSubTaskTitle(ModelMessages.LOG_ENTRIES);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (CountedInputStream cin = new CountedInputStream(LogEntriesFile.getFile(analysis.getReportDirectory()));){
                tracker.setProgressProvider((IProgressProvider)cin);
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (LittleEndianDataInputStream in = new LittleEndianDataInputStream((InputStream)cin);){
                    this.loadLogEntries(analysis, in, tracker);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                tracker.update();
                tracker.setProgressProvider(null);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fnfEx) {
            tracker.update();
            tracker.setProgressProvider(null);
        }
    }

    public List<LogEntry> getAllLogEntries() {
        return this.mAllLogEntries;
    }

    public int getCount() {
        return this.mAllLogEntries.size();
    }

    public @NonNull List<@NonNull LogEntry> getCurrentLogEntries() {
        return this.mCurrentLogEntries;
    }

    public long getDeltaBetweenFirstAndLast() {
        int count = this.mCurrentLogEntries.size();
        if (count > 1) {
            return this.mCurrentLogEntries.get(count - 1).getTimestamp() - this.mCurrentLogEntries.get(0).getTimestamp();
        }
        return 0L;
    }

    public long getLargestDuration() {
        return this.mLargestDuration;
    }

    public long getLastTimelineMarker() {
        return this.mLastTimelineMarker;
    }

    public int getLongestChannel() {
        return this.mLongestChannel;
    }

    public int getLongestGroup() {
        return this.mLongestGroup;
    }

    public int getLongestMessage() {
        return this.mLongestMessage;
    }

    public void setCurrentLogEntries(List<LogEntry> list) {
        this.mCurrentLogEntries.clear();
        this.mLastTimelineMarker = 0L;
        this.mLargestDuration = 0L;
        this.mLongestMessage = 0;
        this.mLongestGroup = 0;
        this.mLongestChannel = 0;
        for (LogEntry entry : list) {
            this.addEntry(entry);
        }
    }

    private void addEntry(LogEntry logEntry) {
        this.mLargestDuration = Math.max(this.mLargestDuration, logEntry.getDurationNanoseconds());
        this.mLastTimelineMarker = Math.max(this.mLastTimelineMarker, logEntry.getTimelineMarker());
        this.mLongestMessage = Math.max(this.mLongestMessage, logEntry.getMessage().length());
        this.mLongestGroup = Math.max(this.mLongestGroup, logEntry.getGroupName().length());
        this.mLongestChannel = Math.max(this.mLongestChannel, logEntry.getChannelName().length());
        this.mCurrentLogEntries.add(logEntry);
    }

    private void loadLogEntries(Analysis analysis, LittleEndianDataInputStream in, IProgressTracker tracker) throws IOException, InterruptedException {
        int count = 0;
        this.mLastTimelineMarker = 0L;
        this.mLargestDuration = 0L;
        this.mLongestMessage = 0;
        this.mLongestGroup = 0;
        this.mLongestChannel = 0;
        HashMap<AnnotationThread, LogEntry> threadMap = new HashMap<AnnotationThread, LogEntry>();
        while (true) {
            LogEntry logEntry;
            try {
                logEntry = new LogEntry(in, analysis, count++);
            }
            catch (EOFException eof) {
                break;
            }
            AnnotationThread at = new AnnotationThread(logEntry.getCallPath(), logEntry.getChannel(), logEntry.isVisualAnnotation());
            if (logEntry.isBookmark()) {
                logEntry.setEndTimelineMarker(logEntry.getTimelineMarker());
                logEntry.setEndTimestamp(logEntry.getTimestamp());
            } else {
                LogEntry previousOnThreadAndChannel = (LogEntry)threadMap.get(at);
                if (previousOnThreadAndChannel != null) {
                    if (logEntry.isTerminateMarker()) {
                        int delta = analysis.getScales().getMicrosecondsAtDensestScale();
                        previousOnThreadAndChannel.setEndTimelineMarker(logEntry.getTimelineMarker() + (long)delta);
                        previousOnThreadAndChannel.setEndTimestamp(logEntry.getTimestamp());
                    } else {
                        previousOnThreadAndChannel.setEndTimelineMarker(logEntry.getTimelineMarker());
                        previousOnThreadAndChannel.setEndTimestamp(logEntry.getTimestamp());
                    }
                }
                threadMap.put(at, logEntry);
            }
            if (!logEntry.isTerminateMarker()) {
                this.addEntry(logEntry);
                this.mAllLogEntries.add(logEntry);
            }
            tracker.update();
        }
    }
}

