/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.analysis.database.EventsChart;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IIndexedDataProvider;
import com.arm.streamline.report.model.IndexedFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Focus
implements IIndexedDataProvider<Map<ICallPath, TIntArrayList>> {
    public static final @NonNull String DEFAULT_FOCUS_SOURCE = "CPU Activity";
    public static final String FOCUS_PATH = "/timeline/focus/";
    private final @NonNull Analysis mAnalysis;
    private boolean mAutoCloseFiles = true;
    private final @NonNull Map<String, TIntObjectHashMap<IndexedFile<Map<@NonNull ICallPath, @NonNull TIntArrayList>>>> mFile = new HashMap<String, TIntObjectHashMap<IndexedFile<Map<ICallPath, TIntArrayList>>>>();
    private @Nullable String mFocusSource;
    private @Nullable EventsChart mFocusSourceEventsChart;
    private final @NonNull Map<@NonNull String, @NonNull EventsChart> mFocusSources = new LinkedHashMap<String, EventsChart>();
    private boolean mIsSlotData;
    private final int mMaxChannels;
    private int mSize;

    public Focus(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        File dir = new File(this.mAnalysis.getReportDirectory(), FOCUS_PATH);
        @NonNull File @Nullable [] files = dir.listFiles();
        String select = null;
        int maxChannels = 0;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                @Nullable EventsChart eventsChart = EventsChart.tryRead((File)file, (ProcessingElementReferenceSet)analysis.getProcessingElementsReferenceSet());
                if (eventsChart != null) {
                    this.mFocusSources.put(file.getName(), eventsChart);
                    maxChannels = Math.max(maxChannels, eventsChart.getChannelDescriptors().length);
                    if (select == null || DEFAULT_FOCUS_SOURCE.equals(file.getName())) {
                        select = file.getName();
                    }
                }
                ++n2;
            }
        }
        this.mMaxChannels = maxChannels;
        this.setFocus(select);
    }

    public void cleanup() {
        if (this.getScaledMap() != null) {
            this.getScaledMap().cleanup();
        }
    }

    public Map<@NonNull ICallPath, @NonNull TIntArrayList> getData(int index) {
        if (this.getScaledMap() != null) {
            try {
                if (this.mAutoCloseFiles) {
                    return (Map)this.getScaledMap().getDataBlock((long)index);
                }
                return (Map)this.getScaledMap().getDataBlockNoCleanup((long)index);
            }
            catch (IOException exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        return new HashMap<ICallPath, TIntArrayList>();
    }

    public int getDataBlockCount() {
        if (this.getScaledMap() != null) {
            return this.getScaledMap().getDataBlockCount();
        }
        return 0;
    }

    public @Nullable String getFocusSource() {
        return this.mFocusSource;
    }

    public @Nullable EventsChart getFocusSourceEventsChart() {
        return this.mFocusSourceEventsChart;
    }

    public @NonNull List<@NonNull String> getFocusSources() {
        return new ArrayList<String>(this.mFocusSources.keySet());
    }

    public int getMaxChannels() {
        return this.mMaxChannels;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public IndexedFile<Map<@NonNull ICallPath, @NonNull TIntArrayList>> getScaledMap() {
        ZoomLevel zoomLevel;
        IndexedFile scaledMap;
        @NonNull @NonNull TIntObjectHashMap focusedMap = this.mFile.get(this.mFocusSource);
        if (focusedMap == null) {
            focusedMap = new TIntObjectHashMap();
            this.mFile.put(this.mFocusSource, (TIntObjectHashMap<IndexedFile<Map<ICallPath, TIntArrayList>>>)focusedMap);
        }
        if ((scaledMap = (IndexedFile)focusedMap.get((zoomLevel = this.mAnalysis.getScales().getZoomLevel()).getBps())) == null) {
            int binsPerSecond;
            File dir = new File(this.mAnalysis.getReportDirectory(), FOCUS_PATH + this.mFocusSource);
            int scan = binsPerSecond = zoomLevel.getBps();
            int factor = 1;
            while (scan > 0) {
                try {
                    File dataFile = new File(dir, "data_" + scan + ".bin");
                    scaledMap = new IndexedFile(dataFile, (IIndexedDataProvider)this, 1024);
                    this.mSize = scaledMap.getDataBlockCount() * factor;
                    if (this.mSize == 0) {
                        throw new IOException();
                    }
                    if (scan == binsPerSecond) {
                        this.mIsSlotData = true;
                        focusedMap.put(binsPerSecond, (Object)scaledMap);
                        return scaledMap;
                    }
                    return null;
                }
                catch (Exception e) {
                    scan /= 10;
                    factor *= 10;
                }
            }
            return null;
        }
        return scaledMap;
    }

    public int getSize() {
        return this.mSize;
    }

    public Map<@NonNull ICallPath, @NonNull TIntArrayList> loadData(byte[] data, boolean compressed) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (LittleEndianDataInputStream in = new LittleEndianDataInputStream(data, compressed);){
            if (this.mIsSlotData) {
                return this.loadSlotData(in);
            }
            return new HashMap<ICallPath, TIntArrayList>();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setAutoCloseFiles(boolean autoCloseFiles) {
        this.mAutoCloseFiles = autoCloseFiles;
    }

    public void setFocus(@Nullable String focusSource) {
        String string = focusSource = focusSource != null ? focusSource : DEFAULT_FOCUS_SOURCE;
        if (!NullChecking.equalsNullable((Object)this.mFocusSource, (Object)focusSource)) {
            @Nullable EventsChart eventsChart = this.mFocusSources.get(focusSource);
            if (eventsChart != null) {
                this.mFocusSource = focusSource;
                this.mFocusSourceEventsChart = eventsChart;
            } else if (!DEFAULT_FOCUS_SOURCE.equals(focusSource)) {
                this.setFocus(DEFAULT_FOCUS_SOURCE);
            } else {
                this.mFocusSource = null;
                this.mFocusSourceEventsChart = null;
            }
        }
    }

    private @NonNull Map<@NonNull ICallPath, @NonNull TIntArrayList> loadSlotData(LittleEndianDataInputStream in) throws IOException {
        @NonNull HashMap<@NonNull ICallPath, @NonNull TIntArrayList> result = new HashMap<ICallPath, TIntArrayList>();
        @NonNull IInstructionCounterCallPaths callPaths = this.mAnalysis.getInstructionCounterModel().getCallPaths();
        try {
            while (true) {
                int percentage;
                byte reason;
                int core;
                byte[] data = new byte[6];
                in.readFully(data);
                int id = data[0] & 0xFF | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 16;
                if (data[3] < 0) {
                    core = -1;
                    reason = data[4];
                    percentage = 0;
                } else {
                    core = data[3] & 0xFF;
                    reason = 0;
                    percentage = data[4] & 0xFF | (data[5] & 0xFF) << 8;
                }
                int entry = percentage | reason << 16 | core << 24;
                ICallPath callPath = callPaths.getCallPathByID(id);
                if (callPath == null) continue;
                TIntArrayList list = (TIntArrayList)result.get(callPath);
                if (list == null) {
                    list = new TIntArrayList();
                    result.put(callPath, list);
                }
                list.add(entry);
            }
        }
        catch (EOFException eOFException) {
            return result;
        }
    }
}

