/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.ISamplesCallback;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jdt.annotation.NonNull;

public final class AnalysisRecompute {
    protected final @NonNull Analysis mAnalysis;
    private Thread mAnalysisFilterThread = null;
    private Thread mAnalysisSamplesThread = null;

    public AnalysisRecompute(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
    }

    public void cancel() {
        this.cancelFilterThread();
        this.cancelSamplesThread();
    }

    public synchronized boolean isAlive() {
        if (this.mAnalysisFilterThread != null && this.mAnalysisFilterThread.isAlive()) {
            return true;
        }
        return this.mAnalysisSamplesThread != null && this.mAnalysisSamplesThread.isAlive();
    }

    public synchronized void recomputeFilter(long startTick, long endTick) {
        this.cancelFilterThread();
        AnalysisFilterThread stream = new AnalysisFilterThread(startTick, endTick);
        this.mAnalysisFilterThread = new Thread(stream);
        this.mAnalysisFilterThread.setName("RecomputeFilter");
        this.mAnalysisFilterThread.setDaemon(true);
        this.mAnalysisFilterThread.setPriority(6);
        this.mAnalysisFilterThread.start();
    }

    public synchronized void recomputeSamples(long startTick, long endTick, @NonNull ISamplesCallback callback) {
        this.cancelSamplesThread();
        AnalysisSamplesThread stream = new AnalysisSamplesThread(startTick, endTick, callback);
        this.mAnalysisSamplesThread = new Thread(stream);
        this.mAnalysisSamplesThread.setName("RecomputeSamples");
        this.mAnalysisSamplesThread.setDaemon(true);
        this.mAnalysisSamplesThread.setPriority(6);
        this.mAnalysisSamplesThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFilterThread() {
        Thread thread;
        AnalysisRecompute analysisRecompute = this;
        synchronized (analysisRecompute) {
            thread = this.mAnalysisFilterThread;
            this.mAnalysisFilterThread = null;
        }
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSamplesThread() {
        Thread thread;
        AnalysisRecompute analysisRecompute = this;
        synchronized (analysisRecompute) {
            thread = this.mAnalysisSamplesThread;
            this.mAnalysisSamplesThread = null;
        }
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class AnalysisFilterThread
    implements Runnable {
        private final long endTick;
        private final long startTick;

        public AnalysisFilterThread(long startTick, long endTick) {
            this.startTick = startTick;
            this.endTick = endTick;
        }

        @Override
        public void run() {
            @NonNull Callable callable = AnalysisRecompute.this.mAnalysis.getInstructionCounterModel().createRecomputeSelectedCounterRange(this.startTick, this.endTick);
            try {
                callable.call();
                AnalysisRecompute.this.mAnalysis.notifyRecomputeFromModel();
                AnalysisRecompute.this.mAnalysis.notifyReAnalysisListenersOfCompletion();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                CommonPlugin.error((Throwable)throwable);
            }
        }
    }

    private class AnalysisSamplesThread
    implements Runnable {
        private final @NonNull ISamplesCallback callback;
        private final long endTick;
        private final long startTick;

        public AnalysisSamplesThread(long startTick, @NonNull long endTick, ISamplesCallback callback) {
            this.startTick = startTick;
            this.endTick = endTick;
            this.callback = callback;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void run() {
            try {
                @NonNull @NonNull @NonNull Callable callable = AnalysisRecompute.this.mAnalysis.getInstructionCounterModel().createRecomputeCSMSamplesData(this.startTick, this.endTick);
                this.callback.setSamples((List)callable.call());
            }
            catch (InterruptedException callable) {
            }
            catch (IOException callable) {
            }
            catch (Throwable throwable) {
                CommonPlugin.error((Throwable)throwable);
            }
        }
    }
}

