/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.mgdmode;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbRedirects;
import com.arm.streamline.mgdmode.IMgdDetector;
import com.arm.streamline.mgdmode.IMgdServer;
import com.arm.streamline.mgdmode.MgdDetector;
import com.arm.streamline.mgdmode.MgdModeMessages;
import com.arm.streamline.mgdmode.MgdServer;
import com.arm.streamline.mgdmode.RunMgdArgs;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.utils.NullChecking;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class RunMgdAction
extends Action {
    private static final Pattern DAEMON_VERSION_PATTERN = Pattern.compile("^[A-Z][0-9]+$");
    private static final SimpleDateFormat ECLIPSE_PLUGIN_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private static final Date SUPPORTED_3_5_1_NIGHTLY_DATE = new Date(1464134400000L);
    private final @NonNull RunMgdArgs mArgs;
    private @Nullable MgdDetector mDetector = null;
    private long mLiveTimestamp;
    private @Nullable IPreferences mApplicationSettings;
    private final @Nullable Runnable mStopAction;

    private static void processError(String errorMessage) {
        Status reason = new Status(4, "com.arm.streamline", 4, errorMessage, null);
        StatusManager.getManager().handle((IStatus)reason, 2);
    }

    private static @Nullable String forwardPortOverADBIfRequired(@NonNull IPreferences session, @NonNull TargetAddressString targetAddressStr) {
        if (targetAddressStr.isAndroid()) {
            try {
                File adbExe = session.getAdbPathOrDefault();
                if (adbExe != null) {
                    AdbRedirects.forward((IAdbProcessRunner)AdbRunnerFactory.SINGLETON.create(adbExe), (String)targetAddressStr.getAndroidSerialNumber(), (int)5002, (int)5002);
                    return "localhost";
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (targetAddressStr.isTcp()) {
            return targetAddressStr.getHostname();
        }
        return null;
    }

    private static boolean isSupportedVersion(@Nullable String daemonVersion, @NonNull String supportedVersion) {
        int supportedRelease;
        char supportedBranch;
        if (daemonVersion == null) {
            return false;
        }
        assert (DAEMON_VERSION_PATTERN.matcher(supportedVersion).matches());
        if (!DAEMON_VERSION_PATTERN.matcher(daemonVersion).matches()) {
            return false;
        }
        if (daemonVersion.length() != supportedVersion.length()) {
            return false;
        }
        char deamonBranch = daemonVersion.charAt(0);
        if (deamonBranch != (supportedBranch = supportedVersion.charAt(0))) {
            return false;
        }
        int daemonRelease = Integer.parseInt(daemonVersion.substring(1), 10);
        return daemonRelease >= (supportedRelease = Integer.parseInt(supportedVersion.substring(1), 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isValidHostVersion(@NonNull IMgdDetector.HostDetectionResult hostVersionResult) {
        if (hostVersionResult.major > 3 || hostVersionResult.major == 3 && hostVersionResult.minor > 5 || hostVersionResult.major == 3 && hostVersionResult.minor == 5 && hostVersionResult.update > 1) {
            return true;
        }
        if (hostVersionResult.major == 3 && hostVersionResult.minor == 5 && hostVersionResult.update == 1) {
            String date = hostVersionResult.date;
            if (date == null) {
                return false;
            }
            try {
                SimpleDateFormat simpleDateFormat = ECLIPSE_PLUGIN_DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    Date dateObj = ECLIPSE_PLUGIN_DATE_FORMAT.parse(date);
                    return dateObj.after(SUPPORTED_3_5_1_NIGHTLY_DATE);
                }
            }
            catch (ParseException exception) {
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"COMMAND_INJECTION"})
    private static boolean runMgd(@NonNull RunMgdArgs args, @NonNull MgdDetector detector, @NonNull IPreferences session, long timestampBase) {
        String hostVersion = null;
        try {
            String targetIPAddress = RunMgdAction.forwardPortOverADBIfRequired(session, args.getTargetAddressStr());
            if (targetIPAddress == null) {
                RunMgdAction.processError(MgdModeMessages.RUN_MGD_ACTION_CANNOT_GET_HOSTNAME);
                return false;
            }
            @NonNull IMgdDetector.DaemonDetectionResult daemonDetectionResult = detector.getRunningDaemonVersion(targetIPAddress);
            boolean isMgdDaemonVersionOK = daemonDetectionResult.isValid() && (RunMgdAction.isSupportedVersion(daemonDetectionResult.getVersion(), "D008") || RunMgdAction.isSupportedVersion(daemonDetectionResult.getVersion(), "C008"));
            Throwable throwable = null;
            Object var10_11 = null;
            try (IMgdServer server = detector.getMgdServer();){
                if (isMgdDaemonVersionOK) {
                    if (server == null) {
                        Path executable = args.getMgdExecutable();
                        File file = executable.toFile();
                        IMgdDetector.HostDetectionResult hostVersionResult = detector.getHostVersion((File)NullChecking.neverNull((Object)file));
                        if (hostVersionResult != null) {
                            boolean isInstalledMgdVersionOK = RunMgdAction.isValidHostVersion(hostVersionResult);
                            hostVersion = hostVersionResult.toString();
                            if (isInstalledMgdVersionOK) {
                                String processExe = hostVersionResult.mgdExePath.getCanonicalPath();
                                ProcessBuilder pb = new ProcessBuilder(processExe, "--remote-control", "CONNECT", targetIPAddress, MgdServer.formatTimebaseParameter(timestampBase));
                                pb.start();
                                return true;
                            }
                            RunMgdAction.processError(MessageFormat.format(MgdModeMessages.RUN_MGD_ACTION_UNSUPPORTED_HOST_VERSION_FOUND, hostVersionResult));
                            return false;
                        }
                        if (file.exists() && file.isFile()) {
                            RunMgdAction.processError(MgdModeMessages.RUN_MGD_ACTION_COULD_NOT_DETECT_HOST_VERSION);
                            return false;
                        }
                        RunMgdAction.processError(MgdModeMessages.RUN_MGD_ACTION_NO_EXE_FOUND);
                        return false;
                    }
                    hostVersion = server.getMgdProductVersion();
                    boolean isRunningMgdVersionOK = server.isSupportedVersion();
                    if (isRunningMgdVersionOK) {
                        if (!server.startTracing(targetIPAddress, timestampBase)) return false;
                        return true;
                    }
                    RunMgdAction.processError(MessageFormat.format(MgdModeMessages.RUN_MGD_ACTION_UNSUPPORTED_HOST_VERSION_RUNNING, hostVersion));
                    return false;
                }
                if (daemonDetectionResult.isValid()) {
                    RunMgdAction.processError(MgdModeMessages.RUN_MGD_ACTION_UNSUPPORTED_DAEMON_VERSION);
                    return false;
                }
                if (daemonDetectionResult.isTimedOut() && server != null) {
                    RunMgdAction.processError(MgdModeMessages.RUN_MGD_ACTION_DAEMON_TIMEOUT);
                    return false;
                }
                if (daemonDetectionResult.getVersion() == null) {
                    RunMgdAction.processError(MgdModeMessages.RUN_MGD_ACTION_NO_DAEMON_RUNNING);
                    return false;
                }
                RunMgdAction.processError(MgdModeMessages.RUN_MGD_ACTION_DAEMON_ERROR);
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException exception) {
            RunMgdAction.processError(exception.getMessage());
        }
        return false;
    }

    public RunMgdAction(@Nullable Runnable stopAction, @NonNull RunMgdArgs mgdArgs) {
        this.mArgs = mgdArgs;
        this.mStopAction = stopAction;
        this.mLiveTimestamp = 0L;
        this.setText(MgdModeMessages.ANALYZE_IN_MGD_TOOLTIP);
        this.setImageDescriptor(StreamlinePlugin.getImageDescriptor("MGD.png"));
    }

    public final void run() {
        ForkJoinPool.commonPool().execute(() -> {
            Runnable stopAction = this.mStopAction;
            if (RunMgdAction.runMgd(this.mArgs, (MgdDetector)NullChecking.neverNull((Object)this.mDetector), (IPreferences)NullChecking.neverNull((Object)this.mApplicationSettings), this.mLiveTimestamp) && stopAction != null) {
                Display.getDefault().asyncExec(stopAction);
            }
        });
    }

    public void setLiveTimestamp(long liveTimetstamp) {
        this.mLiveTimestamp = liveTimetstamp;
    }

    public void setProcessDataProviderAndSession(@Nullable IProcessDataProvider processDataProvider, @Nullable IPreferences settings) {
        this.mDetector = processDataProvider != null ? new MgdDetector(processDataProvider) : null;
        this.mApplicationSettings = settings;
    }
}

