/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.mgdmode;

import com.arm.streamline.mgdmode.IMgdDetector;
import com.arm.streamline.mgdmode.IMgdServer;
import com.arm.streamline.mgdmode.MgdServer;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.util.Platform;
import com.arm.utils.NullChecking;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MgdDetector
implements IMgdDetector {
    private static final Pattern COM_ARM_MGD_CORE_FILENAME_PATTERN = Pattern.compile("com\\.arm\\.(mgd|aga)\\.core_((?:[0-9]+\\.)+)jar");
    private final @NonNull IProcessDataProvider mProcessDataProvider;

    private static @Nullable IMgdDetector.HostDetectionResult getHostVersionFromPlugins(@NonNull File mgdExePath, @NonNull File pluginsDir) {
        assert (pluginsDir.exists() && pluginsDir.isDirectory());
        @NonNull File @Nullable [] comArmMgdCorePluginFiles = pluginsDir.listFiles(childFile -> COM_ARM_MGD_CORE_FILENAME_PATTERN.matcher(childFile.getName()).matches());
        if (comArmMgdCorePluginFiles == null || comArmMgdCorePluginFiles.length != 1) {
            return null;
        }
        Matcher match = COM_ARM_MGD_CORE_FILENAME_PATTERN.matcher(comArmMgdCorePluginFiles[0].getName());
        if (!match.matches()) {
            throw new AssertionError();
        }
        String versionString = (String)NullChecking.neverNull((Object)match.group(2));
        String[] versionParts = versionString.split("\\.");
        int partCount = Math.min(3, versionParts.length - 1);
        if (partCount >= 1) {
            return new IMgdDetector.HostDetectionResult(mgdExePath, Integer.valueOf(versionParts[0]), partCount >= 2 ? Integer.valueOf(versionParts[1]) : -1, partCount >= 3 ? Integer.valueOf(versionParts[2]) : -1, versionParts[versionParts.length - 1]);
        }
        return null;
    }

    private static @NonNull File resolveSymlinks(@NonNull File mgdExeFile) {
        try {
            Path path = mgdExeFile.toPath();
            if (Files.isSymbolicLink(path)) {
                path = Files.readSymbolicLink(path);
            }
            return (File)NullChecking.neverNull((Object)path.toFile());
        }
        catch (IOException | SecurityException e) {
            return mgdExeFile;
        }
    }

    public MgdDetector(@NonNull IProcessDataProvider provider) {
        this.mProcessDataProvider = provider;
    }

    @Override
    public @Nullable IMgdDetector.HostDetectionResult getHostVersion(@NonNull File mgdExeFile) {
        mgdExeFile = MgdDetector.resolveSymlinks(mgdExeFile);
        if (Platform.isMac() && mgdExeFile.getAbsolutePath().endsWith(".app")) {
            File realMgdExe = new File(mgdExeFile, "Contents/MacOS/aga");
            return this.getHostVersion(realMgdExe, realMgdExe);
        }
        return this.getHostVersion(mgdExeFile, mgdExeFile);
    }

    private @Nullable IMgdDetector.HostDetectionResult getHostVersion(@NonNull File mgdExeFile, @NonNull File originalMgdExeFile) {
        if (!(mgdExeFile = MgdDetector.resolveSymlinks(mgdExeFile)).exists()) {
            return null;
        }
        if (mgdExeFile.isFile()) {
            return this.getHostVersion((File)NullChecking.neverNull((Object)mgdExeFile.getParentFile()), originalMgdExeFile);
        }
        if (!mgdExeFile.isDirectory()) {
            return null;
        }
        File pluginsDir = new File(mgdExeFile, "plugins");
        if (pluginsDir.exists() && pluginsDir.isDirectory()) {
            return MgdDetector.getHostVersionFromPlugins(originalMgdExeFile, pluginsDir);
        }
        File parentFile = mgdExeFile.getParentFile();
        if (parentFile != null && "bin".equalsIgnoreCase(mgdExeFile.getName()) && (pluginsDir = new File(parentFile, "sw" + File.separator + "mgd" + File.separator + "gui" + File.separator + "plugins")).exists() && pluginsDir.isDirectory()) {
            return MgdDetector.getHostVersionFromPlugins(originalMgdExeFile, pluginsDir);
        }
        if (parentFile != null && "MacOS".equalsIgnoreCase(mgdExeFile.getName())) {
            File parentFilesParentsParent;
            File parentFilesParent;
            block11: {
                parentFilesParent = parentFile.getParentFile();
                if (parentFilesParent != null) {
                    try {
                        List pluginsPaths = Files.find(Paths.get(parentFilesParent.getAbsolutePath(), new String[0]), 4, (filePath, fileAttr) -> filePath.endsWith("plugins"), new FileVisitOption[0]).collect(Collectors.toList());
                        if (!pluginsPaths.isEmpty()) {
                            return MgdDetector.getHostVersionFromPlugins(originalMgdExeFile, (File)NullChecking.neverNull((Object)((Path)pluginsPaths.get(0)).toFile()));
                        }
                    }
                    catch (Exception exception) {
                        File pluginsFile = new File(parentFile, "Eclipse/plugins");
                        if (!pluginsFile.exists() || !pluginsFile.isDirectory()) break block11;
                        return MgdDetector.getHostVersionFromPlugins(originalMgdExeFile, pluginsFile);
                    }
                }
            }
            File file = parentFilesParentsParent = parentFilesParent != null ? parentFilesParent.getParentFile() : null;
            if (parentFilesParentsParent != null && (pluginsDir = new File(parentFilesParentsParent, "plugins")).exists() && pluginsDir.isDirectory()) {
                return MgdDetector.getHostVersionFromPlugins(originalMgdExeFile, pluginsDir);
            }
        }
        return null;
    }

    @Override
    public IMgdServer getMgdServer() {
        return MgdServer.create();
    }

    /*
     * Exception decompiling
     */
    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"})
    public @NonNull IMgdDetector.DaemonDetectionResult getRunningDaemonVersion(@NonNull String targetDeviceIpAddress) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isDaemonProcessRunning() {
        for (ProcessData data : this.mProcessDataProvider.getProcessData()) {
            if (!data.getProcessName().equals("aga-daemon")) continue;
            return true;
        }
        return false;
    }
}

