/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.mgdmode;

import com.arm.streamline.mgdmode.IMgdServer;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IMgdDetector {
    public @Nullable HostDetectionResult getHostVersion(@NonNull File var1);

    public @Nullable IMgdServer getMgdServer();

    public @NonNull DaemonDetectionResult getRunningDaemonVersion(@NonNull String var1);

    public boolean isDaemonProcessRunning();

    public static class DaemonDetectionResult {
        private final boolean timedOut;
        private final @Nullable String version;

        public DaemonDetectionResult(boolean timedOut) {
            this.version = null;
            this.timedOut = timedOut;
        }

        public DaemonDetectionResult(@NonNull String version) {
            this.version = version;
            this.timedOut = false;
        }

        public @Nullable String getVersion() {
            return this.version;
        }

        public boolean isErroredOut() {
            return this.version == null && !this.timedOut;
        }

        public boolean isTimedOut() {
            return this.version == null && this.timedOut;
        }

        public boolean isValid() {
            return this.version != null;
        }
    }

    public static class HostDetectionResult {
        public final @Nullable String date;
        public final int major;
        public final int minor;
        public final int update;
        public final @NonNull File mgdExePath;

        public HostDetectionResult(@NonNull File mgdExePath, int major, int minor, int update, @Nullable String date) {
            this.mgdExePath = mgdExePath;
            this.major = major;
            this.minor = minor;
            this.update = update;
            this.date = date;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.major);
            if (this.minor >= 0) {
                result.append('.').append(this.minor);
                if (this.update >= 0) {
                    result.append('.').append(this.update);
                }
            }
            return result.toString();
        }
    }
}

