/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.live;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.ExternalToolsPage;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.Warnings;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.databrowser.DocumentPanel;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.editortabs.Badges;
import com.arm.streamline.editortabs.HelpAction;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.CenterOnCSMAction;
import com.arm.streamline.editortabs.timeline.common.ResetCalipersAction;
import com.arm.streamline.editortabs.timeline.common.TimeReadout;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionListener;
import com.arm.streamline.editortabs.timeline.common.process.ProcessPanel;
import com.arm.streamline.editortabs.timeline.common.templates.NewChartAction;
import com.arm.streamline.editortabs.timeline.common.templates.TemplateAction;
import com.arm.streamline.live.ErrorMessagePanel;
import com.arm.streamline.live.LiveFilterToolbar;
import com.arm.streamline.live.LiveMessages;
import com.arm.streamline.mgdmode.RunMgdAction;
import com.arm.streamline.mgdmode.RunMgdArgs;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.live.LiveAllBinDataProvider;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.utility.RunnableUIAction;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockToolbar;
import com.arm.utils.NullChecking;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;

public class LiveContent
extends BaseTimelineContent
implements LiveAllBinDataProvider.ICommitListener,
ITimelinePositionListener {
    private static final long EXPECTED_INTERVAL = 100L;
    private static final @NonNull ZoomLevel BIN_SCALE = Scales.HUNDRED_MILLISECONDS_ZOOM_LEVEL;
    private ILiveCapture mAnalysisDocument;
    private @Nullable LiveCaptureDataProvider mDataProvider;
    private CustomToolbar mToolbar;
    private ErrorMessagePanel mErrorPanel;
    private final @NonNull IWarnings mWarnings = new Warnings();
    private CenterOnCSMAction mCenterOnCSMAction;
    private ResetCalipersAction mResetCalipersAction;
    private @NonNull RunnableUIAction mBeginningAction = new RunnableUIAction(LiveMessages.GOTO_START_TOOLTIP, StreamlinePlugin.getImageDescriptor("GoToStart.png"), () -> {
        boolean bl = this.getDividerPanel().setPosition(0L);
    });
    private @NonNull RunnableUIAction mHaltAction = new RunnableUIAction(LiveMessages.HALT_SCROLLING_TOOLTIP, StreamlinePlugin.getImageDescriptor("Pause.png"), () -> this.pause());
    private @NonNull RunnableUIAction mLiveAction = new RunnableUIAction(LiveMessages.GOTO_LIVE_TOOLTIP, StreamlinePlugin.getImageDescriptor("GoToEnd.png"), () -> {
        boolean bl = this.getDividerPanel().setPosition(Integer.MAX_VALUE);
    });
    private RunMgdAction mRunMGDAction;
    private RunnableUIAction mThemeAction = new RunnableUIAction(LiveMessages.CYCLE_THEME, StreamlinePlugin.getImageDescriptor("Theme.png"), () -> StreamlinePreferences.cycleTheme());
    private TemplateAction mTemplateAction;
    private NewChartAction mChartAction;
    private TimeReadout mDurationReadout;
    private boolean mPreparedForStop;
    private boolean mDiscard = true;
    private boolean mPaused;
    private boolean mPendingUpdateForCommit;
    private final @Nullable Path mMgdExecutablePath;
    private final boolean mMgdKeepTracing;
    private final @NonNull TargetAddressString mTargetAddressStr;
    boolean mStarted = false;
    private @Nullable TimelineConfig mCurrentConfig;
    private final @NonNull AtomicBoolean isLiveStopping = new AtomicBoolean(false);
    private @Nullable Label progressBarLbl;
    private @Nullable ProgressBar progressBar;
    private final int FIXED_TOOLBAR_GAP = 4;
    private boolean isSaveAndAnalyse;
    private @NonNull List<@NonNull TemplateFile> mTemplates;
    private @NonNull Set<@NonNull String> mSpeKeys;

    private static @NonNull RunMgdAction createMgdLauncherAction(@Nullable Path mgdExecutablePath, @NonNull TargetAddressString targetAddressStr, @Nullable Runnable stopAction) {
        RunMgdArgs args = new RunMgdArgs(mgdExecutablePath != null ? mgdExecutablePath : (Path)NullChecking.neverNull((Object)Paths.get("", new String[0])), targetAddressStr);
        return new RunMgdAction(stopAction, args);
    }

    public LiveContent(Composite parent, @Nullable Path mgdExecutable, boolean mgdKeepTracing, @NonNull TargetAddressString targetAddressStr, @NonNull Configurations configurations) {
        super(parent, "processes");
        this.mTemplates = new ArrayList<TemplateFile>(configurations.getTemplates());
        this.mSpeKeys = configurations.getSpeFilterConfigurations().stream().map(f -> f.getId()).collect(Collectors.toSet());
        this.mMgdExecutablePath = mgdExecutable;
        this.mMgdKeepTracing = mgdKeepTracing;
        this.mTargetAddressStr = targetAddressStr;
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.createToolbar());
        this.mErrorPanel = new ErrorMessagePanel(this, "");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mErrorPanel);
        StreamlinePlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.addDisposeListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.arm.streamline.live");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commitOccurred() {
        boolean schedule = false;
        LiveContent liveContent = this;
        synchronized (liveContent) {
            if (!this.mPendingUpdateForCommit) {
                this.mPendingUpdateForCommit = true;
                schedule = true;
            }
        }
        if (schedule) {
            Task.scheduleOnUIThread(() -> {
                LiveContent liveContent = this;
                synchronized (liveContent) {
                    this.mPendingUpdateForCommit = false;
                }
                if (!this.isDisposed()) {
                    @Nullable LiveCaptureDataProvider dataProvider = this.mDataProvider;
                    if (dataProvider != null) {
                        dataProvider.updateLastBinCount();
                        this.mDurationReadout.update(dataProvider.getLastBinCount(), BIN_SCALE, dataProvider.getTimeUnit());
                        this.redrawContent();
                        if (this.mRunMGDAction != null) {
                            this.mRunMGDAction.setLiveTimestamp(dataProvider.getLastBinCount() * 1000000000 / BIN_SCALE.getBps());
                        }
                    }
                    if (!this.mPreparedForStop && this.mAnalysisDocument != null && this.mAnalysisDocument.hasBeenStopped()) {
                        this.prepareForStop();
                    }
                }
            });
        }
    }

    @Override
    public TimelineConfig createConfiguration() {
        TimelineConfig config = super.createConfiguration();
        config.setDetailAreaMode("heat");
        return config;
    }

    @Override
    public final LiveCaptureDataProvider getCaptureDataProvider() {
        return this.mDataProvider;
    }

    public final ILiveCapture getDocument() {
        return this.mAnalysisDocument;
    }

    public @NonNull TargetAddressString getTargetAddress() {
        return this.mTargetAddressStr;
    }

    @Override
    public final CustomToolbar getTopToolbar() {
        return this.mToolbar;
    }

    public final IWarnings getWarnings() {
        return this.mWarnings;
    }

    public final boolean isDiscard() {
        return this.mDiscard;
    }

    public final void prepareForStop() {
        this.mPreparedForStop = true;
        if (this.getContentWrapper() != null) {
            this.mCurrentConfig = this.createConfiguration();
            this.getDividerPanel().setCaptureEnded();
            this.getChartsPanel().stop();
        }
        if (this.mDataProvider != null) {
            this.mDataProvider.getAllBinData().removeCommitListener(this);
        }
    }

    public final void start(ILiveCapture doc, @Nullable LiveCaptureDataProvider data, IPreferences appSettings, boolean discard, String error) {
        if (!this.isDisposed()) {
            this.mDataProvider = data;
            this.mAnalysisDocument = doc;
            this.mDiscard = discard;
            RunMgdAction runMGDAction = this.mRunMGDAction;
            if (runMGDAction != null) {
                if (data != null) {
                    runMGDAction.setProcessDataProviderAndSession(data.getProcessDataProvider(), appSettings);
                } else {
                    runMGDAction.setEnabled(false);
                }
            }
            if (data != null) {
                this.mWarnings.clear();
                data.setWarnings(this.mWarnings);
                if (this.mToolbar != null) {
                    Badges.create((CustomToolbar)((Object)NullChecking.neverNull((Object)((Object)this.mToolbar))), data);
                }
                data.addStaticCharts(this.mCurrentConfig);
            }
            if (error != null) {
                this.mErrorPanel.setText(error);
            } else {
                this.mErrorPanel.dispose();
                if (!this.mStarted) {
                    this.createStandardPanels(0);
                    this.getDividerPanel().addPositionListener(this);
                    this.layout(true, true);
                    this.setLiveDisplayEnabled(true);
                    this.mStarted = true;
                } else {
                    this.getContentWrapper().getChartsPanel().refreshCaptureData();
                    this.refreshDetailArea("processes");
                }
                if (this.mDataProvider != null) {
                    this.mDataProvider.getAllBinData().addCommitListener(this);
                    this.commitOccurred();
                }
                Task.scheduleOnUIThread(() -> this.redrawContent(), null, (long)100L, (java.util.concurrent.TimeUnit)java.util.concurrent.TimeUnit.MILLISECONDS);
            }
        }
    }

    public final boolean stop(boolean discard) {
        DocumentPanel panel;
        if (this.mAnalysisDocument == null) {
            return false;
        }
        if (discard) {
            this.mDiscard = true;
        } else {
            @NonNull List<@NonNull String> unSavedSources = this.getUnSavedSources();
            if (!unSavedSources.isEmpty() && StreamlinePreferences.showRemoveUnsavedChartConfirmDialog()) {
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(null, DocumentsMessages.STOP_CAPTURE, null, DocumentsMessages.STOP_CAPTURE_MESSAGE, 4, new String[]{IDialogConstants.CANCEL_LABEL, IDialogConstants.OK_LABEL}, 1, DocumentsMessages.REMEMBER_ME, false);
                int returnState = dialog.open();
                if (returnState == 0) {
                    if (dialog.getToggleState()) {
                        StreamlinePreferences.setShowRemoveUnSavedChartConfirmDialog(false);
                    }
                    if (this.mDataProvider != null) {
                        this.mDataProvider.removeSeriesUsing(unSavedSources);
                    }
                } else {
                    return false;
                }
            }
        }
        this.prepareForStop();
        this.mAnalysisDocument.stop(discard);
        @Nullable DocumentsView documentsView = DocumentsView.showView();
        if (documentsView != null && (panel = documentsView.getDocumentPanelFor(this.mAnalysisDocument)) != null) {
            panel.stopped();
        }
        this.mAnalysisDocument = null;
        return true;
    }

    private @NonNull List<@NonNull String> getUnSavedSources() {
        @NonNull ArrayList<@NonNull String> unSavedSources = new ArrayList<String>();
        if (this.mDataProvider != null) {
            @NonNull LiveCaptureDataProvider livecdp = (LiveCaptureDataProvider)NullChecking.neverNull((Object)this.mDataProvider);
            @NonNull ArrayList<E> series = new ArrayList();
            livecdp.getChartList().forEach(c -> {
                boolean bl = series.addAll(c.getSeries());
            });
            series.forEach(c -> {
                if (c.getWarningSource() == ISeriesDataProvider.WarningSource.DUMMY_COUNTER || c.getWarningSource() == ISeriesDataProvider.WarningSource.INVALID_COUNTER) {
                    @NonNull Set<@NonNull String> sources = c.getSources();
                    unSavedSources.addAll(sources);
                }
            });
        }
        return unSavedSources;
    }

    @Override
    public final void timelinePositionChanged() {
        if (this.mPaused && this.getDividerPanel().isWithinAutoScrollAtEndRange()) {
            this.mPaused = false;
        }
    }

    @Override
    protected final BlockToolbar createBottomToolbar() {
        return new LiveFilterToolbar(this);
    }

    @Override
    protected final Block createDetailArea(String key) {
        if ("processes".equals(key)) {
            return new ProcessPanel(this);
        }
        return null;
    }

    private final CustomToolbar createToolbar() {
        this.mToolbar = new CustomToolbar(this);
        this.mToolbar.addAction(this.getBookmarkToggleAction());
        this.mCenterOnCSMAction = new CenterOnCSMAction(this);
        this.mToolbar.addAction(this.mCenterOnCSMAction);
        this.mResetCalipersAction = new ResetCalipersAction(this);
        this.mToolbar.addAction(this.mResetCalipersAction).setLayoutData(new CustomToolbar.LayoutData().setFlexibleGap());
        this.progressBarLbl = new Label((Composite)this.mToolbar, 1);
        Label neverNullPbLbl = (Label)NullChecking.neverNull((Object)this.progressBarLbl);
        neverNullPbLbl.setText(LiveMessages.PROGRESS_BAR_LABEL);
        neverNullPbLbl.setVisible(false);
        neverNullPbLbl.setLayoutData((Object)new CustomToolbar.LayoutData().setMinimumWidth(neverNullPbLbl.computeSize((int)-1, (int)-1).x).setGap(4));
        this.progressBar = new ProgressBar((Composite)this.mToolbar, 2);
        ProgressBar neverNullPB = (ProgressBar)NullChecking.neverNull((Object)this.progressBar);
        neverNullPB.setToolTipText(LiveMessages.PROGRESS_BAR_TOOLTIP);
        neverNullPB.setVisible(false);
        neverNullPB.setLayoutData((Object)new CustomToolbar.LayoutData().setMinimumWidth(neverNullPB.computeSize((int)-1, (int)-1).x).setGap(4));
        @NonNull TimeUnit timeUnit = this.mDataProvider != null ? this.mDataProvider.getTimeUnit() : TimeUnit.NANO_SECONDS;
        TimeReadout positionReadout = this.getPositionReadout();
        positionReadout.updateDesiredMinimumWidthForScale(Integer.MAX_VALUE, BIN_SCALE, timeUnit);
        positionReadout.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(positionReadout.computeSize((int)-1, (int)-1).x).setGap(4));
        this.mDurationReadout = new TimeReadout(this.mToolbar, true);
        this.mDurationReadout.updateDesiredMinimumWidthForScale(Integer.MAX_VALUE, BIN_SCALE, timeUnit);
        this.mDurationReadout.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mDurationReadout.computeSize((int)-1, (int)-1).x).setFlexibleGap());
        this.mToolbar.addAction(this.mBeginningAction);
        this.mToolbar.addAction(this.mHaltAction);
        this.mToolbar.addAction(this.mLiveAction).setLayoutData(new CustomToolbar.LayoutData().setGap(10));
        if (!ExternalToolsPage.DISABLE_MGD_INTEGRATION) {
            this.mRunMGDAction = LiveContent.createMgdLauncherAction(this.mMgdExecutablePath, this.mTargetAddressStr, !this.mMgdKeepTracing ? () -> {
                boolean bl = this.stop(this.mDiscard);
            } : null);
            this.mToolbar.addAction(this.mRunMGDAction).setLayoutData(new CustomToolbar.LayoutData().setGap(10));
        }
        this.mTemplateAction = new TemplateAction(this, this.mTemplates, this.mSpeKeys);
        this.mToolbar.addAction(this.mTemplateAction);
        this.mChartAction = new NewChartAction(this);
        this.mToolbar.addAction(this.mChartAction);
        this.mToolbar.addAction(this.mThemeAction);
        this.mToolbar.addAction(new HelpAction());
        this.setLiveDisplayEnabled(false);
        return this.mToolbar;
    }

    private final void pause() {
        this.mPaused = true;
    }

    private final void redrawContent() {
        DividerPanel dividerPanel;
        if (!(this.isDisposed() || (dividerPanel = this.getDividerPanel()) == null || !this.mPaused && dividerPanel.autoScrollToEndIfNeeded())) {
            this.getChartsPanel().redrawCharts();
            this.getRulerPanel().repaint();
            this.getCrossSectionHandlePanel().repaint();
            if (this.mPaused) {
                dividerPanel.setPosition(dividerPanel.getPosition());
            }
        }
    }

    private final void setLiveDisplayEnabled(boolean enabled) {
        this.getBookmarkToggleAction().setEnabled(enabled);
        this.mCenterOnCSMAction.updateFromContent();
        this.mResetCalipersAction.setEnabled(enabled);
        this.mBeginningAction.setEnabled(enabled);
        this.mHaltAction.setEnabled(enabled);
        this.mLiveAction.setEnabled(enabled);
        this.mTemplateAction.setEnabled(enabled);
        this.mChartAction.setEnabled(enabled);
        this.mThemeAction.setEnabled(enabled);
        if (this.mRunMGDAction != null) {
            this.mRunMGDAction.setEnabled(enabled);
        }
    }

    private void makeVisibleAnalyzeProgressBar(boolean state) {
        Label progressBarLbl;
        ProgressBar progressBar = (ProgressBar)NullChecking.neverNull((Object)this.progressBar);
        if (!progressBar.isDisposed()) {
            progressBar.setVisible(state);
        }
        if (!(progressBarLbl = (Label)NullChecking.neverNull((Object)this.progressBarLbl)).isDisposed()) {
            progressBarLbl.setVisible(state);
        }
    }

    public void setLiveStopping(boolean state) {
        this.isLiveStopping.set(state);
        Task.callOnUIThread(() -> this.makeVisibleAnalyzeProgressBar(state));
    }

    @Override
    public boolean isLiveStopping() {
        return this.isLiveStopping.get();
    }

    public void setSaveAndAnalyse(boolean isSaveAnalyse) {
        this.isSaveAndAnalyse = isSaveAnalyse;
    }

    public boolean isSaveAndAnalyse() {
        return this.isSaveAndAnalyse;
    }
}

