/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.templates;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartsPanel;
import com.arm.streamline.editortabs.timeline.common.templates.TemplatesMessages;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class NewChartAction
extends Action
implements IMenuCreator {
    private BaseTimelineContent mContent;
    private Menu mMenu;

    public NewChartAction(BaseTimelineContent content) {
        this.mContent = content;
        this.setImageDescriptor(StreamlinePlugin.getImageDescriptor("NewChart.png"));
        this.setToolTipText(TemplatesMessages.NEW_CHART_TOOLTIP);
        this.setMenuCreator(this);
    }

    public final void dispose() {
        if (this.mMenu != null) {
            this.mMenu.dispose();
            this.mMenu = null;
        }
    }

    public final Menu getMenu(Control parent) {
        this.mMenu = new Menu(parent);
        MenuItem item = new MenuItem(this.mMenu, 8);
        item.setText(TemplatesMessages.NEW_CHART);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                NullChecking.consumeIfNonNull((Object)NewChartAction.this.createChart(new ChartAndSeriesConfig()), ChartHandlePanel::toggleConfigurationPanel);
            }
        });
        ContextMenu.createSeparator(this.mMenu);
        for (ChartAndSeriesConfig source : this.mContent.getCaptureDataProvider().getAddableSources()) {
            item = new MenuItem(this.mMenu, 8);
            item.setText(this.mContent.getCaptureDataProvider().getVariableReplacer().replace(source.getChart().getTitle()));
            item.setData((Object)source);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public final void widgetSelected(SelectionEvent event) {
                    NullChecking.consumeIfNonNull((Object)NewChartAction.this.createChart((ChartAndSeriesConfig)NullChecking.neverNull((Object)event.widget.getData())), Block::scrollIntoView);
                }
            });
        }
        return this.mMenu;
    }

    public final Menu getMenu(Menu parent) {
        return null;
    }

    final @Nullable ChartHandlePanel createChart(@NonNull ChartAndSeriesConfig chartAndSeriesConfig) {
        BaseTimelineContent content;
        int height;
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        IChartDataProvider chart = cdp.addNewChart(chartAndSeriesConfig);
        if (chart == null) {
            return null;
        }
        ChartsPanel chartsPanel = this.mContent.getChartsPanel();
        ChartHandlePanel handle = new ChartHandlePanel(chartsPanel, chart);
        chartsPanel.add(handle);
        chartsPanel.pack();
        if (chart.isAlignmentSupported() && chart.isAlignmentLinked()) {
            Block[] blockArray = chartsPanel.getChildren();
            int n = blockArray.length;
            int n2 = 0;
            while (n2 < n) {
                IChartDataProvider oneChart;
                ChartHandlePanel one;
                Block child = blockArray[n2];
                if (child instanceof ChartHandlePanel && (one = (ChartHandlePanel)child) != handle && (oneChart = one.getChart()).isAlignmentSupported() && oneChart.isAlignmentLinked()) {
                    chart.setAlignment(oneChart.getAlignment());
                    break;
                }
                ++n2;
            }
        }
        if ((height = handle.getHeight()) > (content = chartsPanel.getBaseTimelineContent()).getChartsScroller().getHeight()) {
            content.setDividerPosition(height);
        }
        return handle;
    }
}

