/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.samples;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.timeline.common.samples.SamplesPanel;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IExtractable;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import java.util.BitSet;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public class SamplesRow
extends BlockRow
implements IExtractable {
    private SamplesPanel mSamplesPanel;
    private SamplesData mSample;

    SamplesRow(SamplesPanel samplesPanel, SamplesData sample) {
        this.mSamplesPanel = samplesPanel;
        this.mSample = sample;
    }

    @Override
    public Image getImage(BlockColumn column) {
        if (column.getID() == 0) {
            boolean isUnknown = this.mSample.getFunction().isUnknown();
            String imageName = isUnknown ? "WarningSmall.png" : "Function.png";
            return StreamlinePlugin.getImage(imageName);
        }
        return null;
    }

    public final void extractCallChainLinks(Collection<ICallPath> collection) {
        ICallPath[] iCallPathArray = (ICallPath[])this.mSample.getData().keys((Object[])new ICallPath[0]);
        int n = iCallPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICallPath callpath = iCallPathArray[n2];
            collection.add(callpath);
            ++n2;
        }
    }

    public final void extractDisassemblyLines(BitSet set) {
        ICallPath[] iCallPathArray = (ICallPath[])this.mSample.getData().keys((Object[])new ICallPath[0]);
        int n = iCallPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICallPath callpath = iCallPathArray[n2];
            @Nullable IInstructionCounterFunctionView functionView = callpath.getFunction();
            if (functionView != null) {
                functionView.getFunction().extractDisassemblyLines(set);
            }
            ++n2;
        }
    }

    public final void extractFunctions(Collection<IFunction> collection) {
        ICallPath[] iCallPathArray = (ICallPath[])this.mSample.getData().keys((Object[])new ICallPath[0]);
        int n = iCallPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICallPath callpath = iCallPathArray[n2];
            @Nullable IInstructionCounterFunctionView functionView = callpath.getFunction();
            if (functionView != null) {
                collection.add(functionView.getFunction());
            }
            ++n2;
        }
    }

    public final void extractSourceFiles(Collection<SourceFile> collection) {
        ICallPath[] iCallPathArray = (ICallPath[])this.mSample.getData().keys((Object[])new ICallPath[0]);
        int n = iCallPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICallPath callpath = iCallPathArray[n2];
            @Nullable IInstructionCounterFunctionView functionView = callpath.getFunction();
            if (functionView != null) {
                functionView.getFunction().extractSourceFiles(collection);
            }
            ++n2;
        }
    }

    public final void extractSourceReferences(Collection<ISourceReference> collection) {
        ICallPath[] iCallPathArray = (ICallPath[])this.mSample.getData().keys((Object[])new ICallPath[0]);
        int n = iCallPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICallPath callpath = iCallPathArray[n2];
            @Nullable IInstructionCounterFunctionView functionView = callpath.getFunction();
            if (functionView != null) {
                functionView.getFunction().extractSourceReferences(collection);
            }
            ++n2;
        }
    }

    @Override
    public final double getDataAsDouble(BlockColumn column) {
        switch (column.getID()) {
            case 1: {
                return this.mSample.getTotalSamples();
            }
            case 2: {
                return (double)this.mSample.getTotalSamples() * 100.0 / (double)this.mSamplesPanel.getTotalSamples();
            }
        }
        return -1.0;
    }

    @Override
    public final long getDataAsLong(BlockColumn column) {
        switch (column.getID()) {
            case 1: 
            case 2: {
                return this.mSample.getTotalSamples();
            }
        }
        return -1L;
    }

    @Override
    public final String getDataAsText(BlockColumn column) {
        switch (column.getID()) {
            case 0: {
                return this.mSample.getFunction().getName();
            }
            case 1: {
                return NumberUtils.format((long)this.mSample.getTotalSamples());
            }
            case 2: {
                return NumberUtils.formatPercentage((double)((double)this.mSample.getTotalSamples() * 100.0 / (double)this.mSamplesPanel.getTotalSamples()), (boolean)false);
            }
        }
        return "";
    }

    @Override
    public final void setData(BlockColumn column, Object data) {
    }
}

