/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.samples;

import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineCommonMessages;
import com.arm.streamline.editortabs.timeline.common.samples.SamplesOutline;
import com.arm.streamline.editortabs.timeline.common.samples.SamplesRow;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.ISamplesCallback;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockHeader;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineSortState;
import com.arm.streamline.widget.lightweight.outline.BlockPercentageCell;
import com.arm.streamline.widget.lightweight.outline.BlockTextCell;
import com.arm.streamline.widget.lightweight.outline.IBlockColumnCompareType;
import com.arm.streamline.widget.lightweight.outline.IBlockOutlineListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class SamplesPanel
extends Block
implements ISamplesCallback,
IBlockOutlineListener {
    public static final int COL_ID_WHAT = 0;
    static final int COL_ID_COUNT = 1;
    static final int COL_ID_PERCENTAGE = 2;
    private ICaptureDataProvider mDataProvider;
    private SamplesOutline mOutline;
    private long mTotal;
    private @Nullable List<@NonNull SamplesData> mNewSamples;

    public SamplesPanel(BaseTimelineContent content) {
        this.mDataProvider = content.getCaptureDataProvider();
        BlockOutlineModel model = new BlockOutlineModel();
        model.setShowOutline(false);
        BlockColumn column = new BlockColumn(0, TimelineCommonMessages.SAMPLES_WHAT, new BlockTextCell());
        if (this.mDataProvider instanceof Analysis) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            column.setDefaultPreferredWidth(Math.min(one * ((Analysis)this.mDataProvider).getInstructionCounterModel().getLargestFunctionName().length() + 12, column.getMaxWidth()));
        }
        model.addColumn(column);
        column = new BlockColumn(1, TimelineCommonMessages.SAMPLES_COUNT, new BlockTextCell(131072, IBlockColumnCompareType.INTEGER));
        column.setSortCriteria(0, false);
        model.addColumn(column);
        model.addColumn(new BlockColumn(2, TimelineCommonMessages.SAMPLES_PERCENTAGE, new BlockPercentageCell(200, false)));
        BlockHeader header = new BlockHeader();
        header.setLayoutData(new PrecisionLayoutData().setGrabHorizontalSpace(true).setHorizontalAlignment(4));
        this.add(header);
        this.mOutline = new SamplesOutline(model, this.mDataProvider);
        this.mOutline.setHeader(header);
        this.mOutline.sizeColumnsToFit();
        this.mOutline.pack();
        this.mOutline.getDefaultConfig();
        this.mOutline.addOutlineListener(this);
        ScrollingBlock scroller = new ScrollingBlock(this.mOutline);
        scroller.setLayoutData(new PrecisionLayoutData().setGrabSpace(true).setFill().setMinimumHeight(0).setMinimumWidth(0));
        this.add(scroller);
        this.setLayout(new PrecisionLayout());
        this.askForRowUpdate();
        this.mDataProvider.getCrossSectionMarker().addListener(csm -> this.askForRowUpdate());
        this.mDataProvider.getScales().addListener(scales -> this.askForRowUpdate());
    }

    @Override
    public final void deleteSelectionRequested(BlockOutline outline) {
    }

    @Override
    public final void editorChanged(BlockOutline outline) {
    }

    public final ICaptureDataProvider getDataProvider() {
        return this.mDataProvider;
    }

    public final long getTotalSamples() {
        return this.mTotal;
    }

    @Override
    public final void openSelectionRequested(BlockOutline outline) {
        AnalysisEditor editor = AnalysisEditor.locate((Analysis)this.mDataProvider);
        if (editor != null) {
            ArrayList list = new ArrayList();
            for (Object one : EditorTabID.FUNCTIONS.getIterable((ISelection)this.mOutline.getSelection())) {
                list.add(one);
            }
            editor.select(EditorTabID.FUNCTIONS, (ISelection)new StructuredSelection(list));
        }
    }

    @Override
    public final void selectionChanged(BlockOutline outline) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setSamples(@NonNull List<@NonNull SamplesData> samples) {
        SamplesPanel samplesPanel = this;
        synchronized (samplesPanel) {
            this.mNewSamples = samples;
        }
        Task.callOnUIThread(() -> this.updateSamples());
    }

    private final void askForRowUpdate() {
        CrossSectionMarker csm = this.mDataProvider.getCrossSectionMarker();
        @NonNull ZoomLevel zoomLevel = csm.getDensestZoomLevel();
        long[] range = csm.getDensestRange();
        this.mDataProvider.setSamplesRange(zoomLevel, range[0], range[1], this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateSamples() {
        List<SamplesData> samples;
        SamplesPanel samplesPanel = this;
        synchronized (samplesPanel) {
            samples = this.mNewSamples;
            this.mNewSamples = null;
        }
        if (samples != null) {
            BlockOutlineModel model = this.mOutline.getModel();
            List<BlockOutlineSortState> sortState = BlockOutlineSortState.captureCurrentSortState(model);
            ArrayList<@NonNull SamplesRow> rows = new ArrayList<SamplesRow>();
            model.removeAllRows();
            this.mTotal = 0L;
            SamplesPanel samplesPanel2 = this;
            synchronized (samplesPanel2) {
                for (SamplesData one : samples) {
                    this.mTotal += one.getTotalSamples();
                    rows.add(new SamplesRow(this, one));
                }
            }
            model.addNonHierarchicalRowsFast(rows);
            BlockOutlineSortState.restoreSortState(model, sortState);
            this.repaint();
        }
    }
}

