/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.samples;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SamplesOutline
extends BlockOutline {
    ICaptureDataProvider mDataProvider;

    public SamplesOutline(BlockOutlineModel model, ICaptureDataProvider dataProvider) {
        super(model, false);
        this.mDataProvider = dataProvider;
    }

    @Override
    protected void createContextMenuContent(Point where, Menu menu) {
        super.createContextMenuContent(where, menu);
        this.createSelectInMenuItems(menu);
        this.createOpenSourceFileMenuItem(menu);
    }

    private final void createOpenSourceFileMenuItem(Menu menu) {
        final OpenSourceFileAction action = new OpenSourceFileAction(this, this.mDataProvider::showPathSubstitutionDialog);
        if (action.isEnabled()) {
            ContextMenu.createConditionalSeparator(menu);
            MenuItem item = new MenuItem(menu, 8);
            item.setText(action.getText());
            item.setImage(StreamlinePlugin.getImage("SourceFile.gif"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    action.run();
                }
            });
        }
    }

    private final void createSelectInMenuItems(Menu menu) {
        if (this.mDataProvider instanceof Analysis) {
            ArrayList<EditorTabID> pages = new ArrayList<EditorTabID>();
            IStructuredSelection selection = this.getSelection();
            EditorTabID[] editorTabIDArray = EditorTabID.values();
            int n = editorTabIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                final EditorTabID page = editorTabIDArray[n2];
                if (page.getIterable((ISelection)selection).iterator().hasNext()) {
                    pages.add(page);
                }
                ++n2;
            }
            if (!pages.isEmpty()) {
                ContextMenu.createConditionalSeparator(menu);
                for (final EditorTabID page : pages) {
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText(MessageFormat.format(page == EditorTabID.TIMELINE ? PluginMessages.SELECT_PROCESS_THREAD_IN_FORMAT : PluginMessages.SELECT_IN_FORMAT, new Object[]{page}));
                    item.setImage(page.getImage());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            AnalysisEditor editor = AnalysisEditor.locate((Analysis)SamplesOutline.this.mDataProvider);
                            if (editor != null) {
                                ArrayList list = new ArrayList();
                                for (Object one : page.getIterable((ISelection)SamplesOutline.this.getSelection())) {
                                    list.add(one);
                                }
                                editor.select(page, (ISelection)new StructuredSelection(list));
                            }
                        }
                    });
                }
            }
        }
    }
}

