/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.ruler;

import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.widget.lightweight.Block;
import org.eclipse.swt.graphics.Point;

class CaliperTracker
extends TimelineDragTracker {
    private RulerPanel mRulerPanel;
    private long mStartSlot;
    private long mStartLeft;
    private long mStartRight;

    public CaliperTracker(RulerPanel rulerPanel, Block block, int x) {
        super(block);
        this.mRulerPanel = rulerPanel;
        this.mStartSlot = this.mRulerPanel.translateToSlot(x);
        Calipers calipers = this.mRulerPanel.getBaseTimelineContent().getCaptureDataProvider().getCalipers();
        this.mStartLeft = calipers.getLeft();
        this.mStartRight = calipers.getRight();
    }

    @Override
    public final void mouseDrag(Point where, int stateMask) {
        super.mouseDrag(where, stateMask);
        Calipers calipers = this.mRulerPanel.getBaseTimelineContent().getCaptureDataProvider().getCalipers();
        long max = calipers.getMax();
        long delta = this.mRulerPanel.translateToSlot(where.x) - this.mStartSlot;
        if (delta < -this.mStartLeft) {
            delta = -this.mStartLeft;
        } else {
            long maxDelta = max - this.mStartRight;
            if (delta > maxDelta) {
                delta = maxDelta;
            }
        }
        calipers.set(this.mStartLeft + delta, this.mStartRight + delta);
        this.mRulerPanel.setupAutoScroll(where.x);
    }
}

