/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.process;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.process.ProcessColumns;
import com.arm.streamline.editortabs.timeline.common.process.ProcessOutline;
import com.arm.streamline.editortabs.timeline.common.process.ProcessRow;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.IProcessListener;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockHeader;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineSortState;
import com.arm.streamline.widget.lightweight.outline.IBlockOutlineListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class ProcessPanel
extends Block
implements IProcessListener,
IBlockOutlineListener {
    private BaseTimelineContent mContent;
    private ICaptureDataProvider mDataProvider;
    private ScrollingBlock mScroller;
    private ProcessOutline mOutline;
    private Set<ProcessData> mTransactions = new HashSet<ProcessData>();
    private Set<ProcessData> mSeen = new HashSet<ProcessData>();
    private boolean mReady;

    public ProcessPanel(BaseTimelineContent content) {
        this.mContent = content;
        this.mDataProvider = this.mContent.getCaptureDataProvider();
        BlockOutlineModel model = new BlockOutlineModel();
        model.setShowOutline(false);
        IProcessDataProvider pdp = this.mDataProvider.getProcessDataProvider();
        ProcessColumns[] processColumnsArray = ProcessColumns.values();
        int n = processColumnsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessColumns one = processColumnsArray[n2];
            BlockColumn column = new BlockColumn(one.ordinal(), one.getTitle(), one.getTooltip(), one.getCell());
            column.setSortCriteria(-1, one.isInitialSortAscending());
            column.setPreferredWidth(one.getPreferredWidth());
            model.addColumn(column);
            ++n2;
        }
        BlockHeader header = new BlockHeader();
        header.setLayoutData(new PrecisionLayoutData().setGrabHorizontalSpace(true).setHorizontalAlignment(4));
        this.add(header);
        this.mOutline = new ProcessOutline(pdp, model);
        this.mOutline.addOutlineListener(this);
        this.mOutline.setHeader(header);
        pdp.addProcessListener(this);
        ArrayList<@NonNull ProcessRow> rows = new ArrayList<ProcessRow>();
        int i = 0;
        for (ProcessData one : pdp.getProcessData()) {
            ProcessRow row = new ProcessRow(this, one, i++);
            rows.add(row);
            this.mSeen.add(one);
        }
        model.addNonHierarchicalRowsFast(rows);
        this.mOutline.sizeColumnsToFit();
        this.mOutline.pack();
        this.mOutline.getDefaultConfig();
        this.mScroller = new ScrollingBlock(this.mOutline);
        this.mScroller.setLayoutData(new PrecisionLayoutData().setGrabSpace(true).setFill().setMinimumHeight(0).setMinimumWidth(0));
        this.add(this.mScroller);
        this.setLayout(new PrecisionLayout());
        this.mDataProvider.getCrossSectionMarker().addListener(csm -> this.updateDataValues());
        this.mDataProvider.getScales().addListener(scales -> this.updateDataValues());
        this.mReady = true;
    }

    @Override
    public void deleteSelectionRequested(BlockOutline outline) {
    }

    @Override
    public void editorChanged(BlockOutline outline) {
    }

    public final ICaptureDataProvider getDataProvider() {
        return this.mDataProvider;
    }

    public final BlockOutline getOutline() {
        return this.mOutline;
    }

    @Override
    public void openSelectionRequested(BlockOutline outline) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void processChanged(ProcessData processData) {
        ProcessPanel processPanel = this;
        synchronized (processPanel) {
            this.mTransactions.add(processData);
        }
    }

    @Override
    public void selectionChanged(BlockOutline outline) {
        this.mContent.getChartsPanel().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void transactionCommitted() {
        if (this.mReady) {
            ProcessData[] data;
            ProcessPanel processPanel = this;
            synchronized (processPanel) {
                data = this.mTransactions.toArray(new ProcessData[this.mTransactions.size()]);
                this.mTransactions.clear();
            }
            if (data.length > 0) {
                Task.callOnUIThread(() -> {
                    BlockOutlineModel model = this.mOutline.getModel();
                    int rowCount = model.getRowCount();
                    ArrayList<@NonNull ProcessRow> rowsToAdd = new ArrayList<ProcessRow>();
                    ProcessData[] processDataArray2 = data;
                    int n = data.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProcessData one = processDataArray2[n2];
                        if (!this.mSeen.contains(one)) {
                            this.mSeen.add(one);
                            ProcessRow row = new ProcessRow(this, one, rowCount++);
                            rowsToAdd.add(row);
                        }
                        ++n2;
                    }
                    List<BlockOutlineSortState> state = BlockOutlineSortState.captureCurrentSortState(model);
                    if (!rowsToAdd.isEmpty()) {
                        model.addNonHierarchicalRowsFast(rowsToAdd);
                        this.mOutline.pack();
                    }
                    BlockOutlineSortState.restoreSortState(model, state);
                    this.mOutline.repaint();
                });
            }
        }
    }

    private final void updateDataValues() {
        BlockOutlineModel model = this.mOutline.getModel();
        BlockOutlineSortState.restoreSortState(model, BlockOutlineSortState.captureCurrentSortState(model));
        this.mOutline.repaint();
    }
}

