/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.process;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.timeline.common.process.ProcessRow;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.streamline.widget.lightweight.outline.BlockTextCell;
import com.arm.streamline.widget.lightweight.outline.IBlockColumnCompareType;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class MemoryCell
extends BlockTextCell {
    private static final String UNITS_PROXY = NumberUtils.getByteUnits((long)0x100000L);
    private static final String UNITS_PROXY_WITH_GAP = " " + UNITS_PROXY;

    public MemoryCell() {
        super(131072, IBlockColumnCompareType.INTEGER);
    }

    @Override
    public final void drawCell(GC gc, Rectangle bounds, BlockRow row, BlockColumn column, boolean selected, boolean active) {
        long bytes = row.getDataAsLong(column);
        if (bytes >= 0L && ((ProcessRow)row).isAlive()) {
            Font font = this.getFont(row, column);
            gc.setFont(font);
            int width = gc.stringExtent((String)MemoryCell.UNITS_PROXY_WITH_GAP).x;
            super.drawCell(gc, new Rectangle(bounds.x, bounds.y, bounds.width - width, bounds.height), row, column, selected, active);
            gc.setForeground(Colors.getDarkGray());
            TextDrawing.drawString(gc, NumberUtils.getByteUnits((long)bytes), bounds.x + bounds.width - (4 + gc.stringExtent((String)MemoryCell.UNITS_PROXY).x), bounds.y + 1, 16384);
        }
    }

    @Override
    public final Point getPreferredSize(GC gc, BlockRow row, BlockColumn column) {
        Point size = super.getPreferredSize(gc, row, column);
        Font font = this.getFont(row, column);
        FontInfo fontInfo = FontInfo.get(font);
        size.x += fontInfo.getWidth(UNITS_PROXY_WITH_GAP);
        return size;
    }
}

