/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.heatmap;

import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.GraphBlock;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapHandlePanel;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapMessages;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.ThreadAnnotation;
import com.arm.streamline.model.process.TimelineMapMode;
import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class HeatMapPanel
extends GraphBlock {
    private static final RGB ARM_BLUE = new RGB(12, 161, 194);
    private static final Color AGGREGATE_COLOR = Colors.create(44, 64, 84);
    private static final Color CONTENTION_COLOR = Colors.create(60, 150, 251);
    private static final Color IO_COLOR = Colors.getRed();
    private static final Color VM_COLOR = Colors.create(47, 112, 47);
    private HeatMapHandlePanel mHandlePanel;
    private Color mDormantColor;

    private static final void addName(String name, StringBuilder buffer) {
        if (buffer.length() > 0) {
            buffer.append('\n');
        }
        if (name.trim().isEmpty()) {
            buffer.append(HeatMapMessages.NO_TITLE);
        } else {
            buffer.append(name);
        }
    }

    private static final void drawBlocks(GC gc, Color color, int left, int x, int y, int height) {
        gc.setBackground(color);
        int width = x - left;
        gc.fillRectangle(left, y, width, height);
    }

    public HeatMapPanel(HeatMapHandlePanel handlePanel) {
        super(handlePanel.getContent());
        this.mHandlePanel = handlePanel;
    }

    @Override
    protected void mouseSlotWasUpdated() {
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        this.updateThemeColors();
        this.drawBackgroundWithVerticalGroupingMarkers(gc, false);
        this.drawBars(gc);
        this.drawCaliperEnds(gc);
        this.drawBookmarks(gc);
        this.drawCrossSectionMarker(gc);
        this.updatePositionReadout();
    }

    @Override
    protected final void updateMouseSlot(Point where) {
        super.updateMouseSlot(where);
        String text = null;
        ITimelineRowProvider row = this.mHandlePanel.getRow();
        switch (row.getRowType()) {
            case PROCESS: 
            case THREAD: {
                text = this.getToolTipForProcessBars(row);
                break;
            }
            case GROUP: 
            case ANNOTATION: {
                text = this.getToolTipForAnnotations(row);
                break;
            }
            case VMUID: {
                break;
            }
        }
        this.setToolTip(text);
    }

    @Override
    protected final void updateThemeColors() {
        super.updateThemeColors();
        switch (StreamlinePreferences.getTheme()) {
            default: {
                this.mDormantColor = Colors.create(43, 43, 43);
                break;
            }
            case LIGHT: {
                this.mDormantColor = Colors.create(212, 212, 212);
            }
        }
    }

    private final void drawAnnotation(GC gc, ITimelineRowProvider row) {
        int firstX;
        BaseTimelineContent content = this.mHandlePanel.getContent();
        ICaptureDataProvider cdp = content.getCaptureDataProvider();
        Pattern pattern = content.getAnnotationFilterPattern();
        Calipers calipers = cdp.getCalipers();
        long calipersLeft = calipers.getLeft();
        long calipersRight = calipers.getRight();
        Rectangle bounds = this.getLocalBounds();
        long first = this.getFirstVisibleSlot();
        long last = this.getLastVisibleSlot();
        int x = firstX = (int)this.translateFromSlot(first);
        int y = bounds.y + 2;
        int height = bounds.height - 5;
        gc.setForeground(this.getThemeBorder());
        String title = null;
        gc.setFont(Fonts.getSmall());
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        List<ThreadAnnotation> annotationData = row.getAnnotationData((int)first, (int)last);
        int count = annotationData.size();
        int i = 0;
        while (i < count) {
            ThreadAnnotation annotation = annotationData.get(i);
            if (annotation != null) {
                boolean filtered;
                long startIndex = first + (long)i;
                int left = x;
                int width = 6;
                while (i < count - 1) {
                    ThreadAnnotation next = annotationData.get(i + 1);
                    if (next == null) break;
                    ++i;
                    width += 6;
                    if (next.isStartFrame() || next.isEndFrame()) break;
                }
                x += width - 6;
                long endIndex = first + (long)i;
                RGB color = annotation.getColor();
                boolean bl = filtered = pattern != null && !pattern.matcher(annotation.getDescription()).find();
                if (filtered || startIndex >= calipersRight || endIndex < calipersLeft) {
                    color = theme.desaturate(color);
                }
                gc.setBackground(Colors.create(color));
                gc.fillRectangle(left, y, width, height);
                gc.drawRectangle(left, y, width, height - 1);
                if (!filtered) {
                    int titleRight;
                    title = annotation.getDescription();
                    int titleLeft = left;
                    if (titleLeft < bounds.x) {
                        titleLeft = bounds.x;
                    }
                    if ((titleRight = left + width) > bounds.x + bounds.width) {
                        titleRight = bounds.x + bounds.width;
                    }
                    int titleWidth = (titleRight -= 2) - (titleLeft += 2);
                    gc.setForeground(RGBUtils.isDark(color) ? Colors.getWhite() : Colors.getBlack());
                    if (title.length() > 2) {
                        if (titleWidth < 6) {
                            title = ".";
                        } else if (titleWidth < 12) {
                            title = "\u2026";
                        }
                    }
                    TextDrawing.drawString(gc, title, titleLeft, y, titleWidth, height, 0x1000000, 0x1000000);
                    gc.setForeground(this.getThemeBorder());
                }
            }
            x += 6;
            ++i;
        }
        gc.setAntialias(savedAA);
    }

    private final void drawBars(GC gc) {
        ITimelineRowProvider row = this.mHandlePanel.getRow();
        switch (row.getRowType()) {
            case PROCESS: 
            case THREAD: {
                this.drawProcessBars(gc, row);
                this.drawVerticalMarkers(gc);
                break;
            }
            case GROUP: 
            case ANNOTATION: {
                this.drawVerticalMarkers(gc);
                this.drawAnnotation(gc, row);
                break;
            }
            case VMUID: {
                this.drawVmBar(gc, row);
                break;
            }
        }
    }

    private void drawVmBar(GC gc, ITimelineRowProvider row) {
        ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
        Scales scales = cdp.getScales();
        ZoomLevel zoomLevel = scales.getZoomLevel();
        Color color = VM_COLOR;
        gc.setForeground(color);
        gc.setBackground(color);
        Rectangle bounds = this.getLocalBounds();
        long firstVisible = this.getFirstVisibleSlot();
        long lastVisible = this.getLastVisibleSlot();
        long firstActive = zoomLevel.convertNanosecondsToBin(row.getVmStartTimeNs());
        long lastActive = zoomLevel.convertNanosecondsToBin(row.getVmEndTimeNs());
        long first = Math.max(firstVisible, firstActive);
        long last = Math.min(lastVisible, lastActive);
        int firstX = (int)this.translateFromSlot(first);
        int lastX = (int)(this.translateFromSlot(last) + 6L);
        int y = bounds.y + 2;
        int width = lastX - firstX + 1;
        int height = bounds.height - 5;
        int lineWidth = 3;
        int lineHeight = 3;
        int lineY = y + height / 2 - 1;
        if (firstActive >= firstVisible) {
            gc.fillRectangle(firstX, y, 3, height);
        }
        if (lastActive <= lastVisible) {
            gc.fillRectangle(firstX + width - 3, y, 3, height);
        }
        gc.fillRectangle(firstX, lineY, width, 3);
    }

    private final void drawProcessBars(GC gc, ITimelineRowProvider row) {
        Object color;
        int value;
        long index;
        ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
        Scales scales = cdp.getScales();
        ZoomLevel zoomLevel = scales.getZoomLevel();
        Calipers calipers = cdp.getCalipers();
        long calipersLeft = calipers.getLeft();
        long calipersRight = calipers.getRight();
        Rectangle bounds = this.getLocalBounds();
        long firstVisible = this.getFirstVisibleSlot();
        long lastVisible = this.getLastVisibleSlot();
        long firstActive = zoomLevel.convertNanosecondsToBin(row.getVmStartTimeNs());
        long lastActive = zoomLevel.convertNanosecondsToBin(row.getVmEndTimeNs());
        long first = Math.max(firstVisible, firstActive);
        long last = Math.min(lastVisible, lastActive);
        int[] mapData = row.getMapData((int)first, (int)last);
        int firstX = (int)this.translateFromSlot(first);
        int y = bounds.y - 1;
        int height = bounds.height;
        boolean isIdle = row.isIdle();
        boolean hasNonAnnotationChildren = row.getChildren().stream().filter(c -> !c.getRowType().isAnnotationOrGroup()).findAny().isPresent();
        TimelineMapMode mode = cdp.getMapProvider().getMode();
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        gc.setForeground(this.getThemeBorder());
        int x = firstX;
        int left = 0;
        Color lastColor = null;
        long i = first;
        while (i <= last) {
            index = i - first;
            if (index >= 0L && index < (long)mapData.length) {
                value = mapData[(int)index];
                if (value != -1) {
                    color = this.getColor(isIdle, hasNonAnnotationChildren, mode, value);
                    if (i < calipersLeft || i >= calipersRight) {
                        color = theme.desaturate((Color)color);
                    }
                    if (lastColor == null) {
                        lastColor = color;
                        left = x;
                    } else if (!lastColor.equals(color)) {
                        HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                        lastColor = color;
                        left = x;
                    }
                } else if (lastColor != null) {
                    HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                    lastColor = null;
                }
            } else if (lastColor != null) {
                HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
                lastColor = null;
            }
            x += 6;
            ++i;
        }
        if (lastColor != null) {
            HeatMapPanel.drawBlocks(gc, lastColor, left, x, y, height);
        }
        if (!isIdle) {
            x = firstX;
            i = first;
            while (i <= last) {
                index = i - first;
                if (index >= 0L && index < (long)mapData.length && (color = (value = mapData[(int)index]) == -3 ? CONTENTION_COLOR : (value == -4 ? IO_COLOR : null)) != null) {
                    if (i < calipersLeft || i >= calipersRight) {
                        color = theme.desaturate((Color)color);
                    }
                    gc.setBackground(color);
                    gc.fillRectangle(x + 1, y + height / 2 - 1, 4, 3);
                }
                x += 6;
                ++i;
            }
        }
    }

    private Color getColor(boolean isIdle, boolean hasNonAnnotationChildren, TimelineMapMode mode, int value) {
        return switch (mode) {
            default -> {
                if (value < 1) {
                    yield this.mDormantColor;
                }
                if (isIdle) {
                    yield Colors.darken(ARM_BLUE, (int)(50.0 - (double)(50 * value) / 10000.0));
                }
                if (hasNonAnnotationChildren && this.mHandlePanel.isOpen()) {
                    yield AGGREGATE_COLOR;
                }
                yield Colors.heat((double)value / 100.0);
            }
            case TimelineMapMode.CORE_MAP -> {
                if (value < 0) {
                    yield this.mDormantColor;
                }
                if (hasNonAnnotationChildren && this.mHandlePanel.isOpen()) {
                    yield AGGREGATE_COLOR;
                }
                yield Colors.getCoreColor(value);
            }
            case TimelineMapMode.CLUSTER_MAP -> value < 0 ? this.mDormantColor : (hasNonAnnotationChildren && this.mHandlePanel.isOpen() ? AGGREGATE_COLOR : Colors.getClusterColor(value));
        };
    }

    private final String getToolTipForAnnotations(ITimelineRowProvider row) {
        List<String> list = row.getAnnotationList((int)this.getLastMouseSlot());
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int count = list.size();
        if (count <= 6) {
            for (String one : list) {
                HeatMapPanel.addName(one, buffer);
            }
        } else {
            int i = 0;
            while (i < 5) {
                HeatMapPanel.addName(list.get(i), buffer);
                ++i;
            }
            buffer.append('\n');
            buffer.append(String.format(HeatMapMessages.MORE, count - 5));
        }
        return buffer.toString();
    }

    private final String getToolTipForProcessBars(ITimelineRowProvider row) {
        long first = this.getFirstVisibleSlot();
        long last = this.getLastVisibleSlot();
        int[] mapData = row.getMapData((int)first, (int)last);
        long index = this.getLastMouseSlot() - first;
        if (index >= 0L && index < (long)mapData.length) {
            int value = mapData[(int)index];
            boolean notIdle = !row.isIdle();
            switch (value) {
                case -3: {
                    if (!notIdle) break;
                    return HeatMapMessages.WAIT_CONTENTION;
                }
                case -4: {
                    if (!notIdle) break;
                    return HeatMapMessages.WAIT_IO;
                }
                case -2: {
                    if (!notIdle) break;
                    return HeatMapMessages.DORMANT;
                }
                case -1: {
                    break;
                }
                default: {
                    ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
                    @NonNull ICaptureDataProvider.IFocusedEventSource fes = cdp.getFocusedEventSource();
                    switch (cdp.getMapProvider().getMode()) {
                        case HEAT_MAP: {
                            return NumberUtils.formatPercentage((double)((double)value / 100.0), (boolean)false);
                        }
                        case CORE_MAP: {
                            return fes.getCoreDescription(value);
                        }
                        case CLUSTER_MAP: {
                            return fes.getClusterDescription(value);
                        }
                    }
                }
            }
        }
        return null;
    }
}

