/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.divider;

import com.arm.streamline.common.model.IScaleListener;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.charts.IHandleAreaListener;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionListener;
import com.arm.streamline.editortabs.timeline.common.divider.RepositionTracker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ZoomCentering;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockRoot;
import com.arm.streamline.widget.lightweight.BlockScrollBar;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DividerPanel
extends Block
implements BlockScrollBar.IBlockScrollListener,
IHandleAreaListener,
IScaleListener,
IBlockLayout {
    private static final int AUTOSCROLL_TO_END = 0x7FFFFFFE;
    private static final int AUTOSCROLL_SLOP = 60;
    private static final int MAX_AHEAD = 5;
    private static final int GRIP_MARGIN = 5;
    private static final int GRIP_WIDTH = 16;
    private static final int GRIP_SIZE = 8;
    private BaseTimelineContent mTimelineContent;
    private List<ITimelinePositionListener> mListeners = new ArrayList<ITimelinePositionListener>();
    private BlockScrollBar mScrollBar;
    private DragTracker mTracker;
    private long mCaptureStarted;
    private long mLastPosition;
    private boolean mCaptureEnded;

    public DividerPanel(BaseTimelineContent content) {
        this.setBackgroundColor(Colors.darken(Colors.getWidgetBackground(), 5));
        this.mTimelineContent = content;
        this.mScrollBar = new BlockScrollBar(true, this.getBackgroundColor());
        this.mScrollBar.setIncrement(30L);
        this.mScrollBar.addScrollListener(this);
        this.add(this.mScrollBar);
        this.mCaptureStarted = System.currentTimeMillis();
        this.setLayout(this);
    }

    public final synchronized void addPositionListener(ITimelinePositionListener listener) {
        this.mListeners.add(listener);
    }

    public final boolean autoScrollToEndIfNeeded() {
        return this.setPosition(0x7FFFFFFEL);
    }

    public final void drawBackground(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        int left = bounds.x;
        int right = left + bounds.width - 1;
        int bottom = bounds.y + bounds.height - 1;
        gc.setForeground(Colors.getWidgetNormalShadow());
        gc.drawLine(left, bounds.y, right, bounds.y);
        gc.drawLine(left, bottom, right, bottom);
        gc.setAntialias(savedAA);
    }

    public long getLastPosition() {
        return this.mLastPosition;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        return this.getPreferredSize(target, widthHint, heightHint);
    }

    public final long getPosition() {
        return this.mScrollBar.getValue();
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        Point size = this.mScrollBar.getPreferredSize(-1, -1);
        size.x += this.getTimelineContent().getHandleAreaWidth();
        return size;
    }

    public final BlockScrollBar getScrollBar() {
        return this.mScrollBar;
    }

    public final BaseTimelineContent getTimelineContent() {
        return this.mTimelineContent;
    }

    @Override
    public final void handleAreaWidthChanged() {
        this.layout();
    }

    public final boolean isWithinAutoScrollAtEndRange() {
        return this.getPosition() >= this.mScrollBar.getMaximum() - this.mScrollBar.getThumb() - 60L;
    }

    @Override
    public final void layout(Block target) {
        Rectangle bounds = this.getLocalBounds();
        int handleWidth = this.getTimelineContent().getHandleAreaWidth() - 1;
        this.mScrollBar.setBounds(bounds.x + handleWidth, bounds.y, bounds.width - handleWidth, bounds.height);
    }

    public final void pan(boolean left, boolean fast) {
        int amount = 6;
        if (left) {
            amount = -amount;
        }
        if (fast) {
            amount *= 10;
        }
        this.setPosition(this.getPosition() + (long)amount);
    }

    public final synchronized void removePositionListener(ITimelinePositionListener listener) {
        this.mListeners.remove(listener);
    }

    public final void scaleChanged(Scales scales) {
        this.setPosition(this.getPosition());
    }

    @Override
    public final void scrollBarWasAdjusted(BlockScrollBar scrollBar, boolean adjustedByUser) {
        this.notifyOfTimelinePositionChange();
        if (adjustedByUser) {
            this.mTimelineContent.getCaptureDataProvider().getCrossSectionMarker().setZoomCentering(ZoomCentering.VIEW);
        }
    }

    public final void setCaptureEnded() {
        this.mCaptureEnded = true;
    }

    public final boolean setPosition(long position) {
        ICaptureDataProvider cdp = this.mTimelineContent.getCaptureDataProvider();
        if (cdp != null) {
            long max;
            long timeRange;
            long current = this.getPosition();
            long thumb = Math.max(this.mTimelineContent.getChartsPanel().getViewPortBounds().width - this.mTimelineContent.getHandleAreaWidth(), 1);
            Scales scales = cdp.getScales();
            @NonNull ZoomLevel zoomLevel = scales.getZoomLevel();
            int numberOfBins = cdp.getLastBinCount();
            if (this.mCaptureEnded) {
                timeRange = numberOfBins + 5;
            } else {
                long delta;
                timeRange = Position.scale((long)(System.currentTimeMillis() - this.mCaptureStarted), (ZoomLevel)Scales.ONE_MILLISECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
                if (timeRange < (long)numberOfBins) {
                    timeRange = numberOfBins;
                }
                if ((delta = timeRange - (long)(numberOfBins + 5)) > 0L) {
                    timeRange -= (delta += 2L);
                    this.mCaptureStarted += Position.scale((long)delta, (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_MILLISECOND_ZOOM_LEVEL);
                }
            }
            long l = max = this.mScrollBar.isTracking() ? this.mScrollBar.getMaximum() : (timeRange + 5L) * 6L;
            if (max > thumb) {
                long range = max - thumb;
                if (position == 0x7FFFFFFEL) {
                    position = this.isWithinAutoScrollAtEndRange() ? range : current;
                } else if (position == Integer.MAX_VALUE) {
                    position = range;
                }
            } else {
                position = 0L;
            }
            this.mScrollBar.setMaximum(max);
            this.mScrollBar.setThumb(thumb);
            this.mScrollBar.setValue(position);
            if (current != this.mScrollBar.getValue()) {
                this.notifyOfTimelinePositionChange();
                return true;
            }
        }
        return false;
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        this.adjustCursor(where);
        if (button == 1 && this.isOverRepositionGrip(where.x, where.y)) {
            if (count == 2) {
                this.mTimelineContent.setDividerPosition(-1);
            } else {
                this.mTracker = new RepositionTracker(this, this, where.y);
            }
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.mTracker.mouseDrag(where, stateMask);
        } else {
            this.mTimelineContent.setBookmarkPopOver(null);
            this.adjustCursor(where);
        }
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.mTimelineContent.setBookmarkPopOver(null);
        this.adjustCursor(where);
    }

    @Override
    protected void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
        this.adjustCursor(where);
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        this.drawBackground(gc);
        this.drawRepositionGrip(gc);
    }

    @Override
    protected final void wasAdded(Block parent) {
        super.wasAdded(parent);
        this.mTimelineContent.getCaptureDataProvider().getScales().addListener((IScaleListener)this);
        BlockRoot root = this.getRoot();
        root.addKeyCodeHandler(() -> this.pan(true, false), 0x1000003, 65536);
        root.addKeyCodeHandler(() -> this.pan(true, true), 0x1000003, 196608);
        root.addKeyCodeHandler(() -> this.pan(false, false), 0x1000004, 65536);
        root.addKeyCodeHandler(() -> this.pan(false, true), 0x1000004, 196608);
    }

    @Override
    protected final void wasRemoved(Block parent) {
        super.wasRemoved(parent);
        this.mTimelineContent.getCaptureDataProvider().getScales().removeListener((IScaleListener)this);
    }

    private final void adjustCursor(Point where) {
        this.setCursor(this.getDisplay().getSystemCursor(this.isOverRepositionGrip(where.x, where.y) ? 7 : 0));
    }

    private final void drawRepositionGrip(GC gc) {
        Rectangle bounds = this.getRepositionGripHitArea();
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int right = x + width;
        gc.setForeground(Colors.getBlack());
        gc.setAlpha(64);
        gc.drawLine(x, y, right, y);
        gc.drawLine(x, y += 3, right, y);
        gc.drawLine(x, y += 3, right, y);
        gc.setForeground(Colors.getWhite());
        gc.drawLine(x, y -= 5, right, y);
        gc.drawLine(x, y += 3, right, y);
        gc.drawLine(x, y += 3, right, y);
        gc.setAlpha(255);
        gc.setAntialias(savedAA);
    }

    private final Rectangle getRepositionGripHitArea() {
        Rectangle bounds = this.getLocalBounds();
        bounds.width = 16;
        bounds.x += 5;
        bounds.y += (bounds.height - 7) / 2;
        bounds.height = 8;
        return bounds;
    }

    private final boolean isOverRepositionGrip(int x, int y) {
        return this.getRepositionGripHitArea().contains(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOfTimelinePositionChange() {
        ITimelinePositionListener[] listeners;
        this.mTimelineContent.setBookmarkPopOver(null);
        this.mLastPosition = this.getPosition();
        DividerPanel dividerPanel = this;
        synchronized (dividerPanel) {
            listeners = this.mListeners.toArray(new ITimelinePositionListener[this.mListeners.size()]);
        }
        ITimelinePositionListener[] iTimelinePositionListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITimelinePositionListener listener = iTimelinePositionListenerArray[n2];
            listener.timelinePositionChanged();
            ++n2;
        }
    }
}

