/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.charts.ChartConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.editortabs.timeline.common.charts.ConfigurationPanelUtility;
import com.arm.streamline.editortabs.timeline.common.charts.ISeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.SeriesPanelMoveTracker;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.timeline.VariableContentProposalProvider;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockColorWell;
import com.arm.streamline.widget.lightweight.BlockImageButton;
import com.arm.streamline.widget.lightweight.BlockLabel;
import com.arm.streamline.widget.lightweight.BlockPopupMenu;
import com.arm.streamline.widget.lightweight.BlockScrollBar;
import com.arm.streamline.widget.lightweight.BlockTextField;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class SeriesConfigurationPanel
extends Block
implements ISeriesConfigurationPanel {
    private static final int GAP = 10;
    private @NonNull ChartConfigurationPanel mConfigPanel;
    protected @NonNull ISeriesDataProvider mSeries;
    private BlockTextField mNameField;
    private BlockTextField mExpressionField;
    private BlockPopupMenu mDisplayTypePopup;
    private @Nullable DragTracker mTracker;
    private boolean mAutoScrollPending;

    public SeriesConfigurationPanel(@NonNull ChartConfigurationPanel configPanel, @NonNull ISeriesDataProvider series) {
        this.mConfigPanel = configPanel;
        this.mSeries = series;
        this.setBackgroundColor(Colors.getWidgetBackground());
        this.setLayout(new PrecisionLayout().setMargins(6, 30, 0, 0).setColumns(6).setSpacing(4, 2));
        AbstractSeriesConfig config = this.getSeriesConfig();
        BlockColorWell colorWell = new BlockColorWell(config.getColor());
        colorWell.addColorChangedListener(rgb -> {
            this.getSeriesConfig().setColor(rgb);
            this.mConfigPanel.getChartHandlePanel().repaint();
        });
        this.add(colorWell);
        BlockLabel label = new BlockLabel(ChartMessages.SERIES_TITLE);
        label.setToolTip(ChartMessages.SERIES_TITLE_TOOLTIP);
        label.setLayoutData(new PrecisionLayoutData().setHorizontalAlignment(131072));
        this.add(label);
        this.mNameField = ConfigurationPanelUtility.addField(this, config.getName(), 125, field -> {
            this.getSeriesConfig().setName(field.getText());
            this.mConfigPanel.getChartHandlePanel().repaint();
        });
        this.add(new BlockLabel(ChartMessages.SERIES_DESCRIPTION_TITLE));
        ConfigurationPanelUtility.addField(this, config.getDescriptionFormat(), 0, field -> this.getSeriesConfig().setDescriptionFormat(field.getText()));
        BlockImageButton deleteButton = new BlockImageButton(StreamlinePlugin.getImage("Discard.png"));
        deleteButton.setToolTip(ChartMessages.REMOVE_SERIES_TITLE);
        deleteButton.addClickListener(button -> {
            boolean remove = ConfigurationPanelUtility.confirmRemoveSeriesDialog(this);
            if (remove) {
                this.removeSeries();
            }
        });
        this.add(deleteButton);
        label = new BlockLabel(ChartMessages.SERIES_EXPRESSION);
        label.setToolTip(ChartMessages.SERIES_EXPRESSION_TOOLTIP);
        label.setLayoutData(new PrecisionLayoutData().setHorizontalSpan(2).setHorizontalAlignment(131072));
        this.add(label);
        Block wrapper = new Block();
        wrapper.setLayoutData(new PrecisionLayoutData().setHorizontalSpan(3).setHorizontalAlignment(4).setGrabHorizontalSpace(true));
        wrapper.setLayout(new PrecisionLayout().setColumns(4).setSpacing(4, 1));
        this.add(wrapper);
        this.mExpressionField = ConfigurationPanelUtility.addField(wrapper, config.getExpression(), 0, field -> {
            this.getSeriesConfig().setExpression(field.getText());
            this.updateExpressionBackground();
            this.mConfigPanel.getChartHandlePanel().clearSharedLimit();
            this.mConfigPanel.getChartHandlePanel().adjustForSeriesExpressionChange();
        });
        this.mExpressionField.setProposalProvider(new VariableContentProposalProvider(this.mConfigPanel.getChartHandlePanel().getCaptureDataProvider()));
        this.mDisplayTypePopup = new BlockPopupMenu();
        CounterDisplay[] counterDisplayArray = CounterDisplay.values();
        int n = counterDisplayArray.length;
        int n2 = 0;
        while (n2 < n) {
            CounterDisplay one = counterDisplayArray[n2];
            this.mDisplayTypePopup.addMenuItem(one.getPresentationName(), one);
            ++n2;
        }
        this.mDisplayTypePopup.selectItemWithData(config.getDisplay());
        this.mDisplayTypePopup.addPopupMenuItemSelectionListener((popupMenu, itemIndex, data) -> {
            this.getSeriesConfig().setDisplay((CounterDisplay)data);
            this.updateExpressionBackground();
            this.mConfigPanel.getChartHandlePanel().clearSharedLimit();
            this.mConfigPanel.getChartHandlePanel().repaint();
        });
        wrapper.add(this.mDisplayTypePopup);
        wrapper.add(new BlockLabel(ChartMessages.SERIES_UNIT));
        ConfigurationPanelUtility.addField(wrapper, config.getUnits(), 30, field -> {
            this.getSeriesConfig().setUnits(field.getText());
            this.mConfigPanel.getChartHandlePanel().repaint();
        });
        this.updateExpressionBackground();
    }

    @Override
    public final ChartConfigurationPanel getConfigPanel() {
        return this.mConfigPanel;
    }

    @Override
    public final ISeriesDataProvider getSeries() {
        return this.mSeries;
    }

    public final void selectAndFocusNameField() {
        this.mNameField.selectAll();
        this.getOwner().setFocus(this.mNameField);
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1 && this.isOverDragGrip(where) && this.getConfigPanel().getChartHandlePanel().getChart().getWildcardSeries().isEmpty()) {
            this.mTracker = new SeriesPanelMoveTracker(this, where, stateMask, this);
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.mTracker.mouseDrag(where, stateMask);
        }
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.mConfigPanel.getChartHandlePanel().getChartsPanel().getBaseTimelineContent().setBookmarkPopOver(null);
        this.adjustCursor(where);
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
        this.adjustCursor(where);
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        Rectangle bounds = this.getLocalBounds();
        gc.setForeground(Colors.getDivider());
        gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
        gc.setAntialias(savedAA);
        ConfigurationPanelUtility.drawDragGrip(gc, this);
    }

    private final void adjustCursor(Point where) {
        if (this.isOverDragGrip(where)) {
            this.setCursor(StreamlinePlugin.getOpenHandCursor());
        } else {
            this.setCursor(null);
        }
    }

    private final @NonNull AbstractSeriesConfig getSeriesConfig() {
        return this.mSeries.getConfig();
    }

    private final boolean isOverDragGrip(Point where) {
        return ConfigurationPanelUtility.getDragGripBounds(this).contains(where);
    }

    private final void updateExpressionBackground() {
        Color expressionColor = Colors.getListBackground();
        Color displayTypeColor = null;
        switch (this.mSeries.getWarningSource()) {
            case DUMMY_COUNTER: 
            case EXPRESSION: 
            case INVALID_COUNTER: {
                expressionColor = ConfigurationPanelUtility.INVALID_BACKGROUND;
                break;
            }
            case COUNTER_DISPLAY: {
                displayTypeColor = ConfigurationPanelUtility.INVALID_BACKGROUND;
                break;
            }
        }
        this.mExpressionField.setBackgroundColor(expressionColor);
        this.mDisplayTypePopup.setBackgroundColor(displayTypeColor);
    }

    @Override
    public void removeSeries() {
        ChartHandlePanel chartHandlePanel = this.mConfigPanel.getChartHandlePanel();
        int height = this.getHeight();
        chartHandlePanel.getChart().remove(this.mSeries);
        this.removeFromParent();
        chartHandlePanel.seriesCountChanged(-height);
    }

    private final void autoScroll(int amount) {
        BlockScrollBar scrollbar;
        int y;
        this.mAutoScrollPending = false;
        ScrollingBlock scroller = this.getContainingScrollingBlock();
        if (scroller != null && ConfigurationPanelUtility.getScrollAmount(this, scroller, y = this.fromDisplay((Point)this.getDisplay().getCursorLocation()).y) != 0 && (scrollbar = scroller.getVerticalBar()) != null) {
            scrollbar.setValue(scrollbar.getValue() + (long)amount);
            if (this.mTracker != null) {
                this.mTracker.mouseDrag(new Point(0, y), 0);
            }
        }
    }

    @Override
    public void setupAutoScroll(int y) {
        int amount;
        ScrollingBlock scroller;
        if (!this.mAutoScrollPending && (scroller = this.getContainingScrollingBlock()) != null && (amount = ConfigurationPanelUtility.getScrollAmount(this, scroller, y)) != 0) {
            this.mAutoScrollPending = true;
            int scroll = amount;
            Task.scheduleOnUIThread(() -> this.autoScroll(scroll), null, (long)150L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public void replaceSeries(@NonNull ChartConfigurationPanel configPanel, @NonNull ISeriesDataProvider series) {
        this.mConfigPanel = configPanel;
        this.mSeries = series;
    }
}

