/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineDragTracker;
import com.arm.streamline.editortabs.timeline.common.charts.IChartDragScrollable;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ZoomCentering;
import com.arm.streamline.widget.lightweight.Block;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Point;

public class ChartDragScrollTracker
extends TimelineDragTracker {
    private IChartDragScrollable mTarget;
    private Point mStart;
    private long mInitialPosition;
    private boolean mMoved;

    public ChartDragScrollTracker(IChartDragScrollable target, int x, int y) {
        super((Block)((Object)target));
        this.mTarget = target;
        Block block = this.getBlock();
        this.mStart = block.toRoot(x, y);
        this.mInitialPosition = this.mTarget.getBaseTimelineContent().getDividerPanel().getPosition();
        block.getOwner().applyCursor(StreamlinePlugin.getClosedHandCursor());
    }

    @Override
    public final void mouseDrag(Point where, int stateMask) {
        BaseTimelineContent content = this.mTarget.getBaseTimelineContent();
        content.getDividerPanel().setPosition(this.mInitialPosition + (long)(-(this.getBlock().toRootX(where.x) - this.mStart.x)));
        content.getCaptureDataProvider().getCrossSectionMarker().setZoomCentering(ZoomCentering.VIEW);
        this.mMoved = true;
    }

    @Override
    public final void mouseUp(Point where, int button, int stateMask, int count) {
        Block block = this.getBlock();
        block.getOwner().applyCursor(block.getCursor(where));
        if (!this.mMoved && !this.mTarget.handleMouseUpWithoutDrag(block.fromRoot(this.mStart.x, this.mStart.y), button, stateMask, count)) {
            long slot = this.mTarget.translateToSlot(block.fromRootX(this.mStart.x));
            @Nullable CrossSectionMarker crossSectionMarker = this.mTarget.getBaseTimelineContent().getCaptureDataProvider().getCrossSectionMarker();
            if (crossSectionMarker != null && slot >= 0L) {
                if ((stateMask & 0x20000) != 0) {
                    Long start = crossSectionMarker.getSelectionStart();
                    if (start != null) {
                        crossSectionMarker.setWithInitialPosition(start, slot);
                    } else if (Math.abs(slot - crossSectionMarker.getLeft()) < Math.abs(slot - crossSectionMarker.getRight())) {
                        crossSectionMarker.setLeft(slot);
                    } else {
                        crossSectionMarker.setRight(slot);
                    }
                } else {
                    crossSectionMarker.setWithInitialPosition(slot, slot);
                }
            }
        }
    }
}

