/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.analysis.model.cam.ICAMDataProvider;
import com.arm.streamline.analysis.model.cam.ICAMJobProvider;
import com.arm.streamline.analysis.model.cam.ICAMTrackProvider;
import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.IScaleListener;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.HandlePanel;
import com.arm.streamline.editortabs.timeline.common.bookmarks.IBookmarkListener;
import com.arm.streamline.editortabs.timeline.common.cam.ConnectionLine;
import com.arm.streamline.editortabs.timeline.common.cam.ConnectionLineType;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapHandlePanel;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapMessages;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapPanel;
import com.arm.streamline.editortabs.timeline.common.charts.IHandleAreaListener;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionListener;
import com.arm.streamline.model.capture.CAMConfig;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICalipersListener;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ICrossSectionMarkerListener;
import com.arm.streamline.utility.text.TextFilter;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.IScrollableBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CustomActivityMapsPanel
extends Block
implements IBookmarkListener,
IBlockLayout,
IScrollableBlock,
IHandleAreaListener,
ITimelinePositionListener,
IScaleListener,
ICrossSectionMarkerListener,
ICalipersListener {
    private static final int OVAL_SIZE = 4;
    private static final int OVAL_FILL_SIZE = 5;
    private static final int OVAL_OUTDENT = 2;
    private BaseTimelineContent mContent;
    private ICAMDataProvider mProvider;
    private Set<ICAMJobProvider> mSelectedJobs = new HashSet<ICAMJobProvider>();
    private Set<ICAMJobProvider> mSelectedJobAssociations;
    private List<ConnectionLine> mConnectionLines;
    private Map<ICAMTrackProvider, CustomActivityMapPanel> mTrackToPanelMap = new HashMap<ICAMTrackProvider, CustomActivityMapPanel>();
    private ConnectionLine mHighlightedLine;
    private String mJobFilterRegex = "";
    private boolean mShowAllCAMConnections;

    public CustomActivityMapsPanel(@NonNull BaseTimelineContent content, ICAMDataProvider provider, @NonNull CAMConfig config) {
        this.mContent = content;
        this.mProvider = provider;
        this.setFocusable(true);
        this.setLayout(this);
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        for (ICAMTrackProvider row : this.mProvider.getTracks()) {
            this.add(new CustomActivityMapHandlePanel(content, this, row, 0));
        }
        this.mContent.getChartsPanel().addHandleAreaListener(this);
        this.mContent.getDividerPanel().addPositionListener(this);
        ICaptureDataProvider dataProvider = cdp;
        dataProvider.getScales().addListener((IScaleListener)this);
        dataProvider.getCrossSectionMarker().addListener(this);
        dataProvider.getCalipers().addListener(this);
        this.mContent.addBookmarkListener(this);
        this.updateJobInfo();
        this.setShowAllCAMConnections(config.showAllCAMConnections());
    }

    @Override
    public final void bookmarkChanged() {
        this.repaint();
    }

    @Override
    public final void calipersChanged(Calipers calipers) {
        this.repaint();
    }

    @Override
    public final void crossSectionMarkerChanged(CrossSectionMarker csm) {
        this.repaint();
    }

    public final ICAMDataProvider getCAMDataProvider() {
        return this.mProvider;
    }

    public final BaseTimelineContent getContent() {
        return this.mContent;
    }

    @Override
    public final int getHorizontalIncrement() {
        return 1;
    }

    public final ICAMJobProvider getJobAt(Point where) {
        Block block = this.findBlockAt(where, true);
        if (block instanceof CustomActivityMapPanel) {
            CustomActivityMapPanel camPanel = (CustomActivityMapPanel)block;
            return camPanel.getJobAt(camPanel.fromRootX(this.toRootX(where.x)));
        }
        return null;
    }

    public final String getJobFilter() {
        return this.mJobFilterRegex;
    }

    public final Pattern getJobFilterPattern() {
        if (this.mJobFilterRegex.trim().isEmpty()) {
            return null;
        }
        String regex = TextFilter.enableCaseInsensitivityIfNoDirectivesPresent(this.mJobFilterRegex);
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException exception) {
            return null;
        }
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        int width = 0;
        int height = 0;
        int i = this.getChildCount();
        while (--i >= 0) {
            Point size = this.getChild(i).getMinimumSize(widthHint, -1);
            if (width < size.x) {
                width = size.x;
            }
            height += size.y;
        }
        return new Point(width, height);
    }

    public final long getPosition() {
        return this.mContent.getDividerPanel().getPosition();
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        int width = 0;
        int height = 0;
        int i = this.getChildCount();
        while (--i >= 0) {
            Point size = this.getChild(i).getPreferredSize(widthHint, -1);
            if (width < size.x) {
                width = size.x;
            }
            height += size.y;
        }
        return new Point(width, height);
    }

    public final Set<ICAMJobProvider> getSelectedJobAssociations() {
        return this.mSelectedJobAssociations;
    }

    public final Set<ICAMJobProvider> getSelectedJobs() {
        return this.mSelectedJobs;
    }

    public final Map<ICAMTrackProvider, CustomActivityMapPanel> getTrackToPanelMap() {
        return this.mTrackToPanelMap;
    }

    @Override
    public final int getVerticalIncrement() {
        return HandlePanel.ROW_HEIGHT;
    }

    @Override
    public final void handleAreaWidthChanged() {
        this.layoutAll();
    }

    @Override
    public final void layout(Block target) {
        Rectangle bounds = this.getLocalBounds();
        int count = this.getChildCount();
        int y = bounds.y;
        int i = 0;
        while (i < count) {
            Block child = this.getChild(i);
            int height = child.getPreferredSize((int)bounds.width, (int)-1).y;
            child.setBounds(bounds.x, y, bounds.width, height);
            y += height;
            ++i;
        }
    }

    public final void scaleChanged(Scales scales) {
        this.repaint();
    }

    public final void setJobFilter(String regex) {
        if (!this.mJobFilterRegex.equals(regex)) {
            this.mJobFilterRegex = regex;
            this.repaint();
        }
    }

    public final boolean showAllCAMConnections() {
        return this.mShowAllCAMConnections;
    }

    public final void setShowAllCAMConnections(boolean show) {
        if (show != this.mShowAllCAMConnections) {
            this.mShowAllCAMConnections = show;
            this.updateJobInfo();
            this.repaint();
        }
    }

    public final void setSelectedJobs(ICAMJobProvider[] jobs, boolean toggle) {
        @NonNull List<ICAMJobProvider> jobsAsList = Arrays.asList(jobs);
        if (toggle) {
            if (jobs.length > 0) {
                ICAMJobProvider[] iCAMJobProviderArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    ICAMJobProvider job = iCAMJobProviderArray[n2];
                    if (job != null) {
                        if (this.mSelectedJobs.contains(job)) {
                            this.mSelectedJobs.remove(job);
                        } else {
                            this.mSelectedJobs.add(job);
                        }
                    }
                    ++n2;
                }
                this.updateJobInfo();
                this.repaint();
            }
        } else if (jobs.length == 0) {
            if (!this.mSelectedJobs.isEmpty()) {
                this.mSelectedJobs.clear();
                this.updateJobInfo();
                this.repaint();
            }
        } else {
            boolean selectionsContainsExactlyThoseJobsAlready;
            boolean bl = selectionsContainsExactlyThoseJobsAlready = this.mSelectedJobs.size() == jobs.length && this.mSelectedJobs.containsAll(jobsAsList);
            if (!selectionsContainsExactlyThoseJobsAlready) {
                this.mSelectedJobs = jobsAsList.stream().filter(j -> j != null).collect(Collectors.toSet());
                this.updateJobInfo();
                this.repaint();
            }
        }
    }

    @Override
    public void timelinePositionChanged() {
        this.repaint();
    }

    public final long translateFromSlot(long slot) {
        return (long)this.mContent.getHandleAreaWidth() + slot * 6L - this.getPosition();
    }

    public final String updateForMouseOverConnectionLines(String tooltip, Point where) {
        ConnectionLine newLine = null;
        for (ConnectionLine line : this.mConnectionLines) {
            if (!line.isValid() || !line.isInHitArea(where.x, where.y)) continue;
            newLine = line;
            break;
        }
        if (this.mHighlightedLine != newLine) {
            this.mHighlightedLine = newLine;
            this.repaint();
        }
        if (this.mHighlightedLine != null) {
            TimeUnit timeUnit = this.mContent.getCaptureDataProvider().getTimeUnit();
            String time = String.format(CustomActivityMapMessages.LINK_DURATION, timeUnit.formatInBaseSymbolUnits(Math.abs(this.mHighlightedLine.getDestination().getStartTime() - this.mHighlightedLine.getSource().getStopTime())));
            tooltip = tooltip == null ? time : time + "\n\n" + (String)tooltip;
        }
        return tooltip;
    }

    public final void updateJobInfo() {
        this.mConnectionLines = new ArrayList<ConnectionLine>();
        HashSet<ConnectionLine> lines = new HashSet<ConnectionLine>();
        if (this.mSelectedJobs.isEmpty()) {
            this.mSelectedJobAssociations = null;
            if (this.showAllCAMConnections()) {
                for (ICAMTrackProvider track : this.mProvider.getTracks()) {
                    this.addTrackDependencies(track, lines);
                }
            }
        } else {
            this.mSelectedJobAssociations = new HashSet<ICAMJobProvider>();
            Iterator<ICAMJobProvider> iterator = this.mSelectedJobs.iterator();
            while (iterator.hasNext()) {
                ICAMJobProvider one;
                ICAMJobProvider root = one = iterator.next();
                ICAMJobProvider primary = one.getPrimaryDependency();
                while (primary != null) {
                    if (!this.addConnectionLine(ConnectionLineType.PRIMARY, primary, root, lines)) break;
                    root = primary;
                    this.mSelectedJobAssociations.add(primary);
                    primary = primary.getPrimaryDependency();
                }
                this.addNonPrimaryDependencies(one, root.getStartTime(), lines);
                this.addConnectionLine(ConnectionLineType.CHILD, one, one.getPrimaryDependent(), lines);
                for (ICAMJobProvider dependent : one.getDependents()) {
                    this.addConnectionLine(ConnectionLineType.CHILD, one, dependent, lines);
                }
            }
            this.mSelectedJobAssociations.removeAll(this.mSelectedJobs);
        }
    }

    @Override
    protected final boolean mouseScrolled(Point where, int stateMask, int amount, boolean vertical) {
        if (vertical) {
            return false;
        }
        DividerPanel dividerPanel = this.mContent.getDividerPanel();
        dividerPanel.setPosition(dividerPanel.getPosition() - (long)amount * dividerPanel.getScrollBar().getIncrement());
        return true;
    }

    @Override
    protected final void paintSelfOver(GC gc) {
        super.paintSelfOver(gc);
        if (!this.mSelectedJobs.isEmpty() || this.showAllCAMConnections()) {
            Rectangle bounds = this.getLocalBounds();
            int handleAreaWidth = this.mContent.getHandleAreaWidth();
            bounds.x += handleAreaWidth;
            bounds.width -= handleAreaWidth;
            Rectangle clipping = gc.getClipping();
            clipping.intersect(bounds);
            if (!clipping.isEmpty()) {
                gc.setClipping(new Rectangle(clipping.x, clipping.y, clipping.width, clipping.height));
                this.routeConnectionLines();
                this.drawConnectionLines(gc);
            }
        }
    }

    private final boolean addConnectionLine(@NonNull ConnectionLineType type, ICAMJobProvider src, ICAMJobProvider dst, Set<ConnectionLine> lines) {
        ConnectionLine line;
        if (src != null && dst != null && lines.add(line = new ConnectionLine(type, src, dst))) {
            this.mConnectionLines.add(line);
            return true;
        }
        return false;
    }

    private final void addNonPrimaryDependencies(ICAMJobProvider job, long earliest, Set<ConnectionLine> lines) {
        for (ICAMJobProvider one : job.getDependencies()) {
            if (!this.addConnectionLine(ConnectionLineType.STANDARD, one, job, lines) || one.getStopTime() < earliest) continue;
            this.mSelectedJobAssociations.add(one);
            this.addNonPrimaryDependencies(one, earliest, lines);
        }
    }

    private final void addTrackDependencies(ICAMTrackProvider track, Set<ConnectionLine> lines) {
        for (ICAMJobProvider one : track.getAllJobs()) {
            this.addConnectionLine(ConnectionLineType.STANDARD, one.getPrimaryDependency(), one, lines);
            for (ICAMJobProvider dependency : one.getDependencies()) {
                this.addConnectionLine(ConnectionLineType.STANDARD, dependency, one, lines);
            }
            this.addConnectionLine(ConnectionLineType.STANDARD, one, one.getPrimaryDependent(), lines);
            for (ICAMJobProvider dependent : one.getDependents()) {
                this.addConnectionLine(ConnectionLineType.STANDARD, one, dependent, lines);
            }
        }
        for (ICAMTrackProvider child : track.getChildren()) {
            this.addTrackDependencies(child, lines);
        }
    }

    private final void drawLine(GC gc, StreamlineTheme theme, ConnectionLine line) {
        Color color = this.mHighlightedLine == line ? Colors.getRed() : line.getType().getColor(theme);
        long sx = line.getStartX();
        int sy = line.getStartY();
        long dx = line.getEndX();
        int dy = line.getEndY();
        gc.setForeground(color);
        gc.drawLine((int)sx, sy, (int)dx, dy);
        gc.setBackground(Colors.create(line.getSource().getColor()));
        gc.fillOval((int)(sx - 2L), sy - 2, 5, 5);
        gc.drawOval((int)(sx - 2L), sy - 2, 4, 4);
        gc.setBackground(color);
        gc.fillOval((int)(dx - 2L), dy - 2, 5, 5);
    }

    private final void drawConnectionLines(GC gc) {
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        int savedAA = gc.getAntialias();
        gc.setAntialias(1);
        for (ConnectionLine line : this.mConnectionLines) {
            if (!line.isValid() || this.mHighlightedLine == line) continue;
            this.drawLine(gc, theme, line);
        }
        if (this.mHighlightedLine != null && this.mHighlightedLine.isValid()) {
            this.drawLine(gc, theme, this.mHighlightedLine);
        }
        gc.setAntialias(savedAA);
    }

    private final void routeConnectionLines() {
        ICaptureDataProvider cdp = this.mContent.getCaptureDataProvider();
        @NonNull ZoomLevel zoomLevel = cdp.getScales().getZoomLevel();
        for (ConnectionLine line : this.mConnectionLines) {
            line.reset();
        }
        Collections.sort(this.mConnectionLines);
        boolean limitConnections = this.mConnectionLines.size() > 1000;
        int xIndent = 3;
        int halfHeight = HandlePanel.ROW_HEIGHT / 2 - 1;
        int thirdHeight = HandlePanel.ROW_HEIGHT / 4;
        int binCount = cdp.getBinCount();
        for (ConnectionLine line : this.mConnectionLines) {
            ICAMJobProvider dstJob;
            CustomActivityMapPanel dstRow;
            @NonNull ICAMJobProvider srcJob = line.getSource();
            @Nullable CustomActivityMapPanel srcRow = this.mTrackToPanelMap.get(srcJob.getTrack());
            if (srcRow == null || (dstRow = this.mTrackToPanelMap.get((dstJob = line.getDestination()).getTrack())) == null) continue;
            long sx = (long)xIndent + this.translateFromSlot(Math.max(Math.min(Position.scale((long)srcJob.getStopTime(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel), (long)binCount), 0L));
            int sy = this.fromRootY(srcRow.toRootY(srcRow.getY())) + halfHeight;
            long dx = (long)xIndent + this.translateFromSlot(Math.max(Math.min(Position.scale((long)dstJob.getStartTime(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel), (long)binCount), 0L));
            int dy = this.fromRootY(dstRow.toRootY(dstRow.getY())) + halfHeight;
            if (!limitConnections || line.getType() == ConnectionLineType.PRIMARY || limitConnections && sx != dx) {
                if (dy > sy) {
                    sy += thirdHeight;
                    dy -= thirdHeight;
                } else if (dy < sy) {
                    sy -= thirdHeight;
                    dy += thirdHeight;
                }
            }
            if (sy == dy && Math.abs(dx - sx) <= 6L) continue;
            line.setCoordinates(sx, sy, dx, dy);
        }
    }

    public int getPreferredHandlePanelsWidth() {
        return Arrays.stream(this.getChildren()).filter(block -> block instanceof CustomActivityMapHandlePanel).map(block -> (CustomActivityMapHandlePanel)block).mapToInt(handlePanel -> handlePanel.getPreferredWidth()).max().orElse(0);
    }

    protected void setExpansionStateForAll(boolean expandedState) {
        Arrays.stream(this.getChildren()).filter(b -> b instanceof CustomActivityMapHandlePanel).map(b -> (CustomActivityMapHandlePanel)b).forEach(handlePanel -> handlePanel.setOpen(expandedState, false));
        this.getRoot().layoutAll();
    }

    private @NonNull Stream<CustomActivityMapHandlePanel> getFlattenedHandlePanels() {
        return this.getFlattenedChildren().filter(b -> b instanceof CustomActivityMapHandlePanel).map(b -> (CustomActivityMapHandlePanel)b);
    }

    public void showHandlePanelsContextMenu(Point locationInDisplayCoords) {
        Menu menu = new Menu((Control)this.getOwner());
        boolean isCollapseAllEnabled = this.getFlattenedHandlePanels().filter(h -> h.isOpen() && h.getRowChildren().size() > 0).findAny().isPresent();
        MenuItem collapseAllItem = new MenuItem(menu, 0);
        collapseAllItem.setText(DocumentsMessages.COLLAPSE_ALL);
        collapseAllItem.setEnabled(isCollapseAllEnabled);
        collapseAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomActivityMapsPanel.this.setExpansionStateForAll(false);
            }
        });
        boolean isExpandAllEnabled = this.getFlattenedHandlePanels().filter(h -> !h.isOpen() && h.getChildCount() > 0).findAny().isPresent();
        MenuItem expandAllItem = new MenuItem(menu, 0);
        expandAllItem.setText(DocumentsMessages.EXPAND_ALL);
        expandAllItem.setEnabled(isExpandAllEnabled);
        expandAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomActivityMapsPanel.this.setExpansionStateForAll(true);
            }
        });
        this.showContextMenuInDisplayCoords(menu, locationInDisplayCoords);
    }
}

