/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.analysis.model.cam.ICAMJobProvider;
import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.GraphBlock;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapHandlePanel;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapMessages;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapsPanel;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import com.arm.utils.NullChecking;
import com.arm.utils.Platform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CustomActivityMapPanel
extends GraphBlock {
    private static final long HUNDRED_MS_IN_NANOS = 100000000L;
    private static final TimeUnit MILLISECONDS_TIME_UNIT = new TimeUnit(1000000, "ms", "millisecond");
    private static final int MORE_THRESHOLD = 5;
    private CustomActivityMapHandlePanel mHandlePanel;
    private List<ICAMJobProvider>[] mData;
    private long mDataStart;
    private @Nullable ZoomLevel mZoomLevel;
    private Color mBorderColor;
    private Color mSelectedBorderColor;
    private Color mAggregateColor;
    private Color mFilteredOutColor;

    private static final boolean isDataEqual(List<ICAMJobProvider> left, List<ICAMJobProvider> right) {
        return left == null ? right == null : left.equals(right);
    }

    public CustomActivityMapPanel(CustomActivityMapHandlePanel handlePanel) {
        super(handlePanel.getContent());
        this.mHandlePanel = handlePanel;
    }

    public final ICAMJobProvider getJobAt(int x) {
        List<ICAMJobProvider> list;
        long index;
        if (this.mData != null && (index = this.translateToSlot(x) - this.mDataStart) >= 0L && index < (long)this.mData.length && (list = this.mData[(int)index]) != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public final boolean handleMouseUpWithoutDrag(Point where, int button, int stateMask, int count) {
        CustomActivityMapsPanel camsPanel = this.mHandlePanel.getCAMsPanel();
        ICAMJobProvider[] jobs = new ICAMJobProvider[]{this.getJobAt(where.x)};
        boolean toggle = (stateMask & SWT.MOD1) == SWT.MOD1;
        camsPanel.setSelectedJobs(jobs, toggle);
        return toggle || jobs[0] != null;
    }

    @Override
    protected void mouseSlotWasUpdated() {
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        this.updateThemeColors();
        this.drawBackgroundWithVerticalGroupingMarkers(gc, false);
        this.drawBars(gc);
        this.drawCaliperEnds(gc);
        this.drawBookmarks(gc);
        this.drawCrossSectionMarker(gc);
        this.updatePositionReadout();
    }

    @Override
    protected final void updateMouseSlot(Point where) {
        List<ICAMJobProvider> list;
        super.updateMouseSlot(where);
        String text = null;
        long lastMouseSlot = this.getLastMouseSlot();
        if (lastMouseSlot != -1000L && this.mData != null && lastMouseSlot >= this.mDataStart && lastMouseSlot < this.mDataStart + (long)this.mData.length && (list = this.mData[(int)(lastMouseSlot - this.mDataStart)]) != null) {
            StringBuilder buffer = new StringBuilder();
            int total = list.size();
            int count = total > 6 ? 5 : total;
            TimeUnit timeUnit = this.mHandlePanel.getContent().getCaptureDataProvider().getTimeUnit();
            int i = 0;
            while (i < count) {
                ICAMJobProvider job = list.get(i);
                long startTime = job.getStartTime();
                long duration = job.getStopTime() - startTime;
                buffer.append(String.format(CustomActivityMapMessages.INITIATED, job.getDetailText(), timeUnit.formatInBaseSymbolUnits(startTime)));
                if (duration > 0L) {
                    TimeUnit durationTimeUnit = MILLISECONDS_TIME_UNIT;
                    if (duration >= 100000000L) {
                        durationTimeUnit = timeUnit;
                    }
                    buffer.append(String.format(CustomActivityMapMessages.DURATION, durationTimeUnit.formatInBase((double)duration, 1000.0, TimeUnit.Style.SYMBOL_UNIT, false)));
                }
                if (i != count - 1) {
                    buffer.append("\n\n");
                }
                ++i;
            }
            if (total > 11) {
                buffer.append(String.format(CustomActivityMapMessages.MORE, total - 5));
            }
            text = buffer.toString();
        }
        CustomActivityMapsPanel camsPanel = this.mHandlePanel.getCAMsPanel();
        this.setToolTip(camsPanel.updateForMouseOverConnectionLines(text, camsPanel.fromRoot(this.toRoot(where.x, where.y))));
    }

    @Override
    protected final void updateThemeColors() {
        super.updateThemeColors();
        this.mBorderColor = Colors.lighten(this.getThemeBorder(), 10);
        this.mSelectedBorderColor = Colors.create(255, 128, 0);
        switch (StreamlinePreferences.getTheme()) {
            default: {
                this.mAggregateColor = Colors.create(44, 64, 84);
                this.mFilteredOutColor = Colors.create(84, 64, 44);
                break;
            }
            case LIGHT: {
                this.mAggregateColor = Colors.create(144, 164, 184);
                this.mFilteredOutColor = Colors.create(184, 164, 144);
            }
        }
    }

    private final void drawBars(GC gc) {
        ICaptureDataProvider cdp = this.mHandlePanel.getContent().getCaptureDataProvider();
        Calipers calipers = cdp.getCalipers();
        long calipersLeft = calipers.getLeft();
        long calipersRight = calipers.getRight();
        Rectangle bounds = this.getLocalBounds();
        int y = bounds.y + 2;
        int height = bounds.height - 5;
        gc.setFont(Fonts.getSmall());
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        StreamlineTheme theme = StreamlinePreferences.getTheme();
        this.prepareData(this.getFirstVisibleSlot(), this.getLastVisibleSlot(), cdp.getScales().getZoomLevel());
        long slot = this.mDataStart;
        int x = (int)this.translateFromSlot(slot);
        int left = bounds.x;
        String title = null;
        Color titleBackgroundColor = null;
        CustomActivityMapsPanel camsPanel = this.mHandlePanel.getCAMsPanel();
        Set<ICAMJobProvider> selectedJobs = camsPanel.getSelectedJobs();
        int adjustment = Platform.isLinux() ? 1 : 0;
        int i = 0;
        while (i < this.mData.length) {
            int count;
            List<ICAMJobProvider> list = this.mData[i];
            if (list != null && (count = list.size()) > 0) {
                Color color = null;
                ICAMJobProvider firstJob = list.get(0);
                boolean drawTitle = this.shouldJobBarBeDrawnEnabled(list);
                boolean drawSelectionBorder = selectedJobs.contains(firstJob);
                color = count == 1 ? (drawTitle ? Colors.create(firstJob.getColor()) : this.mFilteredOutColor) : this.mAggregateColor;
                if (slot < calipersLeft || slot >= calipersRight) {
                    color = theme.desaturate(color);
                }
                gc.setBackground(color);
                gc.fillRectangle(x + 1, y + 1, 6, height - 2);
                Color borderColor = drawSelectionBorder ? this.mSelectedBorderColor : (drawTitle && !selectedJobs.isEmpty() ? Colors.getGray() : this.mBorderColor);
                gc.setForeground(borderColor);
                int right = x + 6;
                int bottom = y + height - 1;
                gc.drawLine(x, y, right + adjustment, y);
                gc.drawLine(x, bottom, right + adjustment, bottom);
                if (i == 0 || !CustomActivityMapPanel.isDataEqual(this.mData[i - 1], this.mData[i])) {
                    List<ICAMJobProvider> prev;
                    boolean restoreBorder = false;
                    if (i > 0 && !drawSelectionBorder && !selectedJobs.isEmpty() && (prev = this.mData[i - 1]) != null && !prev.isEmpty() && this.shouldJobBarBeDrawnEnabled(prev)) {
                        gc.setForeground(selectedJobs.contains(prev.get(0)) ? this.mSelectedBorderColor : Colors.getGray());
                        restoreBorder = true;
                    }
                    gc.drawLine(x, y, x, bottom);
                    if (restoreBorder) {
                        gc.setForeground(borderColor);
                    }
                    if (drawTitle) {
                        left = x;
                        title = count == 1 ? firstJob.getName() : String.format(CustomActivityMapMessages.ITEMS, list.size());
                        titleBackgroundColor = color;
                    }
                }
                if (i == this.mData.length - 1 || !CustomActivityMapPanel.isDataEqual(this.mData[i], this.mData[i + 1])) {
                    gc.drawLine(right, y, right, bottom);
                    if (title != null) {
                        this.drawTitle(gc, left, right, y, height, titleBackgroundColor, title);
                        title = null;
                    }
                }
            }
            x += 6;
            ++slot;
            ++i;
        }
        if (title != null) {
            this.drawTitle(gc, left, x, y, height, titleBackgroundColor, title);
        }
        gc.setAntialias(savedAA);
    }

    private final void drawTitle(GC gc, int left, int right, int y, int height, Color color, String title) {
        Rectangle bounds = this.getLocalBounds();
        if (left < bounds.x) {
            left = bounds.x;
        }
        if (right > bounds.x + bounds.width) {
            right = bounds.x + bounds.width;
        }
        left += 2;
        right -= 2;
        Color savedFg = gc.getForeground();
        gc.setForeground(Colors.isDark(color) ? Colors.getWhite() : Colors.getBlack());
        int lineSepIndex = title.indexOf(10);
        if (lineSepIndex > 0) {
            title = title.substring(0, lineSepIndex);
        }
        TextDrawing.drawString(gc, title, left, y, right - left, height, 0x1000000, 0x1000000, 131072);
        gc.setForeground(savedFg);
    }

    private final void prepareData(long first, long last, @NonNull ZoomLevel zoomLevel) {
        if (this.mData == null || first != this.mDataStart || last != this.mDataStart + (long)this.mData.length - 1L || !zoomLevel.equals((Object)this.mZoomLevel)) {
            this.mDataStart = first;
            this.mData = new List[(int)(1L + last - first)];
            this.mZoomLevel = zoomLevel;
            @NonNull Stream<Object> allJobs = !this.mHandlePanel.isOpen() ? this.mHandlePanel.getRowChildrenFlattened().map(row -> row.getJobs((int)first, (int)last)).flatMap(i -> i.stream()) : this.mHandlePanel.getRow().getJobs((int)first, (int)last).stream();
            allJobs.forEach(nullableJobProvider -> {
                @NonNull ICAMJobProvider jobProvider = (ICAMJobProvider)NullChecking.neverNull((Object)nullableJobProvider);
                long jobStartSlot = Position.scale((long)jobProvider.getStartTime(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
                long start = jobStartSlot < first ? first : jobStartSlot;
                long jobStopSlot = Position.scale((long)jobProvider.getStopTime(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel);
                long stop = jobStopSlot > last ? last : jobStopSlot;
                long i = start;
                while (i <= stop) {
                    int index = (int)(i - first);
                    List<ICAMJobProvider> list = this.mData[index];
                    if (list == null) {
                        this.mData[index] = list = new ArrayList<ICAMJobProvider>();
                    }
                    list.add(jobProvider);
                    ++i;
                }
            });
        }
    }

    private final boolean shouldJobBarBeDrawnEnabled(List<ICAMJobProvider> jobList) {
        CustomActivityMapsPanel camsPanel = this.mHandlePanel.getCAMsPanel();
        Pattern pattern = camsPanel.getJobFilterPattern();
        Set<ICAMJobProvider> selectedJobs = camsPanel.getSelectedJobs();
        if (!selectedJobs.isEmpty()) {
            HashSet<ICAMJobProvider> set = new HashSet<ICAMJobProvider>(jobList);
            for (ICAMJobProvider one : selectedJobs) {
                if (!set.contains(one)) continue;
                if (pattern != null && !pattern.matcher(one.getName()).find()) break;
                return true;
            }
            for (ICAMJobProvider job : camsPanel.getSelectedJobAssociations()) {
                if (!set.contains(job) || pattern != null && !pattern.matcher(job.getName()).find()) continue;
                return true;
            }
            return false;
        }
        if (pattern == null) {
            return true;
        }
        for (ICAMJobProvider job : jobList) {
            if (!pattern.matcher(job.getName()).find()) continue;
            return true;
        }
        return false;
    }

    public void clearDataCache() {
        this.mData = null;
    }
}

