/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineContextMenu;
import com.arm.streamline.editortabs.timeline.common.charts.ChartDragScrollTracker;
import com.arm.streamline.editortabs.timeline.common.charts.IChartDragScrollable;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.utils.collections.ITimeStampedData;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GraphBlock
extends Block
implements IChartDragScrollable {
    protected static final Color DARK_BACKGROUND = Colors.create(26, 26, 26);
    protected static final int NO_MOUSE_OVER = -1000;
    private BaseTimelineContent mContent;
    private Color mThemeBackground;
    private Color mThemeBorder;
    private Color mThemeVerticalMarker;
    private Color mThemeCrossSectionColor;
    private int mMouseX = -1000;
    private int mMouseY;
    private long mLastMouseSlot = -1000L;
    private DragTracker mTracker;
    private boolean mUpdatingMouseSlot;

    protected GraphBlock(BaseTimelineContent content) {
        this.mContent = content;
    }

    @Override
    public final BaseTimelineContent getBaseTimelineContent() {
        return this.mContent;
    }

    public final ICaptureDataProvider getCaptureDataProvider() {
        return this.mContent.getCaptureDataProvider();
    }

    public final long getFirstVisibleSlot() {
        long pos = this.getPosition();
        long result = pos / 6L;
        if (pos % 6L == 0L) {
            --result;
        }
        return result < 0L ? 0L : result;
    }

    public final long getLastMouseSlot() {
        return this.mLastMouseSlot;
    }

    public final long getLastVisibleSlot() {
        return (this.getPosition() + (long)this.getLocalBounds().width + 6L - 1L) / 6L;
    }

    public final int getMouseX() {
        return this.mMouseX;
    }

    public final int getMouseY() {
        return this.mMouseY;
    }

    public final long getPosition() {
        return this.mContent.getDividerPanel().getPosition();
    }

    public final Color getThemeBackground() {
        return this.mThemeBackground;
    }

    public final Color getThemeBorder() {
        return this.mThemeBorder;
    }

    public final Color getThemeCrossSectionColor() {
        return this.mThemeCrossSectionColor;
    }

    public final Color getThemeVerticalMarker() {
        return this.mThemeVerticalMarker;
    }

    public final DragTracker getTracker() {
        return this.mTracker;
    }

    @Override
    public boolean handleMouseUpWithoutDrag(Point where, int button, int stateMask, int count) {
        return false;
    }

    public final void setTracker(DragTracker tracker) {
        this.mTracker = tracker;
    }

    public final long translateFromSlot(long slot) {
        return slot * 6L - this.getPosition();
    }

    @Override
    public final long translateToSlot(long x) {
        long slot = (this.getPosition() + x) / 6L;
        return slot >= 0L ? slot : -1000L;
    }

    protected final void drawBackgroundWithVerticalGroupingMarkers(GC gc, boolean drawVerticalMarkers) {
        Rectangle bounds = this.getLocalBounds();
        gc.setBackground(this.mThemeBackground);
        gc.fillRectangle(bounds);
        gc.setForeground(this.mThemeBorder);
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        int top = bounds.y;
        int bottom = top + bounds.height - 1;
        gc.drawLine(bounds.x, bottom, bounds.x + bounds.width - 1, bottom);
        if (drawVerticalMarkers) {
            this.drawVerticalMarkers(gc);
        }
        gc.setAntialias(savedAA);
    }

    protected final void drawVerticalMarkers(GC gc) {
        Rectangle bounds = this.getLocalBounds();
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        int top = bounds.y;
        int bottom = top + bounds.height - 1;
        gc.setAntialias(0);
        long first = this.getFirstVisibleSlot();
        long last = this.getLastVisibleSlot();
        first -= first % 10L;
        gc.setForeground(this.mThemeVerticalMarker);
        long i = first;
        while (i <= last) {
            int x = (int)this.translateFromSlot(i);
            gc.drawLine(x, top, x, bottom);
            i += 10L;
        }
        gc.setAntialias(savedAA);
    }

    protected final void drawBookmarks(GC gc) {
        ICaptureDataProvider cdp;
        List<Bookmark> bookmarks;
        int count;
        if (this.mContent.showBookmarks() && (count = (bookmarks = (cdp = this.getCaptureDataProvider()).getBookmarks()).size()) > 0) {
            Color edgeColor;
            Color middleColor;
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            Rectangle bounds = this.getLocalBounds();
            int right = bounds.x + bounds.width;
            int top = bounds.y;
            int bottom = bounds.y + bounds.height - 1;
            ZoomLevel zoomLevel = cdp.getScales().getZoomLevel();
            int pos = ITimeStampedData.binarySearch(bookmarks, (long)Position.scale((long)this.translateToSlot(0L), (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
            if (pos < 0) {
                pos = -pos - 1;
            }
            long last = -1L;
            if (StreamlinePreferences.getTheme() == StreamlineTheme.DARK) {
                middleColor = Colors.getWhite();
                edgeColor = Colors.getBlack();
            } else {
                middleColor = Colors.getBlack();
                edgeColor = Colors.getWhite();
            }
            gc.setAlpha(102);
            while (pos < count) {
                Bookmark bookmark;
                long bi;
                if ((bi = Position.scale((long)(bookmark = bookmarks.get(pos++)).getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)zoomLevel)) == last) continue;
                last = bi;
                long x = this.translateFromSlot(bi);
                if (x >= (long)right) break;
                if (x < (long)bounds.x) continue;
                int xx = (int)x + 3;
                gc.setForeground(middleColor);
                gc.drawLine(xx, top, xx, bottom);
                gc.setForeground(edgeColor);
                gc.drawLine(xx - 1, top, xx - 1, bottom);
                gc.drawLine(xx + 1, top, xx + 1, bottom);
            }
            gc.setAlpha(255);
            gc.setAntialias(savedAA);
        }
    }

    protected final void drawCaliperEnds(GC gc) {
        long left;
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        gc.setAlpha(102);
        gc.setForeground(StreamlinePreferences.getTheme() == StreamlineTheme.DARK ? Colors.getWhite() : Colors.getBlack());
        Rectangle bounds = this.getLocalBounds();
        int top = bounds.y;
        int bottom = bounds.y + bounds.height - 1;
        Calipers calipers = this.getCaptureDataProvider().getCalipers();
        long x = this.translateFromSlot(calipers.getRight());
        if (x >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
            gc.drawLine((int)x, top, (int)x, bottom);
        }
        if ((left = calipers.getLeft()) > 0L && (x = this.translateFromSlot(left)) >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
            gc.drawLine((int)x, top, (int)x, bottom);
        }
        gc.setAlpha(255);
        gc.setAntialias(savedAA);
    }

    protected final void drawCrossSectionMarker(GC gc) {
        CrossSectionMarker csm = this.getCaptureDataProvider().getCrossSectionMarker();
        long csmLeft = csm.getLeft();
        if (csmLeft >= 0L) {
            long adjustedRight;
            Rectangle bounds = this.getLocalBounds();
            long csmRight = csm.getRight();
            long left = this.translateFromSlot(csmLeft);
            boolean leftExact = csm.isLeftExact();
            long right = this.translateFromSlot(csmRight);
            boolean isRange = csm.isRange();
            boolean rightExact = csm.isRightExact();
            if (csmLeft == csmRight) {
                right = left + 6L;
            } else if (!rightExact) {
                right += 6L;
            }
            int savedAA = gc.getAntialias();
            gc.setAntialias(0);
            gc.setForeground(this.mThemeCrossSectionColor);
            gc.setBackground(this.mThemeCrossSectionColor);
            gc.setAlpha(50);
            long adjustedLeft = left;
            if (adjustedLeft < (long)bounds.x) {
                adjustedLeft = bounds.x;
            }
            if ((adjustedRight = right) > (long)(bounds.x + bounds.width)) {
                adjustedRight = bounds.x + bounds.width;
            }
            if (adjustedLeft < (long)(bounds.x + bounds.width)) {
                Rectangle fillBounds = new Rectangle((int)adjustedLeft, bounds.y, (int)(adjustedRight + 1L - adjustedLeft), bounds.height);
                fillBounds.intersect(bounds);
                if (!fillBounds.isEmpty()) {
                    gc.fillRectangle(fillBounds);
                }
            }
            if (isRange) {
                int imgWidth;
                Image img;
                gc.setAlpha(128);
                if (leftExact) {
                    if (left >= (long)bounds.x && left < (long)(bounds.x + bounds.width)) {
                        gc.drawLine((int)left, bounds.y, (int)left, bounds.height);
                    }
                } else {
                    img = StreamlinePlugin.getColorizedImage("CrossSectionFractionalFillLeft.png", this.mThemeCrossSectionColor.getRGB());
                    imgWidth = img.getBounds().width;
                    if (left + (long)imgWidth >= (long)bounds.x && left < (long)(bounds.x + bounds.width)) {
                        this.drawFuzzyLine(gc, img, (int)left);
                    }
                }
                if (rightExact) {
                    if (right >= (long)bounds.x && right < (long)(bounds.x + bounds.width)) {
                        gc.drawLine((int)right, bounds.y, (int)right, bounds.height);
                    }
                } else {
                    img = StreamlinePlugin.getColorizedImage("CrossSectionFractionalFillRight.png", this.mThemeCrossSectionColor.getRGB());
                    imgWidth = img.getBounds().width;
                    long pos = right + 1L - (long)imgWidth;
                    if (pos + (long)imgWidth >= (long)bounds.x && pos < (long)(bounds.x + bounds.width)) {
                        this.drawFuzzyLine(gc, img, (int)pos);
                    }
                }
            } else {
                gc.setAlpha(128);
                long x = left + 3L;
                if (x >= (long)bounds.x && x < (long)(bounds.x + bounds.width)) {
                    int xx = (int)x;
                    gc.drawLine(xx, bounds.y, xx, bounds.height);
                    gc.setForeground(Colors.getBlack());
                    gc.setAlpha(64);
                    gc.drawLine(xx - 1, bounds.y, xx - 1, bounds.height);
                    gc.drawLine(xx + 1, bounds.y, xx + 1, bounds.height);
                }
            }
            gc.setAlpha(255);
            gc.setAntialias(savedAA);
        }
    }

    @Override
    protected void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            this.setTracker(new ChartDragScrollTracker(this, where.x, where.y));
        } else if (button == 3) {
            TimelineContextMenu.showContextMenu(this.mContent, this.toDisplay(where.x, where.y));
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.mTracker.mouseDrag(where, stateMask);
        } else {
            this.mContent.setBookmarkPopOver(null);
        }
        this.updateMouseSlot(where);
    }

    @Override
    protected final void mouseEnter(Point where, int stateMask) {
        this.updateMouseSlot(where);
    }

    @Override
    protected final void mouseExit() {
        this.mMouseX = -1000;
        if (this.mLastMouseSlot != -1000L) {
            this.mLastMouseSlot = -1000L;
            this.mouseSlotWasUpdated();
            this.getBaseTimelineContent().clearPositionReadoutIfNeeded();
        }
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.getBaseTimelineContent().setBookmarkPopOver(null);
        this.updateMouseSlot(where);
    }

    protected void mouseSlotWasUpdated() {
        this.repaint();
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
            this.updateMouseSlot(where);
        }
    }

    protected void updateMouseSlot(Point where) {
        this.mMouseX = where.x;
        this.mMouseY = where.y;
        long slot = this.translateToSlot(this.mMouseX);
        if (this.mLastMouseSlot != slot) {
            this.mLastMouseSlot = slot;
            if (!this.mUpdatingMouseSlot) {
                this.mUpdatingMouseSlot = true;
                Task.callOnUIThread(() -> {
                    this.mUpdatingMouseSlot = false;
                    this.mouseSlotWasUpdated();
                    this.mContent.getPositionReadout().update(this.mLastMouseSlot, this.getCaptureDataProvider().getScales().getZoomLevel(), this.getCaptureDataProvider().getTimeUnit());
                });
            }
        }
    }

    protected final void updatePositionReadout() {
        if (this.mMouseX != -1000) {
            this.mLastMouseSlot = this.translateToSlot(this.mMouseX);
            if (this.mLastMouseSlot >= (long)this.getCaptureDataProvider().getLastBinCount()) {
                this.mLastMouseSlot = -1000L;
            }
            if (this.mLastMouseSlot != -1000L) {
                this.mContent.getPositionReadout().update(this.mLastMouseSlot, this.getCaptureDataProvider().getScales().getZoomLevel(), this.getCaptureDataProvider().getTimeUnit());
            }
        }
    }

    protected void updateThemeColors() {
        switch (StreamlinePreferences.getTheme()) {
            default: {
                this.mThemeBackground = DARK_BACKGROUND;
                this.mThemeBorder = Colors.create(71, 71, 71);
                this.mThemeVerticalMarker = Colors.lighten(this.mThemeBackground, 6);
                this.mThemeCrossSectionColor = Colors.getWhite();
                break;
            }
            case LIGHT: {
                this.mThemeBackground = Colors.getWhite();
                this.mThemeBorder = Colors.create(180, 180, 180);
                this.mThemeVerticalMarker = Colors.darken(this.mThemeBackground, 6);
                this.mThemeCrossSectionColor = Colors.create(153, 179, 230);
            }
        }
    }

    private final void drawFuzzyLine(GC gc, Image img, int x) {
        int height = img.getBounds().height;
        Rectangle bounds = this.getLocalBounds();
        int max = bounds.y + bounds.height;
        int y = bounds.y;
        while (y < max) {
            gc.drawImage(img, x, y);
            y += height;
        }
    }
}

