/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline;

import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.IHeatmapExportFormatter;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.utils.NullChecking;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HeatmapExportFormatter
implements IHeatmapExportFormatter {
    @Override
    public @NonNull String formatColumnTitle(@NonNull ITimelineRowProvider provider) throws IOException {
        StringBuilder builder = new StringBuilder(provider.getName());
        @Nullable ITimelineRowProvider next = provider;
        while ((next = next.getParent()) != null) {
            builder.insert(0, next.getName() + "/");
        }
        return builder.toString();
    }

    @Override
    public @NonNull String formatBinValue(int i) throws IOException {
        if (i < 0) {
            switch (i) {
                case -2: {
                    return "I";
                }
                case -1: {
                    return "-";
                }
                case -3: {
                    return "C";
                }
                case -4: {
                    return "IO";
                }
            }
            throw new IOException("Invalid negative value in exporting heatmap item");
        }
        i = Math.min(i, 10000);
        Double val = (double)i / 100.0;
        return (String)NullChecking.neverNull((Object)String.format("%.2f%%", val));
    }

    @Override
    public @NonNull String formatTime(int bin, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
        return timeUnit.formatBin((long)bin, zoomLevel, TimeUnit.Style.NO_UNIT, true);
    }
}

