/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.report;

import com.arm.streamline.cmdline.ReportProcessor;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.report.BaseExportDialog;
import com.arm.streamline.editortabs.report.ReportMessages;
import com.arm.streamline.editortabs.report.TableExport;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.utils.NullChecking;
import com.arm.utils.text.SWTLabelFilter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ExportTableDialog<C extends Column<C>>
extends BaseExportDialog {
    private final @NonNull Outline<C> mOutline;
    private Button mExportAllRowsRadio;
    private Button mExportSelectedRowsRadio;
    private List<@NonNull Row<C>> mSelectedRows;
    Button mExportAllColumnsRadio;
    private Button mExportSelectedColumnsRadio;
    final @NonNull Map<@NonNull Button, @NonNull C> mColumns = new HashMap<Button, C>();
    private boolean mExportAllRows;
    private boolean mExportAllColumns;
    Set<C> mColumnsToExport;
    private Menu contextMenu;

    public static <C extends Column<C>> void show(@NonNull Analysis analysis, @NonNull Outline<C> outline, String leafFileName) {
        String filename = MessageFormat.format(leafFileName, analysis);
        String path = FilePath.getPathForPlatform((String)FilePath.getFullPath((String)ExportTableDialog.getDefaultPath(), (String)filename));
        ExportTableDialog<C> dialog = new ExportTableDialog<C>(path, outline);
        dialog.create();
        if (dialog.open() == 0) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(dialog.getPath())));){
                    ReportProcessor.Format format = ExportTableDialog.getSelectedFormat();
                    ArrayList<@NonNull Object> columns = new ArrayList<Object>();
                    OutlineModel<C> model = outline.getModel();
                    if (dialog.mExportAllColumns) {
                        @NonNull List<@NonNull T> collect = model.getColumns().stream().filter(c -> !c.isHiddenFromExport()).collect(Collectors.toList());
                        columns.addAll(collect);
                    } else {
                        for (Column one : model.getColumns()) {
                            if (one.isHiddenFromExport() || !dialog.mColumnsToExport.contains(one)) continue;
                            columns.add(one);
                        }
                    }
                    ArrayList<@NonNull Row<C>> rows = new ArrayList();
                    if (dialog.mExportAllRows) {
                        rows.addAll(model.getTopLevelRows());
                    } else {
                        rows.addAll(dialog.mSelectedRows);
                    }
                    TableExport.export(out, format == ReportProcessor.Format.TABS, format == ReportProcessor.Format.COMMAS, true, columns, rows);
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                Error.show(exception);
            }
        }
    }

    public ExportTableDialog(String path, @NonNull Outline<C> outline) {
        super(path, ReportMessages.MESSAGE, "com.arm.streamline.export_tables");
        this.mOutline = outline;
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        if (widget == this.mExportAllRowsRadio) {
            this.mExportAllRowsRadio.setSelection(true);
            this.mExportSelectedRowsRadio.setSelection(false);
            this.adjustAcceptance();
        } else if (widget == this.mExportSelectedRowsRadio) {
            this.mExportAllRowsRadio.setSelection(false);
            this.mExportSelectedRowsRadio.setSelection(true);
            this.adjustAcceptance();
        } else if (widget == this.mExportAllColumnsRadio) {
            this.mExportAllColumnsRadio.setSelection(true);
            this.mExportSelectedColumnsRadio.setSelection(false);
            this.adjustAcceptance();
        } else if (widget == this.mExportSelectedColumnsRadio) {
            this.mExportAllColumnsRadio.setSelection(false);
            this.mExportSelectedColumnsRadio.setSelection(true);
            this.adjustAcceptance();
        } else if (this.mColumns.containsKey(widget)) {
            this.adjustAcceptance();
        } else {
            super.widgetSelected(event);
        }
    }

    @Override
    protected void addAdditionalOptions() {
        this.addDivider();
        this.addRowSelectionOptions();
        this.addDivider();
        this.addColumnSelectionOptions();
    }

    @Override
    protected void adjustAcceptance() {
        boolean enabled = this.mExportSelectedColumnsRadio.getSelection();
        for (Button button : this.mColumns.keySet()) {
            button.setEnabled(enabled);
        }
        this.mExportAllRows = this.mExportAllRowsRadio.getSelection();
        this.mExportAllColumns = this.mExportAllColumnsRadio.getSelection();
        if (!this.mExportAllColumns) {
            this.mColumnsToExport = new HashSet<C>();
            for (Button button : this.mColumns.keySet()) {
                if (!button.getSelection()) continue;
                this.mColumnsToExport.add((Column)NullChecking.neverNull((Object)((Column)this.mColumns.get(button))));
            }
        }
        if (this.mExportSelectedColumnsRadio.getSelection()) {
            boolean hasOneSet = false;
            for (Button button : this.mColumns.keySet()) {
                if (!button.getSelection()) continue;
                hasOneSet = true;
                break;
            }
            if (!hasOneSet) {
                this.setErrorMessage(ReportMessages.MUST_SELECT_A_COLUMN);
                this.getButton(0).setEnabled(false);
                return;
            }
        }
        super.adjustAcceptance();
    }

    private void addColumnSelectionOptions() {
        @NonNull OutlineModel<C> model = this.mOutline.getModel();
        @NonNull List<@NonNull C> columns = model.getColumns();
        boolean allVisible = true;
        for (Column column : columns) {
            if (column.isVisible() || column.isHiddenFromUi()) continue;
            allVisible = false;
        }
        this.mExportAllColumnsRadio = this.createRadioButton(this.mContent, ReportMessages.EXPORT_ALL_COLUMNS, ReportMessages.EXPORT_ALL_COLUMNS_TOOLTIP, allVisible);
        this.mExportSelectedColumnsRadio = this.createRadioButton(this.mContent, MessageFormat.format(ReportMessages.EXPORT_ONLY_SELECTED_COLUMNS, this.mSelectedRows.size()), ReportMessages.EXPORT_SELECTED_COLUMNS_TOOLTIP, !allVisible);
        Group group = new Group(this.mContent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData firstData = new GridData(4, 4, true, false);
        firstData.horizontalSpan = 3;
        firstData.verticalSpan = 1;
        firstData.heightHint = 200;
        group.setLayoutData((Object)firstData);
        ScrolledComposite firstScroll = new ScrolledComposite((Composite)group, 768);
        firstScroll.setLayout((Layout)new GridLayout(1, false));
        firstScroll.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite firstContent = new Composite((Composite)firstScroll, 0);
        firstContent.setLayout((Layout)new GridLayout(1, false));
        firstContent.setLayoutData((Object)new GridData(4, 4, true, true));
        int count = columns.size();
        int half = count / 2 + (count & 1);
        int i = 0;
        while (i < half) {
            Column column = (Column)columns.get(i);
            this.addColumn(firstContent, column);
            if (i + half < count) {
                column = (Column)columns.get(i + half);
                this.addColumn(firstContent, column);
            }
            ++i;
        }
        firstScroll.setContent((Control)firstContent);
        firstScroll.setExpandHorizontal(true);
        firstScroll.setExpandVertical(true);
        firstScroll.setMinSize(firstContent.computeSize(-1, -1));
        this.contextMenu = new Menu((Control)firstContent);
        MenuItem menuItemSelect = new MenuItem(this.contextMenu, 0);
        menuItemSelect.setText("&Select All");
        menuItemSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExportTableDialog.this.mExportAllColumnsRadio.getSelection()) {
                    if (ExportTableDialog.this.mColumnsToExport != null) {
                        ExportTableDialog.this.mColumnsToExport.clear();
                    }
                    ExportTableDialog.this.mColumns.keySet().forEach(c -> c.setSelection(true));
                    ExportTableDialog.this.adjustAcceptance();
                }
            }
        });
        MenuItem menuItemDeSelect = new MenuItem(this.contextMenu, 0);
        menuItemDeSelect.setText("&De Select All");
        menuItemDeSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExportTableDialog.this.mExportAllColumnsRadio.getSelection()) {
                    if (ExportTableDialog.this.mColumnsToExport != null) {
                        ExportTableDialog.this.mColumnsToExport.clear();
                    }
                    ExportTableDialog.this.mColumns.keySet().forEach(c -> c.setSelection(false));
                    ExportTableDialog.this.adjustAcceptance();
                }
            }
        });
        firstContent.setMenu(this.contextMenu);
    }

    private boolean addColumn(Composite group, @NonNull C column) {
        if (!((Column)column).isHiddenFromExport()) {
            boolean checked = ((Column)column).getRequredByColumns().stream().anyMatch(Column::isVisible) || ((Column)column).isVisible();
            this.mColumns.put(this.createCheckbox(group, ((Column)column).getCompleteName(), ((Column)column).getToolTipText(), checked), column);
            return true;
        }
        return false;
    }

    private void addRowSelectionOptions() {
        OutlineModel<C> model = this.mOutline.getModel();
        boolean hasSelection = model.hasSelection();
        this.mSelectedRows = hasSelection ? model.getSelectionAsList(true) : Collections.EMPTY_LIST;
        this.mExportAllRowsRadio = this.createRadioButton(this.mContent, ReportMessages.EXPORT_ALL_ROWS, ReportMessages.EXPORT_ALL_ROWS_TOOLTIP, !hasSelection);
        this.mExportSelectedRowsRadio = this.createRadioButton(this.mContent, MessageFormat.format(ReportMessages.EXPORT_SELECTED_ROWS_AND_THEIR_CHILD_ROWS, this.mSelectedRows.size()), ReportMessages.EXPORT_SELECTED_ROWS_TOOLTIP, hasSelection);
        if (!hasSelection) {
            this.mExportSelectedRowsRadio.setEnabled(false);
        }
    }

    private @NonNull Button createCheckbox(Composite parent, String title, String tooltip, boolean checked) {
        Button button = new Button(parent, 32);
        button.setSelection(checked);
        button.setText(title);
        button.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        button.addSelectionListener((SelectionListener)this);
        GridDataFactory.swtDefaults().applyTo((Control)button);
        return button;
    }

    private Button createRadioButton(Composite parent, String title, String tooltip, boolean selected) {
        Button button = new Button(parent, 16);
        button.setSelection(selected);
        button.setText(title);
        button.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        button.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)button);
        return button;
    }
}

