/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.report;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.report.IColumnEnum;
import com.arm.streamline.editortabs.report.ReportMessages;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.utils.NullChecking;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ColumnUtils {
    public static <T, X, E extends IColumnEnum<T, X>> void createColumns(OutlineModel<EnumColumn<T>> model, @NonNull E @NonNull [] enumValues, X data) {
        ColumnUtils.createColumns(model, Arrays.asList(enumValues), data);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static <T, X, E extends IColumnEnum<T, X>> void createColumns(OutlineModel<EnumColumn<T>> model, @NonNull Iterable<@NonNull E> enumValues, X data) {
        @NonNull HashMap<@NonNull IColumnEnum, @NonNull EnumColumn<T>> fromEnum = new HashMap();
        int idCounter = 0;
        for (IColumnEnum one : enumValues) {
            EnumColumn column = new EnumColumn(one, idCounter++, one.getHeader(data), one.getToolTip(data), one.getCell(data), one.isHiddenFromUi(), one.isHiddenFromExport(), one.isVisibleByDefault());
            fromEnum.put(one, column);
            column.setUserRef(one);
            column.setSortCriteria(one.getInitialSortSequence(), one.isInitialSortAscending());
            column.setPrimary(one.isPrimary());
            model.addColumn(column);
        }
        @NonNull Map<@NonNull EnumColumn, @NonNull IColumnEnum> toEnum = fromEnum.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        ColumnUtils.addDerivedColumns(fromEnum, toEnum);
        @NonNull Set<@NonNull EnumColumn<T>> columns = toEnum.keySet();
        ColumnUtils.addRequiedByColumns(columns);
        fromEnum.entrySet().forEach(entry -> {
            @NonNull IColumnEnum key = (IColumnEnum)entry.getKey();
            @NonNull @NonNull @NonNull @NonNull EnumColumn column = (EnumColumn)entry.getValue();
            @Nullable IColumnEnum<T, X> parentKey = key.getHeirarchicalParentColumn();
            if (parentKey != null) {
                @NonNull EnumColumn parentColumn = (EnumColumn)NullChecking.neverNull((Object)((EnumColumn)fromEnum.get(parentKey)));
                column.setHierarchicalParentColumn(parentColumn);
            }
        });
    }

    private static <T> void addRequiedByColumns(@NonNull Set<@NonNull EnumColumn<T>> columns) {
        for (EnumColumn<T> col : columns) {
            for (EnumColumn derivedFrom : col.getDerivedFromColumns()) {
                derivedFrom.getRequredByColumns().add(col);
            }
        }
    }

    private static <T, X, E extends IColumnEnum<T, X>> void addDerivedColumns(@NonNull Map<@NonNull E, @NonNull EnumColumn<T>> fromEnum, @NonNull Map<@NonNull EnumColumn<T>, @NonNull E> toEnum) {
        for (EnumColumn<T> column : fromEnum.values()) {
            @NonNull List<@NonNull EnumColumn<T>> derivedColumns = ColumnUtils.getDerivedColumns(column, fromEnum, toEnum);
            column.setDerivedFromColumns(derivedColumns);
        }
    }

    private static <T, X, E extends IColumnEnum<T, X>> @NonNull List<@NonNull EnumColumn<T>> getDerivedColumns(EnumColumn<T> column, @NonNull Map<@NonNull E, @NonNull EnumColumn<T>> mapper, @NonNull Map<@NonNull EnumColumn<T>, @NonNull E> reverseMapper) {
        @NonNull List<@NonNull EnumColumn<T>> derivedColumns = ((IColumnEnum)NullChecking.neverNull((Object)((IColumnEnum)reverseMapper.get(column)))).getDerivedFromColumns().stream().map(c -> (EnumColumn)NullChecking.neverNull((Object)((EnumColumn)mapper.get(c)))).collect(Collectors.toList());
        return derivedColumns;
    }

    public static @NonNull String doubleTip(long total, long amt) {
        return ColumnUtils.percentAmountTip(amt, total > 0L ? (double)amt * 100.0 / (double)total : 0.0);
    }

    public static @NonNull String doubleTip(long total, long amt, @NonNull String unit) {
        return ColumnUtils.percentAmountTip(amt, total > 0L ? (double)amt * 100.0 / (double)total : 0.0, unit);
    }

    public static @NonNull String percentAmountTip(long amt, double percent) {
        return MessageFormat.format(ReportMessages.DOUBLE_TIP, NumberUtils.prettyFormat((long)amt), NumberUtils.formatPercentage((double)(percent >= 0.0 ? percent : 0.0), (boolean)false));
    }

    public static @NonNull String percentAmountTip(long amt, double percent, @NonNull String unit) {
        if ((unit = unit.trim()).isEmpty()) {
            return ColumnUtils.percentAmountTip(amt, percent);
        }
        return MessageFormat.format(ReportMessages.DOUBLE_TIP, String.format("%s %s", NumberUtils.prettyFormat((long)amt), unit), NumberUtils.formatPercentage((double)(percent >= 0.0 ? percent : 0.0), (boolean)false));
    }
}

