/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.report;

import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.IAnalysisProvider;
import com.arm.streamline.model.iterable.CallPathSelectionIterator;
import com.arm.streamline.model.iterable.FunctionSelectionIterator;
import com.arm.streamline.model.iterable.SelectionIterator;
import com.arm.streamline.model.iterable.SourceFileSelectionIterator;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.selection.ReadOnlyStdSelection;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class AnalysisOutline<T>
extends Outline<EnumColumn<T>>
implements IAnalysisProvider {
    private Analysis mAnalysis;
    private Class<?> mModelObjType;

    public AnalysisOutline(Composite parent, @NonNull OutlineModel<EnumColumn<T>> model, Class<?> modelObjType, boolean showIndent) {
        super(parent, model, false, showIndent);
        this.mModelObjType = modelObjType;
    }

    @Override
    public Analysis getAnalysis() {
        return this.mAnalysis;
    }

    public void setAnalysis(Analysis analysis) {
        this.mAnalysis = analysis;
    }

    @Override
    public void setSelection(ISelection selection) {
        if (selection instanceof ReadOnlyStdSelection) {
            super.setSelection(selection);
        } else {
            HashSet<Object> set = new HashSet<Object>();
            if (this.mModelObjType == IFunction.class) {
                Collections.addAll(set, SelectionIterator.toArray(new FunctionSelectionIterator(selection), new IFunction[0]));
            } else if (this.mModelObjType == ICallPath.class) {
                Collections.addAll(set, SelectionIterator.toArray(new CallPathSelectionIterator(selection), new ICallPath[0]));
            } else if (this.mModelObjType == SourceFile.class) {
                Collections.addAll(set, SelectionIterator.toArray(new SourceFileSelectionIterator(selection), new SourceFile[0]));
            }
            if (!set.isEmpty()) {
                OutlineModel<EnumColumn<T>> model = this.getModel();
                ArrayList<@NonNull Row<EnumColumn<T>>> rows = new ArrayList<Row<EnumColumn<T>>>();
                for (Row<EnumColumn<T>> row : model.getTopLevelRows()) {
                    this.collectMatches(rows, set, row);
                }
                model.select(rows, false);
                Display display = this.getDisplay();
                if (display != null) {
                    display.asyncExec(() -> {
                        if (!this.isDisposed()) {
                            this.scrollSelectionIntoView(true);
                        }
                    });
                }
            }
        }
    }

    private void collectMatches(List<@NonNull Row<EnumColumn<T>>> rows, HashSet<Object> set, Row<EnumColumn<T>> row) {
        if (row.hasChildren()) {
            for (Row child : (List)NullChecking.neverNull(row.getChildren())) {
                this.collectMatches(rows, set, child);
            }
        }
        if (set.contains(((ReportRow)row).getModelObject())) {
            rows.add(row);
            row.disclose();
        }
    }
}

