/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.log;

import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.editortabs.StreamlineContextMenu;
import com.arm.streamline.editortabs.log.LogEntryColumns;
import com.arm.streamline.editortabs.log.LogEntryFilterTask;
import com.arm.streamline.editortabs.log.LogEntryRow;
import com.arm.streamline.editortabs.log.LogMessages;
import com.arm.streamline.editortabs.log.LogOutline;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.editortabs.report.ExportTableAction;
import com.arm.streamline.editortabs.report.IColumnEnum;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.LogEntriesFile;
import com.arm.streamline.model.LogEntry;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.BusyIndicator;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.FilterField;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.Header;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;

public class LogEntryTab
extends EditorTab
implements ICommandTarget,
IOutlineListener<EnumColumn<LogEntry>>,
PaintListener,
FilterField.IFilterMatcher {
    private LogOutline mOutline;
    private BusyIndicator mBusy;
    private ToolbarReadout mTotalField;
    private ToolbarReadout mDeltaField;
    private FilterField[] mFilterFields;
    private long mWhenStartMicros = 0L;
    private long mWhenEndMicros = Long.MAX_VALUE;
    private long mDurationStartMicros = 0L;
    private long mDurationEndMicros = Long.MAX_VALUE;
    private boolean mNeedUpdate;
    private LogEntryFilterTask mCurrentTask;

    private static double extractPositiveDouble(String text) {
        double result = Double.parseDouble(text);
        if (result < 0.0) {
            throw new NumberFormatException();
        }
        return result;
    }

    private static long extractPositiveLong(String text) {
        long result = Long.parseLong(text);
        if (result < 0L) {
            throw new NumberFormatException();
        }
        return result;
    }

    private static long parseTime(String text) {
        long seconds = 0L;
        if (!(text = text.trim()).isEmpty()) {
            int colon = text.indexOf(58);
            if (colon != -1) {
                seconds = LogEntryTab.extractPositiveLong(text.substring(0, colon)) * 60000000L;
                if ((colon = (text = text.substring(colon + 1)).indexOf(58)) != -1) {
                    seconds *= 60L;
                    seconds += LogEntryTab.extractPositiveLong(text.substring(0, colon)) * 60000000L;
                    text = text.substring(colon + 1);
                }
            }
            seconds += (long)(LogEntryTab.extractPositiveDouble(text) * 1000000.0);
        }
        return seconds;
    }

    public LogEntryTab(@NonNull AnalysisEditor editor) {
        super(editor);
        this.init();
    }

    @Override
    public void deleteSelectionRequested(Outline<EnumColumn<LogEntry>> outline) {
    }

    @Override
    public void editorChanged(Outline<EnumColumn<LogEntry>> outline) {
    }

    @Override
    public void findMatches(FilterField field) {
        if (field == this.mFilterFields[LogEntryColumns.WHEN.ordinal()]) {
            long[] range = this.extractRangeConstraints(field, this.mWhenStartMicros, this.mWhenEndMicros);
            this.mWhenStartMicros = range[0];
            this.mWhenEndMicros = range[1];
        } else if (field == this.mFilterFields[LogEntryColumns.DURATION.ordinal()]) {
            long[] range = this.extractRangeConstraints(field, this.mDurationStartMicros, this.mDurationEndMicros);
            this.mDurationStartMicros = range[0];
            this.mDurationEndMicros = range[1];
        } else {
            this.mNeedUpdate = true;
        }
        if (this.mNeedUpdate) {
            this.mNeedUpdate = false;
            if (this.mCurrentTask != null) {
                this.mCurrentTask.cancel();
            }
            this.mCurrentTask = new LogEntryFilterTask(this, this.mWhenStartMicros, this.mWhenEndMicros, this.mDurationStartMicros, this.mDurationEndMicros, this.mFilterFields[LogEntryColumns.MESSAGE.ordinal()].getPattern(), this.mFilterFields[LogEntryColumns.GROUP.ordinal()].getPattern(), this.mFilterFields[LogEntryColumns.CHANNEL.ordinal()].getPattern(), this.mFilterFields[LogEntryColumns.WHERE.ordinal()].getPattern());
            Task.callOnAnotherThread((Runnable)this.mCurrentTask);
        }
    }

    public BusyIndicator getBusyIndicator() {
        return this.mBusy;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.mOutline;
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        FilterField[] filterFieldArray = this.mFilterFields;
        int n = this.mFilterFields.length;
        int n2 = 0;
        while (n2 < n) {
            FilterField field = filterFieldArray[n2];
            if (field.handleCommand(command)) {
                return;
            }
            ++n2;
        }
        if (this.mOutline.isFocusControl() && this.mOutline.obeyCommand(commandAction)) {
            return;
        }
    }

    @Override
    public void openSelectionRequested(Outline<EnumColumn<LogEntry>> outline) {
        this.requireEditor().select(EditorTabID.TIMELINE, (ISelection)outline.getModel().getSelection());
    }

    public void paintControl(PaintEvent event) {
        if (this.getAnalysis().getLogEntriesFile().getAllLogEntries().isEmpty()) {
            Rectangle bounds = this.mOutline.getClientArea();
            GC gc = event.gc;
            gc.setForeground(Colors.getGray());
            Font font = Fonts.getNormalStandout();
            gc.setFont(font);
            FontInfo fontInfo = FontInfo.get(font);
            Point size = fontInfo.getExtent(LogMessages.EMPTY_MSG);
            TextDrawing.drawText(gc, LogMessages.EMPTY_MSG, bounds.x + (bounds.width - size.x) / 2, bounds.y + (bounds.height - size.y) / 2, 16384);
        }
    }

    @Override
    public void recomputeFromModel() {
    }

    public void selectEntryRange(long startMicros, long endMicros) {
        this.mOutline.selectEntryRange(startMicros, endMicros);
    }

    @Override
    public void selectionChanged(Outline<EnumColumn<LogEntry>> outline) {
        this.updateSummary();
    }

    public void setCurrentLogEntries(ArrayList<LogEntry> list) {
        ArrayList<LogEntry> selection = new ArrayList<LogEntry>();
        OutlineModel model = this.mOutline.getModel();
        for (Row row : model.getSelectionAsList()) {
            selection.add((LogEntry)((LogEntryRow)row).getModelObject());
        }
        this.getAnalysis().getLogEntriesFile().setCurrentLogEntries(list);
        this.loadOutline(false);
        int earliest = 0;
        int count = model.getRowCount();
        ArrayList<@NonNull LogEntryRow> rows = new ArrayList<LogEntryRow>();
        block1: for (LogEntry logEntry : selection) {
            int i = earliest;
            while (i < count) {
                LogEntryRow row = (LogEntryRow)model.getRowAtIndex(i);
                if (row.getModelObject() == logEntry) {
                    rows.add(row);
                    earliest = i + 1;
                    continue block1;
                }
                ++i;
            }
        }
        if (rows.isEmpty()) {
            this.updateSummary();
        } else {
            model.select(rows, false);
        }
        this.mOutline.clearMarkers();
    }

    public boolean setFocus() {
        return this.mOutline.setFocus();
    }

    @Override
    public void sourceFilePathChanged(SourceFile[] files) {
        this.mOutline.redraw();
    }

    @Override
    protected Composite createContent() {
        Composite content = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(content);
        this.createOutline(content);
        return content;
    }

    @Override
    protected void fillToolbar(CustomToolbar toolbar) {
        @NonNull LogOutline mOutline = (LogOutline)NullChecking.neverNull((Object)this.mOutline);
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull LogEntryColumns @NonNull [] columns = LogEntryColumns.values();
        toolbar.addAction(new OpenSourceFileAction(mOutline, analysis::showPathSubstitutionDialog)).setLayoutData(new CustomToolbar.LayoutData().setGap(1));
        this.mFilterFields = new FilterField[columns.length];
        int i = 0;
        while (i < columns.length) {
            this.mFilterFields[i] = new FilterField(toolbar, this, columns[i].getTitleSingleLine(this.getAnalysis()), columns[i].getFilterToolTip(), columns[i].filterUsesPattern());
            this.mFilterFields[i].setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(columns[i].getMinimumFilterWidth()).setGap(3));
            ++i;
        }
        this.mBusy = new BusyIndicator(toolbar);
        LogEntriesFile logEntriesFile = this.getAnalysis().getLogEntriesFile();
        this.mTotalField = new ToolbarReadout(toolbar, NumberUtils.prettyFormat((int)0), 131072, LogMessages.TOTAL_TOOLTIP);
        this.mTotalField.setDesiredMinimumTextWidth(FontInfo.get(this.mTotalField.getFont()).getWidth(NumberUtils.prettyFormat((int)logEntriesFile.getCount())));
        this.mTotalField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mTotalField.computeSize((int)-1, (int)-1).x).setGap(5));
        this.mDeltaField = new ToolbarReadout(toolbar, LogMessages.NA, 131072, LogMessages.DELTA_TOOLTIP);
        TimeUnit timeUnit = this.getAnalysis().getTimeUnit();
        this.mDeltaField.setDesiredMinimumTextWidth(FontInfo.get(this.mDeltaField.getFont()).getWidth("+" + timeUnit.formatInBase((double)logEntriesFile.getDeltaBetweenFirstAndLast(), 1000.0, TimeUnit.Style.NO_UNIT, true)));
        this.mDeltaField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mDeltaField.computeSize((int)-1, (int)-1).x).setGap(5));
        toolbar.addAction(new ExportTableAction(this.getAnalysis(), mOutline, "log_for_{0}.csv"));
    }

    @Override
    protected String getHelpID() {
        return "com.arm.streamline.log";
    }

    @Override
    protected void initActionMap(Map<String, IAction> map) {
        String id = ActionFactory.SELECT_ALL.getId();
        map.put(id, (IAction)new CommandAction(id, this));
        id = ActionFactory.COPY.getId();
        map.put(id, (IAction)new CommandAction(id, this));
    }

    private Composite createOutline(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        Header header = new Header(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(header);
        OutlineModel<EnumColumn<LogEntry>> model = new OutlineModel<EnumColumn<LogEntry>>();
        ColumnUtils.createColumns(model, (IColumnEnum[])LogEntryColumns.values(), (Object)this.getAnalysis());
        for (EnumColumn column : model.getColumns()) {
            column.getHeaderCell().setAllowSort(false);
        }
        this.mOutline = new LogOutline(wrapper, model);
        this.mOutline.setAnalysis(this.getAnalysis());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mOutline);
        this.loadOutline(true);
        this.mOutline.addOutlineListener(this);
        this.mOutline.setHeader(header);
        this.mOutline.addPaintListener(this);
        StreamlineContextMenu.createStdContextMenu(this.getEditor(), (Control)this.mOutline, EditorTabID.LOG);
        return wrapper;
    }

    private long[] extractRangeConstraints(FilterField field, long currentMin, long currentMax) {
        long min = 0L;
        long max = Long.MAX_VALUE;
        String text = field.getText().trim();
        int length = text.length();
        try {
            if (text.endsWith("-")) {
                min = LogEntryTab.parseTime(text.substring(0, length - 1));
            } else if (text.startsWith("-")) {
                max = LogEntryTab.parseTime(text.substring(1));
            } else if (length > 0) {
                int dash = text.indexOf(45);
                if (dash == -1) {
                    max = min = LogEntryTab.parseTime(text);
                } else {
                    long end;
                    long start = LogEntryTab.parseTime(text.substring(0, dash));
                    if (start > (end = LogEntryTab.parseTime(text.substring(dash + 1)))) {
                        throw new IllegalArgumentException();
                    }
                    min = start;
                    max = end;
                }
            }
            field.setValid(true);
        }
        catch (Exception exception) {
            field.setValid(false);
        }
        if (currentMin != min || currentMax != max) {
            this.mNeedUpdate = true;
        }
        return new long[]{min, max};
    }

    private void loadOutline(boolean sizeColumns) {
        String config = this.mOutline.getConfig();
        this.mOutline.setAllowLazyAdjust(false);
        OutlineModel outlineModel = this.mOutline.getModel();
        boolean canNotify = outlineModel.getSelection().canNotify();
        outlineModel.getSelection().setNotify(false);
        outlineModel.removeAllRows();
        Analysis analysis = this.getAnalysis();
        if (analysis.getLogEntriesFile().getCurrentLogEntries().size() > 10000) {
            LogEntryColumns[] logEntryColumnsArray = LogEntryColumns.values();
            int n = logEntryColumnsArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogEntryColumns one = logEntryColumnsArray[n2];
                EnumColumn column = (EnumColumn)NullChecking.neverNull((Object)((EnumColumn)outlineModel.getColumnWithID(one.ordinal())));
                column.setDefaultPreferredWidth(Math.min(one.getPreferredWidth(analysis) + 12, column.getMaxWidth()));
                ++n2;
            }
        }
        ArrayList<@NonNull LogEntryRow> rows = new ArrayList<LogEntryRow>();
        for (LogEntry logEntry : this.getAnalysis().getLogEntriesFile().getCurrentLogEntries()) {
            rows.add(new LogEntryRow(logEntry));
        }
        outlineModel.addNonHierarchicalRowsFast(rows);
        this.mOutline.applyConfig(config, true, true);
        this.mOutline.setAllowLazyAdjust(true);
        if (sizeColumns) {
            this.mOutline.sizeColumnsToFit();
        }
        outlineModel.getSelection().setNotify(canNotify);
        this.mOutline.getDefaultConfig();
        this.mOutline.adjustScrollBarsForContent();
    }

    private void updateSummary() {
        List rows = this.mOutline.getModel().getSelectionAsList();
        int count = rows.size();
        boolean needLayout = this.mTotalField.setText(NumberUtils.prettyFormat((int)count));
        Object text = LogMessages.NA;
        if (count > 1) {
            LogEntry first = (LogEntry)((LogEntryRow)rows.get(0)).getModelObject();
            LogEntry last = (LogEntry)((LogEntryRow)rows.get(count - 1)).getModelObject();
            text = "+" + this.getAnalysis().getTimeUnit().formatInBase((double)(last.getTimestamp() - first.getTimestamp()), 1000.0, TimeUnit.Style.NO_UNIT, true);
        }
        if (needLayout |= this.mDeltaField.setText((String)text)) {
            SafeUpdate.layout(this.getToolbar());
        }
    }
}

