/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.log;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.log.LogEntryColumns;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.model.LogEntry;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.EnumColumn;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class LogEntryRow
extends ReportRow<LogEntry> {
    private boolean mMarked;

    public LogEntryRow(@NonNull LogEntry logEntry) {
        super(logEntry);
    }

    @Override
    public Color getBackgroundColor(Device device, boolean selected, boolean active) {
        if (selected || !this.mMarked) {
            return super.getBackgroundColor(device, selected, active);
        }
        return Colors.lighten(Colors.getYellow(), 50);
    }

    @Override
    public Image getImage(EnumColumn<LogEntry> column) {
        if (column.getID() == LogEntryColumns.MESSAGE.ordinal()) {
            LogEntry entry = (LogEntry)this.getModelObject();
            if (entry.getImagePath() != null) {
                return StreamlinePlugin.getImage("Camera.png");
            }
            if (entry.isBookmark()) {
                return StreamlinePlugin.getImage("Bookmarks.png");
            }
        }
        return super.getImage(column);
    }

    @Override
    public String getToolTipTextWhenTruncated(EnumColumn<LogEntry> column) {
        if (this.getColumnEnum(column) == LogEntryColumns.MESSAGE) {
            return ((LogEntry)this.getModelObject()).getMessage();
        }
        return super.getToolTipTextWhenTruncated(column);
    }

    public void setMarked(boolean marked) {
        this.mMarked = marked;
    }
}

