/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.histogram;

import com.arm.streamline.editortabs.histogram.HistogramCellDataProvider;
import com.arm.streamline.widget.outline.HistogramCell;
import java.util.function.Function;
import java.util.function.ToLongBiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class HistogramUnscaledCellDataProvider<T>
implements HistogramCellDataProvider.IHistogramSizedCellDataProvider<T> {
    private static final int MIN_WIDTH = 4;
    protected final long @NonNull [] datapointBase;
    protected final int @NonNull [] datapointPixelBase;
    protected final int @NonNull [] datapointPixelWidth;
    protected final int @NonNull [] datapointWidth;
    protected final @NonNull ToLongBiFunction<@NonNull T, long @NonNull []> limitSupplier;
    protected final @NonNull Function<@NonNull T, long @Nullable []> mapper;
    protected final long numberOfDataPoints;
    protected final int pixelWidth;
    protected final long smallestDataPoint;
    protected final @NonNull String unitsSuffix;

    public HistogramUnscaledCellDataProvider(boolean linearScale, int pixelWidth, long numberOfDataPoints, long @NonNull [] datapointBase, int @NonNull [] datapointWidth, long smallestDataPoint, @NonNull String units, @NonNull ToLongBiFunction<@NonNull T, long @NonNull []> limitSupplier, @NonNull Function<@NonNull T, long @Nullable []> mapper) {
        this(linearScale, 4, pixelWidth, numberOfDataPoints, datapointBase, datapointWidth, smallestDataPoint, units, limitSupplier, mapper);
    }

    HistogramUnscaledCellDataProvider(boolean linearScale, int minWidth, int pixelWidth, long numberOfDataPoints, long @NonNull [] datapointBase, int @NonNull [] datapointWidth, long smallestDataPoint, @NonNull String units, @NonNull ToLongBiFunction<@NonNull T, long @NonNull []> limitSupplier, @NonNull Function<@NonNull T, long @Nullable []> mapper) {
        assert (minWidth > 0);
        assert (pixelWidth > 0);
        assert (datapointBase.length * minWidth <= pixelWidth);
        units = units.trim();
        this.pixelWidth = pixelWidth;
        this.mapper = mapper;
        this.datapointBase = datapointBase;
        this.datapointWidth = datapointWidth;
        this.datapointPixelBase = new int[datapointWidth.length];
        this.datapointPixelWidth = new int[datapointWidth.length];
        this.limitSupplier = limitSupplier;
        this.smallestDataPoint = smallestDataPoint;
        this.numberOfDataPoints = numberOfDataPoints;
        this.unitsSuffix = units.isEmpty() ? units : String.format(" %s", units);
        double pixelScale = (double)pixelWidth / (double)Math.max(1, datapointBase.length);
        int i = 0;
        while (i < datapointBase.length) {
            int previousEnd;
            int scaledWidth;
            int scaledBase;
            if (linearScale) {
                long dpBase = datapointBase[i] - smallestDataPoint;
                int dpWidth = datapointWidth[i];
                long dpEnd = dpBase + (long)dpWidth;
                int scaledLimit = Math.toIntExact(dpEnd * (long)pixelWidth / numberOfDataPoints);
                scaledBase = Math.toIntExact(dpBase * (long)pixelWidth / numberOfDataPoints);
                scaledWidth = Math.max(minWidth, scaledLimit - scaledBase);
            } else {
                int scaledLimit = Math.toIntExact((long)((double)(i + 1) * pixelScale));
                scaledBase = Math.toIntExact((long)((double)i * pixelScale));
                scaledWidth = Math.max(minWidth, scaledLimit - scaledBase);
            }
            int scaledEnd = scaledBase + scaledWidth;
            int maxBase = pixelWidth - datapointBase.length * minWidth + i * minWidth;
            int maxEnd = maxBase + minWidth;
            int n = previousEnd = i > 0 ? this.datapointPixelBase[i - 1] + this.datapointPixelWidth[i - 1] : 0;
            assert (previousEnd <= maxBase);
            int actualBase = Math.min(maxBase, Math.max(previousEnd, scaledBase));
            int actualEnd = Math.min(scaledEnd, maxEnd);
            int actualWidth = actualEnd - actualBase;
            if (actualWidth >= minWidth) {
                this.datapointPixelBase[i] = actualBase;
                this.datapointPixelWidth[i] = actualWidth;
            } else if (actualBase <= maxBase) {
                this.datapointPixelBase[i] = actualBase;
                this.datapointPixelWidth[i] = minWidth;
            } else {
                this.datapointPixelBase[i] = maxBase;
                this.datapointPixelWidth[i] = minWidth;
            }
            ++i;
        }
    }

    @Override
    public  @Nullable HistogramCell.IHistogramData get(@NonNull T value) {
        final long @Nullable [] histogramData = this.mapper.apply(value);
        if (histogramData == null) {
            return null;
        }
        assert (histogramData.length == this.datapointBase.length);
        final double limit = this.limitSupplier.applyAsLong(value, histogramData);
        return new HistogramCell.IHistogramData(){

            @Override
            public int getBinCount() {
                return histogramData.length;
            }

            @Override
            public int getBinOffset(int bin) {
                if (bin < histogramData.length) {
                    return HistogramUnscaledCellDataProvider.this.datapointPixelBase[bin];
                }
                return HistogramUnscaledCellDataProvider.this.pixelWidth;
            }

            @Override
            public double getBinValue(int bin) {
                return (double)histogramData[bin] / limit;
            }

            @Override
            public int getBinWidth(int bin) {
                if (bin < histogramData.length) {
                    return HistogramUnscaledCellDataProvider.this.datapointPixelWidth[bin];
                }
                return 0;
            }

            @Override
            public @NonNull String getLabelForBin(int bin) {
                long base = HistogramUnscaledCellDataProvider.this.datapointBase[bin];
                int width = HistogramUnscaledCellDataProvider.this.datapointWidth[bin];
                if (width > 1) {
                    long end = base + (long)width - 1L;
                    return String.format("%d-%d%s: %d", base, end, HistogramUnscaledCellDataProvider.this.unitsSuffix, histogramData[bin]);
                }
                return String.format("%d%s: %d", base, HistogramUnscaledCellDataProvider.this.unitsSuffix, histogramData[bin]);
            }

            @Override
            public double getMaxValue() {
                long result = 0L;
                long[] lArray = histogramData;
                int n = histogramData.length;
                int n2 = 0;
                while (n2 < n) {
                    long d = lArray[n2];
                    result = Math.max(result, d);
                    ++n2;
                }
                return (double)result / limit;
            }

            @Override
            public @Nullable String getText() {
                return null;
            }
        };
    }
}

