/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.histogram;

import com.arm.utils.NullChecking;
import gnu.trove.list.TDoubleList;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntDoubleMap;
import gnu.trove.map.hash.TIntDoubleHashMap;
import org.eclipse.jdt.annotation.NonNull;

public final class HistogramDataRebinner {
    private final int maxBinIndex;
    private final double maxProportion;
    private final int minBinIndex;
    private final int @NonNull [] sourceDatapointIndexes;
    private final double @NonNull [] valueSourceDatapointProportions;
    private final double @NonNull [] heightSourceDatapointProportions;
    private final int @NonNull [] targetBinIndexes;

    public HistogramDataRebinner(long @NonNull [] datapointBase, int @NonNull [] datapointWidth, @NonNull IRebinningFunction rebinningFunction) {
        @NonNull TDoubleArrayList valueProportionAmounts = new TDoubleArrayList();
        @NonNull TDoubleArrayList heightProportionAmounts = new TDoubleArrayList();
        @NonNull TIntArrayList proportionSourceIndexes = new TIntArrayList();
        @NonNull TIntArrayList proportionBinIndexes = new TIntArrayList();
        @NonNull TIntDoubleHashMap sumProportions = new TIntDoubleHashMap(10, 0.5f, -1, 0.0);
        double @NonNull [] currentMaxProp = new double[1];
        int[] nArray = new int[2];
        nArray[0] = Integer.MAX_VALUE;
        int[] minMaxTargetBin = nArray;
        int i = 0;
        while (i < datapointBase.length) {
            long base = datapointBase[i];
            int width = datapointWidth[i];
            assert (width > 0);
            int sourceDatapointIndex = i++;
            rebinningFunction.rebin(base, width, (arg_0, arg_1) -> HistogramDataRebinner.lambda$0(width, (TDoubleList)valueProportionAmounts, (TDoubleList)heightProportionAmounts, (TIntList)proportionSourceIndexes, sourceDatapointIndex, (TIntList)proportionBinIndexes, (TIntDoubleMap)sumProportions, currentMaxProp, minMaxTargetBin, arg_0, arg_1));
        }
        this.valueSourceDatapointProportions = (double[])NullChecking.neverNull((Object)valueProportionAmounts.toArray());
        this.heightSourceDatapointProportions = (double[])NullChecking.neverNull((Object)heightProportionAmounts.toArray());
        this.sourceDatapointIndexes = (int[])NullChecking.neverNull((Object)proportionSourceIndexes.toArray());
        this.targetBinIndexes = (int[])NullChecking.neverNull((Object)proportionBinIndexes.toArray());
        this.maxProportion = currentMaxProp[0];
        this.minBinIndex = minMaxTargetBin[0];
        this.maxBinIndex = minMaxTargetBin[1];
    }

    public int getMinDataBinIndex() {
        return this.minBinIndex != Integer.MAX_VALUE ? this.minBinIndex : 0;
    }

    public int getRealBinCount() {
        return this.minBinIndex != Integer.MAX_VALUE ? this.maxBinIndex + 1 : 0;
    }

    public double getScaleFactor() {
        return this.maxProportion;
    }

    public double @NonNull [] transform(long @NonNull [] data, double limit) {
        double @NonNull [] binData = new double[2 * this.getBinCount()];
        if (binData.length == 0) {
            return binData;
        }
        int i = 0;
        while (i < this.valueSourceDatapointProportions.length) {
            double valueProportion = this.valueSourceDatapointProportions[i];
            double heightProportion = this.heightSourceDatapointProportions[i];
            int sourceIndex = this.sourceDatapointIndexes[i];
            int binIndex = this.targetBinIndexes[i] - this.minBinIndex;
            long dataValue = data[sourceIndex];
            double valueIncrement = valueProportion * ((double)dataValue / limit);
            double heightIncrement = heightProportion * ((double)dataValue / limit);
            int n = binIndex * 2 + 0;
            binData[n] = binData[n] + valueIncrement;
            int n2 = binIndex * 2 + 1;
            binData[n2] = binData[n2] + heightIncrement;
            ++i;
        }
        return binData;
    }

    private int getBinCount() {
        return this.minBinIndex != Integer.MAX_VALUE ? this.maxBinIndex - this.minBinIndex + 1 : 0;
    }

    private static /* synthetic */ void lambda$0(int n, TDoubleList tDoubleList, TDoubleList tDoubleList2, TIntList tIntList, int n2, TIntList tIntList2, TIntDoubleMap tIntDoubleMap, double[] dArray, int[] nArray, int targetBin, double sourceProportion) {
        if (targetBin < 0) {
            throw new IllegalArgumentException();
        }
        if (sourceProportion > 0.0) {
            double heightSourceProportion = sourceProportion * (double)n;
            tDoubleList.add(sourceProportion);
            tDoubleList2.add(heightSourceProportion);
            tIntList.add(n2);
            tIntList2.add(targetBin);
            double targetBinSum = tIntDoubleMap.adjustOrPutValue(targetBin, heightSourceProportion, heightSourceProportion);
            dArray[0] = Math.max(dArray[0], targetBinSum);
            nArray[0] = Math.min(nArray[0], targetBin);
            nArray[1] = Math.max(nArray[1], targetBin);
        }
    }

    @FunctionalInterface
    public static interface IRebinningConsumer {
        public void accept(int var1, double var2);
    }

    @FunctionalInterface
    public static interface IRebinningFunction {
        public void rebin(long var1, int var3, @NonNull IRebinningConsumer var4);
    }
}

