/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.code.CFamilyKeywordColorData;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.editortabs.code.ColorRun;
import com.arm.streamline.editortabs.code.ISourcePanelInstructionCounterRenderer;
import com.arm.streamline.editortabs.code.SourceColorizer;
import com.arm.streamline.editortabs.code.SourcePanelInstructionCounterColumn;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.iterable.SourceReferenceSelectionIterator;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.PathSubstitutionsFile;
import com.arm.streamline.report.model.SimpleSourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileViews;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.ConsolidatedUIExec;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.IAutoScrollArea;
import com.arm.streamline.widget.IToolTipTracker;
import com.arm.streamline.widget.LineScrollCanvas;
import com.arm.streamline.widget.UpdatingToolTip;
import com.arm.streamline.widget.outline.PercentageCell;
import com.arm.streamline.widget.selection.IStdSelectionOwner;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.LRUCache;
import com.arm.utils.text.BasicTextFilter;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SourcePanel
extends LineScrollCanvas
implements IToolTipTracker,
IStdSelectionOwner,
FocusListener,
KeyListener,
IAutoScrollArea,
MouseListener,
MouseMoveListener,
Runnable,
ISelectionProvider {
    protected static final int MARGIN = 2;
    private static final int COL_INLINE = 1;
    private static final int COL_LINE = 2;
    private static final int COL_COUNTER = 0;
    private static final int COL_SOURCE = 3;
    private static final int COL_TOTAL = 4;
    private static final int GAP = 5;
    private static final int HEADER_MARGIN = 4;
    private static final int MORE_H_MARGIN = 4;
    private static final int MORE_OFFSET = 4;
    private static final int MORE_V_MARGIN = 0;
    private static final int MSG_GAP = 10;
    private static final int TAB_WIDTH = 4;
    private final @NonNull IObservableValue<@Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata> currentSelectedCounter;
    private final @NonNull IValueChangeListener<@Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata> currentSelectedCounterListener;
    private int mCharWidth;
    private List<ColorRun[]> mColorRuns = new ArrayList<ColorRun[]>();
    private int[] mColumnSizes = new int[4];
    private SelectionInfo mDeferredSelection;
    private boolean mDragSelectOK;
    private SourceFile mFile;
    private TIntObjectHashMap<Color> mFunctionColorMap = new TIntObjectHashMap();
    private boolean mHasSource;
    private int mHeaderLineHeight;
    private long mInitialMouseTime;
    private int mInitialMouseY;
    private Image mInlineImage;
    private boolean mInMsgBounds;
    private boolean mIsStale;
    private int mLineCharCount;
    private int mLineHeight;
    private List<String> mLines = new ArrayList<String>();
    private Rectangle mMoreDownArea = new Rectangle(0, 0, 0, 0);
    private Rectangle mMoreUpArea = new Rectangle(0, 0, 0, 0);
    private MouseState mMouseHandlingState = MouseState.NORMAL;
    private String mMsg;
    private Rectangle mMsgBounds;
    private String mMsgHint;
    private StdSelection mPreservedSelection;
    private StdSelection mSelection = new StdSelection(this);
    private List<ISelectionChangedListener> mSelectionListeners = new ArrayList<ISelectionChangedListener>();
    private int mSelectOnMouseUp;
    private String mTitle = "";
    final LRUCache<IFunction, IFunction> mFunctionLRUCache = new LRUCache(10);
    final @NonNull CodeTab mOwner;

    private static int getBestSize(String header, int contentWidth) {
        return Math.max(FontInfo.get(Fonts.getNormal()).getWidth(header), contentWidth);
    }

    private static int getBestSize(String header, String content) {
        return SourcePanel.getBestSize(header, FontInfo.get(Fonts.getSource()).getWidth(content));
    }

    public SourcePanel(Composite parent, @NonNull CodeTab owner, @NonNull IObservableValue<@Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata> currentSelectedCounter) {
        super(parent);
        ControlHacks.setBackground((Control)this, Colors.getWidgetBackground());
        this.mOwner = owner;
        this.mInlineImage = StreamlinePlugin.getImage("InlinedElsewhere.png");
        this.updateSizes();
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        UpdatingToolTip.create((Control)this, this);
        this.currentSelectedCounter = currentSelectedCounter;
        this.currentSelectedCounterListener = event -> {
            this.updateSizes();
            this.redraw();
        };
        currentSelectedCounter.addValueChangeListener(this.currentSelectedCounterListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.add(listener);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        CodeTab.InstructionCounterCodeColumnsWithMetadata currentCounter = NullChecking.nullable(this.currentSelectedCounter) != null ? (CodeTab.InstructionCounterCodeColumnsWithMetadata)this.currentSelectedCounter.getValue() : null;
        @NonNull String counterTitle = currentCounter != null ? currentCounter.instructionColumn.getTitle() : "";
        this.mColumnSizes[0] = SourcePanel.getBestSize(counterTitle, PercentageCell.getMinimumContentWidth(Fonts.getSource(), false) + 50);
        this.mColumnSizes[1] = this.mInlineImage.getBounds().width;
        int count = this.mLines.size();
        this.mColumnSizes[2] = SourcePanel.getBestSize(CodeMessages.LINE, NumberUtils.format((long)count));
        this.mColumnSizes[3] = SourcePanel.getBestSize(this.mTitle, this.mLineCharCount * this.mCharWidth);
        int width = 4 + 5 * (this.mColumnSizes.length - 1);
        int[] nArray = this.mColumnSizes;
        int n = this.mColumnSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int columnSize = nArray[n2];
            width += columnSize;
            ++n2;
        }
        Point scrollbarSize = this.getSliderSize();
        return new Point(width + scrollbarSize.x, count + (scrollbarSize.y + this.mLineHeight - 1) / this.mLineHeight);
    }

    public void deselect() {
        this.mSelection.deselect();
    }

    public void dispose() {
        this.currentSelectedCounter.removeValueChangeListener(this.currentSelectedCounterListener);
        super.dispose();
    }

    public void focusGained(FocusEvent event) {
        this.redraw();
    }

    public void focusLost(FocusEvent event) {
        this.redraw();
    }

    @Override
    public Rectangle getAutoScrollArea() {
        Rectangle bounds = this.getClientArea();
        bounds.y += this.mHeaderLineHeight + 4;
        bounds.height -= this.mHeaderLineHeight + 4;
        return bounds;
    }

    public int getFirstVisibleLine() {
        return this.getVerticalSlider().getSelection();
    }

    public int getLastFullyVisibleLine() {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int line = (bounds.height - (this.mHeaderLineHeight + 4)) / this.mLineHeight;
        if (line % this.mLineHeight != 0) {
            --line;
        }
        if ((line += this.getFirstVisibleLine()) < 0) {
            return -1;
        }
        return Math.min(line, this.mLines.size() - 1);
    }

    public int getLastVisibleLine() {
        return Math.min(this.getFirstVisibleLine() + this.getPageSize().y, this.mLines.size() - 1);
    }

    public IFunction[] getRecentFunctions() {
        ArrayList list = new ArrayList(this.mFunctionLRUCache.keySet());
        Collections.reverse(list);
        return list.toArray(new IFunction[list.size()]);
    }

    @Override
    public Object getSelectableObjectAtIndex(int index) {
        return new SimpleSourceReference((SourceFile)NullChecking.neverNull((Object)this.mFile), index + 1);
    }

    public ISelection getSelection() {
        ArrayList<SimpleSourceReference> list = new ArrayList<SimpleSourceReference>();
        int i = this.mSelection.nextSelectedIndex(0);
        while (i >= 0) {
            list.add(new SimpleSourceReference((SourceFile)NullChecking.neverNull((Object)this.mFile), i + 1));
            i = this.mSelection.nextSelectedIndex(i + 1);
        }
        return new StructuredSelection(list);
    }

    public SourceFile getSourceFile() {
        return this.mFile;
    }

    @Override
    public String getToolTipForLocation(Point location) {
        int x1 = 0;
        int i = 0;
        while (i < 1) {
            x1 += this.mColumnSizes[i] + 5;
            ++i;
        }
        int x2 = x1 + this.mColumnSizes[1] + 5;
        Point pt = this.toVirtual(new Point(location.x, location.y));
        if (pt.x >= x1 && pt.x <= x2) {
            if (location.y < this.mHeaderLineHeight + 4) {
                return CodeMessages.INFO_HEADER_TOOLTIP;
            }
            int line = this.getLineIndexAt(pt.y);
            if (line > -1 && this.isInlined(line)) {
                return CodeMessages.INLINE_TOOLTIP;
            }
        }
        if (location.y < this.mHeaderLineHeight + 4) {
            x1 = 0;
            int i2 = 0;
            while (i2 < 0) {
                x1 += this.mColumnSizes[i2] + 5;
                ++i2;
            }
            x2 = x1 + this.mColumnSizes[0] + 5;
            pt = this.toVirtual(new Point(location.x, location.y));
            if (pt.x >= x1 && pt.x <= x2) {
                @Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata currentCounter = (CodeTab.InstructionCounterCodeColumnsWithMetadata)this.currentSelectedCounter.getValue();
                if (currentCounter != null) {
                    return currentCounter.sourceLineColumn.getTitleTooltip();
                }
                return null;
            }
            if (this.mIsStale) {
                i2 = 0;
                while (i2 < 3) {
                    x1 += this.mColumnSizes[i2] + 5;
                    ++i2;
                }
                x2 = x1 + this.mColumnSizes[3] + 5;
                pt = this.toVirtual(new Point(location.x, location.y));
                if (pt.x >= x1 && pt.x <= x2) {
                    return CodeMessages.STALE_TOOLTIP;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isAutoScrollMouseDown(int x, int y) {
        return this.getAutoScrollArea().contains(x, y);
    }

    public void keyPressed(KeyEvent event) {
        if (this.mHasSource) {
            if (event.doit) {
                event.doit = false;
                boolean shiftDown = (event.stateMask & 0x20000) != 0;
                switch (event.keyCode) {
                    case 0x1000001: {
                        this.showLine(this.mSelection.selectUp(shiftDown, false));
                        break;
                    }
                    case 0x1000002: {
                        this.showLine(this.mSelection.selectDown(shiftDown, false));
                        break;
                    }
                    case 0x1000007: {
                        this.showLine(this.mSelection.selectToHome(shiftDown));
                        break;
                    }
                    case 0x1000008: {
                        this.showLine(this.mSelection.selectToEnd(shiftDown));
                        break;
                    }
                    case 0x1000005: {
                        this.showLine(this.mSelection.selectToPageUp(Math.max(1, this.getPageSize().y), shiftDown));
                        break;
                    }
                    case 0x1000006: {
                        this.showLine(this.mSelection.selectToPageDown(Math.max(1, this.getPageSize().y), shiftDown));
                        break;
                    }
                    default: {
                        event.doit = true;
                        break;
                    }
                }
            }
        } else {
            this.mOwner.getDisassemblyPanel().keyPressed(event);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        this.setFocus();
        if (this.mMsgBounds != null) {
            this.mInMsgBounds = this.mMsgBounds.contains(event.x, event.y) && this.isMsgClickable();
        } else if (this.mMoreUpArea.contains(event.x, event.y)) {
            this.mMouseHandlingState = MouseState.MORE_UP;
        } else if (this.mMoreDownArea.contains(event.x, event.y)) {
            this.mMouseHandlingState = MouseState.MORE_DOWN;
        } else {
            this.mMouseHandlingState = MouseState.NORMAL;
            if (this.mHasSource) {
                this.mSelectOnMouseUp = -1;
                int method = 0;
                int y = this.toVirtual((Point)new Point((int)0, (int)event.y)).y;
                int line = this.getLineIndexAt(y);
                if ((event.stateMask & 0x20000) != 0) {
                    method |= 1;
                }
                if (event.button == 1 && (event.stateMask & WorkspaceUtils.getCommandKey()) != 0) {
                    method |= 2;
                }
                this.mSelectOnMouseUp = this.mSelection.selectByMouse(line, method);
                if (event.button != 1) {
                    this.mSelectOnMouseUp = -1;
                }
                boolean bl = this.mDragSelectOK = event.button == 1;
                if (this.mDragSelectOK) {
                    this.mInitialMouseY = event.y;
                    this.mInitialMouseTime = System.currentTimeMillis();
                }
            }
        }
    }

    public void mouseMove(MouseEvent event) {
        if (this.mMsgBounds == null && this.mHasSource && this.mDragSelectOK && (event.stateMask & WorkspaceUtils.getCommandKey()) == 0) {
            if (this.mInitialMouseTime != 0L) {
                if (Math.abs(this.mInitialMouseY - event.y) < 4 && System.currentTimeMillis() - this.mInitialMouseTime < 250L) {
                    return;
                }
                this.mInitialMouseTime = 0L;
            }
            if (this.mPreservedSelection == null) {
                this.mPreservedSelection = new StdSelection(this.mSelection);
                this.mPreservedSelection.setNotify(false);
            }
            StdSelection newSel = new StdSelection(this.mPreservedSelection);
            int y = this.toVirtual((Point)new Point((int)0, (int)event.y)).y;
            int line = this.getLineIndexAt(y);
            if (line < 0) {
                line = event.y < 0 ? 0 : this.mLines.size() - 1;
            }
            this.mSelectOnMouseUp = newSel.selectByMouse(line, 1);
            this.mSelection.select(newSel);
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this.mMsgBounds != null) {
            if (this.mInMsgBounds && this.mMsgBounds.contains(event.x, event.y)) {
                this.locateSourceFile();
            }
        } else if (this.mMoreUpArea.contains(event.x, event.y)) {
            if (this.mMouseHandlingState == MouseState.MORE_UP) {
                this.scrollMoreUp();
            }
        } else if (this.mMoreDownArea.contains(event.x, event.y)) {
            if (this.mMouseHandlingState == MouseState.MORE_DOWN) {
                this.scrollMoreDown();
            }
        } else if (this.mHasSource) {
            this.mDragSelectOK = false;
            this.mPreservedSelection = null;
            if (this.mSelectOnMouseUp != -1) {
                this.mSelection.select(this.mSelectOnMouseUp, false);
                this.mSelectOnMouseUp = -1;
            }
        }
        this.mMouseHandlingState = MouseState.NORMAL;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.remove(listener);
    }

    @Override
    public void run() {
        if (!this.isDisposed()) {
            this.refocus();
        }
    }

    public void selectAll() {
        this.mSelection.select();
    }

    @Override
    public void selectionAboutToChange() {
    }

    @Override
    public void selectionDidChange() {
        this.redraw();
        this.notifyOfSelectionChange(true);
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(ISelection selection, boolean notifyDisasm) {
        if (!this.setSelection(new SelectionInfo(selection), notifyDisasm) && (this.mOwner.setShowDisassembly(true) || notifyDisasm)) {
            this.mOwner.getDisassemblyPanel().setSelection(selection, false);
        }
    }

    public boolean setSelection(SelectionInfo info, boolean notifyDisasm) {
        TIntHashSet selected = new TIntHashSet();
        int max = 0;
        this.mSelection.setNotify(false);
        this.mDeferredSelection = null;
        SourceFile first = info.getSourceFile();
        if (first != null) {
            this.setSourceFile(first, notifyDisasm);
            max = this.mLines.size();
        }
        if (this.mHasSource && !this.mLines.isEmpty()) {
            block0: for (ISourceReference ref : info.getSourceReferences()) {
                int start = ref.getStartLine() - 1;
                if (start <= 0 || start >= max || !selected.add(start) || !(ref instanceof IFunction) && !(ref instanceof ICallPath)) continue;
                IFunction function = this.mFile.getFunction(start + 1);
                int last = start;
                int i = start + 1;
                while (i < max) {
                    IFunction curFunction = this.mFile.getFunction(i + 1);
                    if (function == null) {
                        function = curFunction;
                    }
                    if (function == curFunction) {
                        while (++last <= i) {
                            selected.add(last);
                        }
                        --last;
                    } else if (curFunction != null) continue block0;
                    ++i;
                }
            }
        } else {
            this.mDeferredSelection = info;
        }
        if (!this.mHasSource || first == null || selected.isEmpty()) {
            this.mSelection.deselect();
        } else {
            int low;
            int[] lines = selected.toArray();
            this.mSelection.select(lines, false);
            int high = low = lines[0];
            int[] nArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                int line = nArray[n2];
                if (line < low) {
                    low = line;
                }
                if (line > high) {
                    high = line;
                }
                ++n2;
            }
            this.showLine(high);
            this.showLine(low);
        }
        this.mSelection.setNotify(true);
        this.notifyOfSelectionChange(notifyDisasm);
        return this.mHasSource;
    }

    public void setSourceFile(SourceFile file, boolean notifyDisasm) {
        boolean deselect = this.mFile != file;
        this.mFile = file;
        this.mMsg = null;
        this.mLineCharCount = 0;
        this.mTitle = MessageFormat.format(CodeMessages.SOURCE_FILE, this.mFile != null ? this.mFile.getFullPath() : "");
        this.mHasSource = false;
        this.mLines.clear();
        this.mColorRuns.clear();
        this.mFunctionColorMap.clear();
        if (this.mFile != null && !this.mFile.isBinary()) {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (BufferedReader in = new BufferedReader(new FileReader(this.mFile.getFullPath()));){
                    SourceColorizer colorizer = new SourceColorizer(Colors.getListForeground(), CFamilyKeywordColorData.DATA);
                    String text = in.readLine();
                    while (text != null) {
                        text = TextDrawing.expandTabs(text, 0, 4);
                        this.mLines.add(text);
                        this.mColorRuns.add(colorizer.colorize(text, this.mFile));
                        int length = text.length();
                        if (length > this.mLineCharCount) {
                            this.mLineCharCount = length;
                        }
                        text = in.readLine();
                    }
                    CommonFileUtils.ignoredClose((Closeable)in);
                    ArrayList functions = this.mFile.getFunctions();
                    Collections.sort(functions, new Comparator<IFunction>(){

                        @Override
                        public int compare(IFunction f1, IFunction f2) {
                            int l2;
                            int l1 = f1.getFirstSourceLine();
                            if (l1 < (l2 = f2.getFirstSourceLine())) {
                                return -1;
                            }
                            if (l1 > l2) {
                                return 1;
                            }
                            return f1.compareTo((Object)f2);
                        }
                    });
                    Color functionColor1 = Colors.create(232, 255, 232);
                    Color functionColor2 = Colors.create(232, 232, 255);
                    Color currentColor = functionColor1;
                    for (IFunction function : functions) {
                        int max = function.getLastSourceLine();
                        int i = function.getFirstSourceLine();
                        while (i <= max) {
                            this.mFunctionColorMap.put(i, (Object)currentColor);
                            ++i;
                        }
                        currentColor = currentColor == functionColor1 ? functionColor2 : functionColor1;
                    }
                    this.mHasSource = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                this.setMessage(CodeMessages.MISSING, null);
            }
        } else if (this.mFile == null) {
            this.setMessage(CodeMessages.NO_SOURCE_AVAILABLE, CodeMessages.NO_SOURCE_HINT);
        } else if ("<anonymous>".equals(this.mFile.getName())) {
            this.setMessage(CodeMessages.NO_SOURCE_AVAILABLE, CodeMessages.NO_IMAGE_HINT + "\n\n" + CodeMessages.NO_SOURCE_HINT);
        } else {
            this.setMessage(CodeMessages.NO_SOURCE_AVAILABLE, CodeMessages.NO_SYMBOLS_HINT + "\n\n" + CodeMessages.NO_SOURCE_HINT);
        }
        boolean wasEmpty = this.mSelection.isEmpty();
        this.mSelection.setSize(this.mLines.size());
        if (deselect && !wasEmpty) {
            boolean saved = this.mSelection.canNotify();
            if (!notifyDisasm) {
                this.mSelection.setNotify(false);
            }
            this.mSelection.deselect();
            this.mSelection.setNotify(saved);
        }
        this.updateSizes();
        if (this.mHasSource) {
            SourceFile imageFile = (SourceFile)this.mOwner.getAnalysis().getInstructionCounterModel().getImagesFile().getFiles().get(this.mFile.getImageIndex());
            this.mIsStale = this.mFile.getTimeStamp() != Long.MIN_VALUE && (long)CommonFileUtils.getModifiedTime((String)this.mFile.getFullPath()) > imageFile.getTimeStamp();
        } else {
            this.mIsStale = false;
        }
        if (this.mDeferredSelection != null) {
            this.setSelection(this.mDeferredSelection, true);
        }
    }

    public void showLine(int lineIndex) {
        int max = this.mLines.size();
        if (lineIndex >= 0 && lineIndex < max) {
            int firstLine = this.getFirstVisibleLine();
            int lastLine = this.getLastFullyVisibleLine();
            int pageSize = lastLine - firstLine;
            if (lineIndex < firstLine) {
                this.getVerticalSlider().setSelection(lineIndex);
                this.wasScrolled();
                this.adjustSliders();
            } else if (lineIndex > lastLine) {
                this.getVerticalSlider().setSelection(Math.max(lineIndex - pageSize, 0));
                this.wasScrolled();
                this.adjustSliders();
            }
            this.redraw();
        }
    }

    @Override
    protected Point getPageSize() {
        Rectangle bounds = this.getClientArea();
        return new Point(bounds.width, (bounds.height - 4 - this.mHeaderLineHeight) / this.mLineHeight);
    }

    @Override
    protected void paintCanvas(GC gc) {
        @Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata currentCounter = (CodeTab.InstructionCounterCodeColumnsWithMetadata)this.currentSelectedCounter.getValue();
        @Nullable IInstructionCounterColumn<IInstructionCounterSourcefileView> counterColumn = currentCounter != null ? currentCounter.sourceLineColumn : null;
        ISourcePanelInstructionCounterRenderer renderer = counterColumn != null ? SourcePanelInstructionCounterColumn.create(counterColumn) : null;
        gc.fillRectangle(gc.getClipping());
        if (this.mMsg != null) {
            this.drawMessage(gc);
        } else {
            this.mMsgBounds = null;
            this.drawLines(gc, counterColumn, renderer);
        }
        this.drawHeader(gc, counterColumn);
        this.drawDividers(gc);
        if (this.mMsg != null) {
            this.drawMore(gc);
        }
    }

    private void drawDividers(GC gc) {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int headerHeight = this.mHeaderLineHeight + 4;
        int x = 2;
        int i = 0;
        while (i < 3) {
            if (this.mColumnSizes[i] > 0) {
                gc.setForeground(Colors.getDivider());
                gc.drawLine((x += this.mColumnSizes[i]) + 2, bounds.y, x + 2, bounds.y + headerHeight);
                gc.setForeground(Colors.getOutlineDivider());
                gc.drawLine(x + 2, bounds.y + headerHeight, x + 2, bounds.y + bounds.height);
                x += 5;
            }
            ++i;
        }
    }

    private void drawHeader(GC gc, @Nullable IInstructionCounterColumn<IInstructionCounterSourcefileView> counterColumn) {
        @NonNull String title = counterColumn != null ? counterColumn.getTitle() : "";
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int headerHeight = this.mHeaderLineHeight + 4;
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        gc.setBackground(Colors.getWidgetBackground());
        gc.fillRectangle(x, y, width, headerHeight);
        gc.setForeground(Colors.getDivider());
        y = bounds.y + headerHeight - 1;
        gc.drawLine(x, y, x + width, y);
        x = 2;
        y = bounds.y + 2;
        int col = 0;
        gc.setFont(Fonts.getNormal());
        gc.setForeground(Colors.getWidgetForeground());
        x = this.drawOneHeader(gc, title, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.INFO, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.LINE, x, y, col++);
        if (this.mIsStale) {
            Image image = StreamlinePlugin.getImage("Warning.png");
            gc.drawImage(image, x, y);
            x += image.getBounds().width + 2;
        }
        TextDrawing.drawString(gc, this.mTitle, x, y, 16384);
    }

    private void drawLines(GC gc, @Nullable IInstructionCounterColumn<IInstructionCounterSourcefileView> counterColumn, @Nullable ISourcePanelInstructionCounterRenderer renderer) {
        boolean isFocus = this.isFocusControl();
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int lastLine = this.getLastVisibleLine();
        int y = this.toVirtual((Point)new Point((int)0, (int)(this.mHeaderLineHeight + 4))).y;
        Font font = Fonts.getSource();
        FontInfo fi = FontInfo.get(font);
        gc.setFont(font);
        int textYOffset = (this.mLineHeight - fi.getHeight()) / 2;
        @Nullable SourceFile sourceFile = this.mFile;
        IInstructionCounterSourcefileViews views = counterColumn != null ? counterColumn.getInstructionCounterSource().getSourcefileViews() : null;
        int index = this.getFirstVisibleLine();
        while (index <= lastLine) {
            IInstructionCounterSourcefileView view;
            int x = 2;
            int col = 0;
            boolean isInlined = this.isInlined(index);
            if (views != null && renderer != null && !isInlined && sourceFile != null && (view = views.getSourceLineView(sourceFile, index + 1)) != null) {
                renderer.render(view, gc, font, 2, x, y, this.mColumnSizes[col], this.mLineHeight);
            }
            x += this.mColumnSizes[col++] + 5;
            if (isInlined) {
                gc.drawImage(this.mInlineImage, x, y);
            }
            x += this.mColumnSizes[col++] + 5;
            gc.setForeground(Colors.getBlack());
            Color color = (Color)this.mFunctionColorMap.get(index + 1);
            if (color != null) {
                gc.setBackground(color);
                gc.fillRectangle(x - 2, y, 2 + this.mColumnSizes[col] + 2, this.mLineHeight);
            }
            String lineNum = NumberUtils.format((long)(index + 1));
            TextDrawing.drawString(gc, lineNum, x + this.mColumnSizes[col], y + textYOffset, 131072);
            x += this.mColumnSizes[col++] + 5;
            String text = this.mLines.get(index);
            if (this.mSelection.isSelected(index)) {
                gc.setBackground(Colors.getSelection(isFocus));
                gc.fillRectangle(x - 2, y, bounds.x + bounds.width - (x - 2), this.mLineHeight);
                gc.setForeground(Colors.getText(isFocus));
                TextDrawing.drawString(gc, text, x, y + textYOffset, 16384);
            } else {
                int pos = 0;
                ColorRun[] colorRunArray = this.mColorRuns.get(index);
                int n = colorRunArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ColorRun colorRun = colorRunArray[n2];
                    gc.setForeground(colorRun.mColor);
                    String piece = text.substring(pos, colorRun.mUpTo);
                    TextDrawing.drawString(gc, piece, x, y + textYOffset, 16384);
                    pos = colorRun.mUpTo;
                    x += fi.getWidth(piece);
                    ++n2;
                }
            }
            y += this.mLineHeight;
            ++index;
        }
    }

    private void drawMessage(GC gc) {
        Point hintSize;
        int gap;
        Rectangle bounds = this.getClientArea();
        int header = this.mHeaderLineHeight + 4;
        bounds.y += header;
        bounds.height -= header;
        this.toVirtual(bounds);
        Font font = Fonts.getNormalStandout();
        gc.setFont(font);
        FontInfo fontInfo = FontInfo.get(font);
        Point size = fontInfo.getExtent(this.mMsg);
        String hint = this.mMsgHint;
        if (hint == null) {
            gap = 10;
            hintSize = new Point(0, 0);
        } else {
            gap = 20;
            hint = BasicTextFilter.wrap((String)hint, (int)50);
            hintSize = fontInfo.getExtent(hint);
        }
        boolean clickable = this.isMsgClickable();
        gc.setForeground(clickable ? Colors.getDarkRed() : Colors.getGray());
        int y = bounds.y + (bounds.height - (size.y + gap + hintSize.y)) / 2;
        TextDrawing.drawText(gc, this.mMsg, bounds.x + (bounds.width - size.x) / 2, y, 16384);
        y += size.y + 10;
        if (hint != null) {
            gc.setForeground(Colors.getGray());
            TextDrawing.drawText(gc, hint, bounds.x + (bounds.width - hintSize.x) / 2, y, 16384);
            y += hintSize.y + 10;
        }
        if (clickable) {
            Point clickSize = fontInfo.getExtent(CodeMessages.CLICK_HERE);
            gc.setForeground(Colors.getBlue());
            this.mMsgBounds = new Rectangle(bounds.x + (bounds.width - clickSize.x) / 2, y, clickSize.x, clickSize.y);
            TextDrawing.drawText(gc, CodeMessages.CLICK_HERE, this.mMsgBounds.x, this.mMsgBounds.y, 16384);
            gc.drawLine(this.mMsgBounds.x, this.mMsgBounds.y + this.mMsgBounds.height, this.mMsgBounds.x + this.mMsgBounds.width, this.mMsgBounds.y + this.mMsgBounds.height);
            this.fromVirtual(this.mMsgBounds);
        } else {
            this.mMsgBounds = new Rectangle(0, 0, 0, 0);
        }
    }

    private void drawMore(GC gc) {
        if (!this.mSelection.isEmpty()) {
            int remaining = this.mSelection.getCountOfSelectedIndexesBefore(this.getFirstVisibleLine());
            if (remaining > 0) {
                this.drawMore(gc, true, remaining);
            } else {
                this.mMoreUpArea.width = 0;
            }
            remaining = this.mSelection.getCountOfSelectedIndexesAfter(this.getLastFullyVisibleLine());
            if (remaining > 0) {
                this.drawMore(gc, false, remaining);
            } else {
                this.mMoreDownArea.width = 0;
            }
        } else {
            this.mMoreUpArea.width = 0;
            this.mMoreDownArea.width = 0;
        }
    }

    private void drawMore(GC gc, boolean up, int amt) {
        Rectangle clientArea = this.toVirtual(this.getClientArea());
        Image img = StreamlinePlugin.getImage(up ? StreamlineImages.UP_ARROW : StreamlineImages.DOWN_ARROW);
        Rectangle imgBounds = img.getBounds();
        Font font = Fonts.getSmall();
        gc.setFont(font);
        String text = MessageFormat.format(CodeMessages.MORE, NumberUtils.format((long)amt));
        FontInfo fontInfo = FontInfo.get(font);
        int fontHeight = fontInfo.getHeight();
        int w = 4 + fontInfo.getWidth(text) + 4 + imgBounds.width + 4;
        int x = clientArea.x + clientArea.width - (w + 4);
        int h = Math.max(imgBounds.height, fontHeight) + 0;
        int y = clientArea.y + (up ? this.mHeaderLineHeight + 4 + 4 : clientArea.height - (h + 4));
        if (up) {
            this.mMoreUpArea.x = x;
            this.mMoreUpArea.y = y;
            this.mMoreUpArea.width = w + 1;
            this.mMoreUpArea.height = h + 1;
        } else {
            this.mMoreDownArea.x = x;
            this.mMoreDownArea.y = y;
            this.mMoreDownArea.width = w + 1;
            this.mMoreDownArea.height = h + 1;
        }
        gc.setBackground(Colors.getInfoBackground());
        gc.fillRectangle(x, y, w, h);
        gc.setForeground(Colors.getBlack());
        gc.drawRectangle(x, y, w, h);
        gc.setForeground(Colors.getInfoForeground());
        TextDrawing.drawString(gc, text, x + 4, y + 1 + (h - fontHeight) / 2, 16384);
        gc.drawImage(img, x + w - (imgBounds.width + 4), y + (h - imgBounds.height) / 2);
    }

    private int drawOneHeader(GC gc, String title, int x, int y, int col) {
        if (this.mColumnSizes[col] > 0) {
            TextDrawing.drawString(gc, title, x + this.mColumnSizes[col] / 2, y, 0x1000000);
            x += this.mColumnSizes[col] + 5;
        }
        return x;
    }

    private @NonNull Analysis getAnalysis() {
        return this.mOwner.getAnalysis();
    }

    private int getLineIndexAt(int virtualY) {
        int top = this.toVirtual((Point)new Point((int)0, (int)(this.mHeaderLineHeight + 4))).y;
        int line = (virtualY - top) / this.mLineHeight;
        if (line < 0) {
            return -1;
        }
        if ((line += this.getFirstVisibleLine()) >= this.mLines.size()) {
            return -1;
        }
        return line;
    }

    private boolean isInlined(int line) {
        return this.mFile.isInlined(line + 1);
    }

    private boolean isMsgClickable() {
        return CodeMessages.MISSING.equals(this.mMsg);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void locateSourceFile() {
        Shell shell;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null && (shell = window.getShell()) != null) {
            String newPath;
            String path;
            FileDialog dialog = new FileDialog(shell, 69632);
            @NonNull String fullPath = this.mFile.getFullPath();
            @NonNull String name = (String)NullChecking.neverNull((Object)FilePath.getLeafName((String)fullPath));
            dialog.setText(MessageFormat.format(CodeMessages.LOCATE_SOURCE_FILE_TITLE, name));
            dialog.setFileName(name);
            String oldPath = (String)NullChecking.neverNull((Object)FilePath.getParent((String)fullPath, (boolean)false));
            if (!oldPath.isEmpty()) {
                dialog.setFilterPath(oldPath);
            }
            if ((path = dialog.open()) != null && !(newPath = FilePath.getParent((String)path, (boolean)false)).equals(oldPath)) {
                while (((String)NullChecking.neverNull((Object)FilePath.getLeafName((String)newPath))).equals(FilePath.getLeafName((String)oldPath))) {
                    newPath = (String)NullChecking.neverNull((Object)FilePath.getParent((String)newPath, (boolean)false));
                    oldPath = (String)NullChecking.neverNull((Object)FilePath.getParent((String)oldPath, (boolean)false));
                }
                @NonNull Analysis analysis = this.getAnalysis();
                @NonNull PathSubstitutionsFile pathSubstitutionsFile = analysis.getPathSubstitutionsFile();
                @NonNull @NonNull @NonNull Map substitutions = pathSubstitutionsFile.getPathSubstitutions();
                substitutions.put(oldPath, newPath);
                pathSubstitutionsFile.save();
                analysis.notifyOfSourceFilePathChange(analysis.getInstructionCounterModel().getImagesFile().getFiles().toArray(new SourceFile[0]));
                System.out.println(PathSubstitutionsFile.adjustPathForSubstitutions((String)fullPath, (Map)substitutions));
                if (!new File(PathSubstitutionsFile.adjustPathForSubstitutions((String)fullPath, (Map)substitutions)).exists()) {
                    Error.show(CodeMessages.BAD_SUBSTITION_MESSAGE);
                    return;
                }
            }
        }
    }

    private void notifyOfSelectionChange(boolean notifyDisasm) {
        ISelection selection = this.getSelection();
        if (notifyDisasm) {
            this.mOwner.getDisassemblyPanel().setSelection(selection, false);
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        ISelectionChangedListener[] iSelectionChangedListenerArray = this.mSelectionListeners.toArray(new ISelectionChangedListener[this.mSelectionListeners.size()]);
        int n = iSelectionChangedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionChangedListener listener = iSelectionChangedListenerArray[n2];
            listener.selectionChanged(event);
            ++n2;
        }
    }

    private void refocus() {
        this.computeSize(-1, -1);
        this.getHorizontalSlider().setIncrement(this.mCharWidth);
        this.adjustSliders();
        Slider slider = this.getVerticalSlider();
        int max = slider.getMaximum();
        int current = slider.getSelection();
        if (current > max) {
            slider.setSelection(max);
            this.wasScrolled();
            this.adjustSliders();
        }
        this.redraw();
    }

    private void scrollMoreDown() {
        int first;
        int max = this.getPageSize().y;
        int last = first = this.mSelection.nextSelectedIndex(this.getLastFullyVisibleLine() + 1);
        int index = first;
        while ((index = this.mSelection.nextSelectedIndex(index + 1)) != -1 && index - first <= max) {
            last = index;
        }
        this.showLine(last);
        this.showLine(first);
    }

    private void scrollMoreUp() {
        int rangeEnd;
        int rangeStart;
        int first = this.getFirstVisibleLine();
        int index = -1;
        TIntArrayList list = new TIntArrayList();
        while ((index = this.mSelection.nextSelectedIndex(index + 1)) != -1 && index < first) {
            list.add(index);
        }
        int max = this.getPageSize().y;
        int last = list.size() - 1;
        first = rangeStart = (rangeEnd = list.get(last--));
        while (last >= 0) {
            if (rangeEnd - (first = list.get(last--)) > max) break;
            rangeStart = first;
        }
        this.showLine(rangeEnd);
        this.showLine(rangeStart);
    }

    private void setMessage(String msg, String hint) {
        this.mHasSource = false;
        this.mLineCharCount = 0;
        this.mLines.clear();
        this.mColorRuns.clear();
        this.mFunctionColorMap.clear();
        this.mMsg = msg;
        this.mMsgHint = hint;
    }

    private void updateSizes() {
        this.updateSizesNoRefocus();
        ConsolidatedUIExec.exec(this, null, this, false);
    }

    private void updateSizesNoRefocus() {
        Font font = Fonts.getSource();
        FontInfo fontInfo = FontInfo.get(font);
        this.mCharWidth = fontInfo.getMaxWidth();
        this.mLineHeight = Math.max(fontInfo.getHeight(), this.mInlineImage.getBounds().height);
        this.mHeaderLineHeight = FontInfo.get(Fonts.getNormal()).getHeight();
    }

    private static enum MouseState {
        MORE_DOWN,
        MORE_UP,
        NORMAL;

    }

    private class SelectionInfo {
        private List<ISourceReference> mSourceReferences = new ArrayList<ISourceReference>();

        SelectionInfo(ISelection selection) {
            ISourceReference ref2;
            SourceFile first = null;
            for (ISourceReference ref2 : new SourceReferenceSelectionIterator(selection)) {
                SourceFile file = ref2.getSourceFile();
                if (first == null) {
                    first = file;
                }
                if (first != file) continue;
                this.mSourceReferences.add(ref2);
            }
            if (!SourcePanel.this.mOwner.isStillInInitialFocus() && !this.mSourceReferences.isEmpty() && (ref2 = this.mSourceReferences.get(0)) instanceof IFunction) {
                IFunction function = (IFunction)ref2;
                SourcePanel.this.mFunctionLRUCache.put((Object)function, (Object)function);
                SourcePanel.this.mOwner.getRecentFunctionsAction().setEnabled(true);
            }
        }

        SourceFile getSourceFile() {
            return this.mSourceReferences.isEmpty() ? null : this.mSourceReferences.get(0).getSourceFile();
        }

        List<ISourceReference> getSourceReferences() {
            return this.mSourceReferences;
        }
    }
}

