/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.editortabs.code.DisasmPanelInstructionCounterColumn;
import com.arm.streamline.editortabs.code.IDisasmPanelInstructionCounterRenderer;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.FilteredInstructionsFile;
import com.arm.streamline.model.iterable.InstructionIndexSelectionIterator;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.utility.text.DisassemblyRenderer;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.ConsolidatedUIExec;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.IAutoScrollArea;
import com.arm.streamline.widget.IToolTipTracker;
import com.arm.streamline.widget.LineScrollCanvas;
import com.arm.streamline.widget.UpdatingToolTip;
import com.arm.streamline.widget.outline.PercentageCell;
import com.arm.utils.NullChecking;
import gnu.trove.list.array.TIntArrayList;
import java.text.MessageFormat;
import java.util.BitSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;

public class DisasmPanel
extends LineScrollCanvas
implements IToolTipTracker,
IAutoScrollArea,
MouseListener,
MouseMoveListener,
KeyListener,
Runnable {
    protected static final int MARGIN = 2;
    private static final int COL_ADDRESS = 2;
    private static final int COL_COUNTER_VALUE = 0;
    private static final int COL_DISASM = 4;
    private static final int COL_FILE = 5;
    private static final int COL_INLINE = 1;
    private static final int COL_OPCODE = 3;
    private static final int COL_TOTAL = 6;
    private static final int GAP = 5;
    private static final int MORE_H_MARGIN = 4;
    private static final int MORE_OFFSET = 4;
    private static final int MORE_V_MARGIN = 0;
    private final @NonNull IObservableValue<@Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata> currentSelectedCounter;
    private final @NonNull IValueChangeListener<@Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata> currentSelectedCounterListener;
    private int mCharWidth;
    private final int @NonNull [] mColumnSizes = new int[6];
    private int mHeaderLineHeight;
    private int mLastSelection = -1;
    private int mLineHeight;
    private final Rectangle mMoreDownArea = new Rectangle(0, 0, 0, 0);
    private final Rectangle mMoreUpArea = new Rectangle(0, 0, 0, 0);
    private boolean mMouseDown;
    private @NonNull MouseState mMouseHandlingState = MouseState.NORMAL;
    final @NonNull IInstructionsFile filteredInstructions;
    final @NonNull Image mInlineImage;
    final @NonNull CodeTab mOwner;
    final @NonNull BitSet mSelection;

    private static int getBestSize(String header, int contentWidth) {
        return Math.max(FontInfo.get(Fonts.getNormal()).getWidth(header), contentWidth);
    }

    private static int getBestSize(String header, String content) {
        return DisasmPanel.getBestSize(header, FontInfo.get(Fonts.getSource()).getWidth(content));
    }

    public DisasmPanel(@NonNull Composite parent, @NonNull CodeTab owner, @NonNull IObservableValue<@Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata> currentSelectedCounter) {
        super(parent);
        ControlHacks.setBackground((Control)this, Colors.getWhite());
        this.filteredInstructions = FilteredInstructionsFile.filterScriptAndUnknownFunctions(owner.getAnalysis().getInstructionCounterModel().getInstructionsFile());
        this.mOwner = owner;
        this.mSelection = new BitSet(this.filteredInstructions.getCount());
        this.mInlineImage = (Image)NullChecking.neverNull((Object)StreamlinePlugin.getImage("InlinedHere.png"));
        this.updateSizes();
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        UpdatingToolTip.create((Control)this, this);
        this.currentSelectedCounter = currentSelectedCounter;
        this.currentSelectedCounterListener = event -> this.redraw();
        currentSelectedCounter.addValueChangeListener(this.currentSelectedCounterListener);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.updateColumnSizes();
        int width = 4 + 5 * (this.mColumnSizes.length - 1);
        int[] nArray = this.mColumnSizes;
        int n = this.mColumnSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int columnSize = nArray[n2];
            width += columnSize;
            ++n2;
        }
        int extraRows = (this.getSliderSize().y + this.mLineHeight - 1) / this.mLineHeight;
        return new Point(width, this.filteredInstructions.getCount() + extraRows);
    }

    public void dispose() {
        this.currentSelectedCounter.removeValueChangeListener(this.currentSelectedCounterListener);
        super.dispose();
    }

    @Override
    public Rectangle getAutoScrollArea() {
        Rectangle bounds = this.getClientArea();
        bounds.y += this.mHeaderLineHeight;
        bounds.height -= this.mHeaderLineHeight;
        return bounds;
    }

    public int getFirstVisibleLine() {
        return this.getVerticalSlider().getSelection();
    }

    public int getLastFullyVisibleLine() {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int line = (bounds.height - (this.mHeaderLineHeight + 2)) / this.mLineHeight;
        if (line % this.mLineHeight != 0) {
            --line;
        }
        if ((line += this.getFirstVisibleLine()) < 0) {
            return -1;
        }
        return Math.min(line, this.filteredInstructions.getCount() - 1);
    }

    public int getLastVisibleLine() {
        return Math.min(this.getFirstVisibleLine() + this.getPageSize().y, this.filteredInstructions.getCount() - 1);
    }

    @Override
    public String getToolTipForLocation(Point location) {
        int x1 = 0;
        int i = 0;
        while (i < 1) {
            x1 += this.mColumnSizes[i] + 5;
            ++i;
        }
        int x2 = x1 + this.mColumnSizes[1] + 5;
        Point pt = this.toVirtual(new Point(location.x, location.y));
        if (pt.x >= x1 && pt.x <= x2) {
            if (location.y < this.mHeaderLineHeight + 2) {
                return CodeMessages.INFO_HEADER_TOOLTIP;
            }
            int line = this.getLineIndexAt(pt.y);
            if (line > -1 && IInstructionsFile.isInlined((IInstructionsFile)this.filteredInstructions, (int)line)) {
                return CodeMessages.DISASM_INLINE_TOOLTIP;
            }
        }
        if (location.y < this.mHeaderLineHeight + 2) {
            x1 = 0;
            int i2 = 0;
            while (i2 < 0) {
                x1 += this.mColumnSizes[i2] + 5;
                ++i2;
            }
            x2 = x1 + this.mColumnSizes[0] + 5;
            pt = this.toVirtual(new Point(location.x, location.y));
            if (pt.x >= x1 && pt.x <= x2) {
                @Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata currentColumn = (CodeTab.InstructionCounterCodeColumnsWithMetadata)this.currentSelectedCounter.getValue();
                if (currentColumn != null) {
                    return currentColumn.instructionColumn.getTitleTooltip();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isAutoScrollMouseDown(int x, int y) {
        return this.getAutoScrollArea().contains(x, y);
    }

    public void keyPressed(KeyEvent event) {
        if (event.doit) {
            event.doit = false;
            switch (event.keyCode) {
                case 0x1000001: {
                    if (--this.mLastSelection < 0) {
                        this.mLastSelection = this.filteredInstructions.getCount() - 1;
                    }
                    this.selectLine(this.mLastSelection);
                    this.showLine(this.mLastSelection);
                    break;
                }
                case 0x1000002: {
                    if (++this.mLastSelection >= this.filteredInstructions.getCount()) {
                        this.mLastSelection = 0;
                    }
                    this.selectLine(this.mLastSelection);
                    this.showLine(this.mLastSelection);
                    break;
                }
                case 0x1000007: {
                    this.selectLine(0);
                    this.showLine(this.mLastSelection);
                    break;
                }
                case 0x1000008: {
                    this.selectLine(this.filteredInstructions.getCount() - 1);
                    this.showLine(this.mLastSelection);
                    break;
                }
                case 0x1000005: {
                    this.setScrollPosition(this.getVerticalSlider().getSelection() - Math.max(1, this.getPageSize().y - 1));
                    break;
                }
                case 0x1000006: {
                    this.setScrollPosition(this.getVerticalSlider().getSelection() + Math.max(1, this.getPageSize().y - 1));
                    break;
                }
                default: {
                    event.doit = true;
                }
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        this.setFocus();
        if (this.mMoreUpArea.contains(event.x, event.y)) {
            this.mMouseHandlingState = MouseState.MORE_UP;
        } else if (this.mMoreDownArea.contains(event.x, event.y)) {
            this.mMouseHandlingState = MouseState.MORE_DOWN;
        } else {
            this.mMouseHandlingState = MouseState.NORMAL;
            this.mMouseDown = true;
            this.selectLine(this.getLineIndexAt(this.toVirtual((Point)new Point((int)0, (int)event.y)).y));
        }
    }

    public void mouseMove(MouseEvent event) {
        if (this.mMouseDown) {
            this.mouseDown(event);
        }
    }

    public void mouseUp(MouseEvent event) {
        this.mMouseDown = false;
        if (this.mMoreUpArea.contains(event.x, event.y)) {
            if (this.mMouseHandlingState == MouseState.MORE_UP) {
                this.scrollMoreUp();
            }
        } else if (this.mMoreDownArea.contains(event.x, event.y) && this.mMouseHandlingState == MouseState.MORE_DOWN) {
            this.scrollMoreDown();
        }
        this.mMouseHandlingState = MouseState.NORMAL;
    }

    @Override
    public void run() {
        if (!this.isDisposed()) {
            this.refocus();
        }
    }

    public void setSelection(ISelection selection, boolean syncSource) {
        this.mSelection.clear();
        for (BitSet set : new InstructionIndexSelectionIterator(selection)) {
            this.mSelection.or(set);
        }
        this.mLastSelection = this.mSelection.nextSetBit(0);
        int last = this.mSelection.length() - 1;
        this.showLine(last);
        this.showLine(this.mLastSelection - 1);
        if (syncSource) {
            this.mOwner.getSourcePanel().setSelection(selection, false);
        }
        this.redraw();
    }

    public void showLine(int lineIndex) {
        int max = this.filteredInstructions.getCount();
        if (lineIndex >= 0 && lineIndex < max) {
            int firstLine = this.getFirstVisibleLine();
            int lastLine = this.getLastFullyVisibleLine();
            int pageSize = lastLine - firstLine;
            if (lineIndex < firstLine) {
                this.getVerticalSlider().setSelection(lineIndex);
                this.wasScrolled();
                this.adjustSliders();
            } else if (lineIndex > lastLine) {
                this.getVerticalSlider().setSelection(Math.max(lineIndex - pageSize, 0));
                this.wasScrolled();
                this.adjustSliders();
            }
            this.redraw();
        }
    }

    @Override
    protected Point getPageSize() {
        Rectangle bounds = this.getClientArea();
        return new Point(bounds.width, (bounds.height - 2 - this.mHeaderLineHeight) / this.mLineHeight);
    }

    @Override
    protected void paintCanvas(GC gc) {
        @Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata currentColumnTuple = (CodeTab.InstructionCounterCodeColumnsWithMetadata)this.currentSelectedCounter.getValue();
        @Nullable IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> currentColumn = currentColumnTuple != null ? currentColumnTuple.instructionColumn : null;
        gc.fillRectangle(gc.getClipping());
        this.drawLines(gc, currentColumn);
        this.drawHeader(gc, currentColumn);
        this.drawDividers(gc);
        this.drawMore(gc);
    }

    private void drawDividers(GC gc) {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int headerHeight = this.mHeaderLineHeight + 2;
        int x = 2;
        int i = 0;
        while (i < 5) {
            if (this.mColumnSizes[i] > 0) {
                gc.setForeground(Colors.getDivider());
                gc.drawLine((x += this.mColumnSizes[i]) + 2, bounds.y, x + 2, bounds.y + headerHeight);
                gc.setForeground(Colors.getOutlineDivider());
                gc.drawLine(x + 2, bounds.y + headerHeight, x + 2, bounds.y + bounds.height);
                x += 5;
            }
            ++i;
        }
    }

    private void drawHeader(GC gc, @Nullable IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> counterColumn) {
        @NonNull String title = counterColumn != null ? counterColumn.getTitle() : "";
        Rectangle bounds = this.toVirtual(this.getClientArea());
        int headerHeight = this.mHeaderLineHeight + 2;
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        gc.setBackground(Colors.getWidgetBackground());
        gc.fillRectangle(x, y, width, headerHeight);
        gc.setForeground(Colors.getDivider());
        y = bounds.y + headerHeight - 1;
        gc.drawLine(x, y, x + width, y);
        x = 2;
        y = bounds.y;
        int col = 0;
        gc.setFont(Fonts.getNormal());
        gc.setForeground(Colors.getWidgetForeground());
        x = this.drawOneHeader(gc, title, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.INFO, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.ADDRESS, x, y, col++);
        x = this.drawOneHeader(gc, CodeMessages.OPCODE, x, y, col++);
        TextDrawing.drawString(gc, CodeMessages.DISASM, x, y, 16384);
        TextDrawing.drawString(gc, CodeMessages.FILE, x += this.mColumnSizes[col++] + 5, y, 16384);
    }

    private void drawLines(GC gc, @Nullable IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> counterColumn) {
        @Nullable IDisasmPanelInstructionCounterRenderer renderer = counterColumn != null ? DisasmPanelInstructionCounterColumn.create(counterColumn) : null;
        @NonNull Rectangle bounds = this.getClientArea();
        this.toVirtual(bounds);
        int lastLine = this.getLastVisibleLine();
        @NonNull Font font = (Font)NullChecking.neverNull((Object)Fonts.getSource());
        gc.setFont(font);
        @NonNull FontInfo fi = FontInfo.get(font);
        int textYOffset = (this.mLineHeight - fi.getHeight()) / 2;
        int y = this.toVirtual((Point)new Point((int)0, (int)(this.mHeaderLineHeight + 2))).y;
        int index = this.getFirstVisibleLine();
        while (index <= lastLine) {
            gc.setBackground(Colors.getWhite());
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IInstructionsFile.IInstructionsFileEntry entry = this.filteredInstructions.getEntry(index);
            entry.accept((IInstructionsFile.IInstructionsFileEntryVisitor)new DrawLinesEntryVisitor(gc, bounds, this.mSelection, y, textYOffset, this.mLineHeight, this.mColumnSizes, this.mInlineImage, font, renderer), null);
            if (index == this.mLastSelection) {
                gc.setForeground(Colors.getGray());
                gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
                gc.drawLine(bounds.x, y + this.mLineHeight - 1, bounds.x + bounds.width, y + this.mLineHeight - 1);
            }
            y += this.mLineHeight;
            ++index;
        }
    }

    private void drawMore(GC gc) {
        if (!this.mSelection.isEmpty()) {
            int remaining = this.getCountOfSelectedIndexesBefore(this.getFirstVisibleLine());
            if (remaining > 0) {
                this.drawMore(gc, true, remaining);
            } else {
                this.mMoreUpArea.width = 0;
            }
            remaining = this.getCountOfSelectedIndexesAfter(this.getLastFullyVisibleLine());
            if (remaining > 0) {
                this.drawMore(gc, false, remaining);
            } else {
                this.mMoreDownArea.width = 0;
            }
        } else {
            this.mMoreUpArea.width = 0;
            this.mMoreDownArea.width = 0;
        }
    }

    private void drawMore(GC gc, boolean up, int amt) {
        Rectangle clientArea = this.toVirtual(this.getClientAreaExcludingSliders());
        Image img = StreamlinePlugin.getImage(up ? StreamlineImages.UP_ARROW : StreamlineImages.DOWN_ARROW);
        Rectangle imgBounds = img.getBounds();
        Font font = Fonts.getSmall();
        gc.setFont(font);
        String text = MessageFormat.format(CodeMessages.MORE, NumberUtils.format((long)amt));
        FontInfo fontInfo = FontInfo.get(font);
        int fontHeight = fontInfo.getHeight();
        int w = 4 + fontInfo.getWidth(text) + 4 + imgBounds.width + 4;
        int x = clientArea.x + clientArea.width - (w + 4);
        int h = Math.max(imgBounds.height, fontHeight) + 0;
        int y = clientArea.y + (up ? this.mHeaderLineHeight + 4 : clientArea.height - (h + 4));
        if (up) {
            this.mMoreUpArea.x = x;
            this.mMoreUpArea.y = y;
            this.mMoreUpArea.width = w + 1;
            this.mMoreUpArea.height = h + 1;
        } else {
            this.mMoreDownArea.x = x;
            this.mMoreDownArea.y = y;
            this.mMoreDownArea.width = w + 1;
            this.mMoreDownArea.height = h + 1;
        }
        gc.setBackground(Colors.getInfoBackground());
        gc.fillRectangle(x, y, w, h);
        gc.setForeground(Colors.getBlack());
        gc.drawRectangle(x, y, w, h);
        gc.setForeground(Colors.getInfoForeground());
        TextDrawing.drawString(gc, text, x + 4, y + 1 + (h - fontHeight) / 2, 16384);
        gc.drawImage(img, x + w - (imgBounds.width + 4), y + (h - imgBounds.height) / 2);
    }

    private int drawOneHeader(GC gc, String title, int x, int y, int col) {
        if (this.mColumnSizes[col] > 0) {
            TextDrawing.drawString(gc, title, x + this.mColumnSizes[col] / 2, y, 0x1000000);
            x += this.mColumnSizes[col] + 5;
        }
        return x;
    }

    private int getCountOfSelectedIndexesAfter(int afterIndex) {
        int count = 0;
        int index = afterIndex;
        while ((index = this.mSelection.nextSetBit(index + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private int getCountOfSelectedIndexesBefore(int beforeIndex) {
        int count = 0;
        int index = -1;
        while ((index = this.mSelection.nextSetBit(index + 1)) != -1 && index < beforeIndex) {
            ++count;
        }
        return count;
    }

    private int getLineIndexAt(int virtualY) {
        int top = this.toVirtual((Point)new Point((int)0, (int)(this.mHeaderLineHeight + 2))).y;
        int line = (virtualY - top) / this.mLineHeight;
        if (line < 0) {
            return -1;
        }
        if ((line += this.getFirstVisibleLine()) >= this.filteredInstructions.getCount()) {
            return -1;
        }
        return line;
    }

    private void refocus() {
        this.getHorizontalSlider().setIncrement(this.mCharWidth);
        this.adjustSliders();
        Slider slider = this.getVerticalSlider();
        int max = slider.getMaximum();
        int current = slider.getSelection();
        if (current > max) {
            slider.setSelection(max);
            this.wasScrolled();
            this.adjustSliders();
        }
        this.redraw();
    }

    private void scrollMoreDown() {
        int first;
        int max = this.getPageSize().y;
        int last = first = this.mSelection.nextSetBit(this.getLastFullyVisibleLine());
        int index = first;
        while ((index = this.mSelection.nextSetBit(index + 1)) != -1 && index - first <= max) {
            last = index;
        }
        this.showLine(last);
        this.showLine(first);
        this.mLastSelection = first;
    }

    private void scrollMoreUp() {
        int rangeEnd;
        int rangeStart;
        int first = this.getFirstVisibleLine();
        int index = -1;
        TIntArrayList list = new TIntArrayList();
        while ((index = this.mSelection.nextSetBit(index + 1)) != -1 && index < first) {
            list.add(index);
        }
        int max = this.getPageSize().y;
        int last = list.size() - 1;
        first = rangeStart = (rangeEnd = list.get(last--));
        while (last >= 0) {
            if (rangeEnd - (first = list.get(last--)) > max) break;
            rangeStart = first;
        }
        this.showLine(rangeEnd);
        this.showLine(rangeStart);
        this.mLastSelection = rangeStart;
    }

    private void selectLine(final int line) {
        this.mSelection.clear();
        this.mLastSelection = line;
        if (line >= 0) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IInstructionsFile.IInstructionsFileEntry entry = this.filteredInstructions.getEntry(line);
            entry.accept((IInstructionsFile.IInstructionsFileEntryVisitor)new IInstructionsFile.IInstructionsFileEntryVisitor<Void, Void, RuntimeException>(){

                public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IInstructionsFile.IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
                    return null;
                }

                public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IInstructionsFile.IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
                    IFunction function = entry.getFunction();
                    DisasmPanel.this.mSelection.set(line + 1, function.getLastInstructionIndex() + 1);
                    DisasmPanel.this.mOwner.getSourcePanel().setSelection((ISelection)new StructuredSelection((Object)function), false);
                    return null;
                }

                public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IInstructionsFile.IInstructionsFileInstructionEntry entry, Void data) throws RuntimeException {
                    final @Nullable SourceFile srcFile = entry.getSourceFile();
                    final int lineIndex = entry.getLine();
                    @NonNull IFunction function = entry.getFunction().getFunction();
                    int last = function.getLastInstructionIndex();
                    int i = function.getFirstInstructionIndex() + 1;
                    while (i <= last) {
                        // Could not load outer class - annotation placement on inner may be incorrect
                        @NonNull IInstructionsFile.IInstructionsFileEntry otherEntry = DisasmPanel.this.filteredInstructions.getEntry(i);
                        otherEntry.accept((IInstructionsFile.IInstructionsFileEntryVisitor)new IInstructionsFile.IInstructionsFileEntryVisitor<Void, Void, RuntimeException>(){

                            public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
                            @NonNull IInstructionsFile.IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
                                return null;
                            }

                            public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
                            @NonNull IInstructionsFile.IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
                                return null;
                            }

                            public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
                            @NonNull IInstructionsFile.IInstructionsFileInstructionEntry otherInstructionEntry, Void data) throws RuntimeException {
                                if (otherInstructionEntry.getSourceFile() == srcFile && otherInstructionEntry.getLine() == lineIndex) {
                                    (this).DisasmPanel.this.mSelection.set(otherInstructionEntry.getIndex());
                                }
                                return null;
                            }
                        }, null);
                        ++i;
                    }
                    DisasmPanel.this.mOwner.getSourcePanel().setSelection((ISelection)new StructuredSelection((Object)entry.createSourceReference()), false);
                    return null;
                }
            }, null);
        }
        this.redraw();
    }

    private void setScrollPosition(int pos) {
        int max;
        if (pos < 0) {
            pos = 0;
        }
        if (pos > (max = this.getVerticalSlider().getMaximum())) {
            pos = max;
        }
        this.getVerticalSlider().setSelection(pos);
        this.wasScrolled();
        this.adjustSliders();
        this.redraw();
    }

    private void updateColumnSizes() {
        @NonNull Analysis analysis = this.mOwner.getAnalysis();
        @Nullable CodeTab.InstructionCounterCodeColumnsWithMetadata currentCounter = NullChecking.nullable(this.currentSelectedCounter) != null ? (CodeTab.InstructionCounterCodeColumnsWithMetadata)this.currentSelectedCounter.getValue() : null;
        @NonNull String counterTitle = currentCounter != null ? currentCounter.instructionColumn.getTitle() : "";
        this.mColumnSizes[0] = DisasmPanel.getBestSize(counterTitle, PercentageCell.getMinimumContentWidth(Fonts.getSource(), false) + 50);
        this.mColumnSizes[1] = this.mInlineImage.getBounds().width;
        this.mColumnSizes[2] = DisasmPanel.getBestSize(CodeMessages.ADDRESS, this.filteredInstructions.has64BitAddresses() ? NumberUtils.formatAddress((long)-1L) : NumberUtils.formatAddress((int)-1));
        this.mColumnSizes[3] = DisasmPanel.getBestSize(CodeMessages.OPCODE, NumberUtils.formatHex((int)-1, (int)8, (boolean)false));
        this.mColumnSizes[4] = DisasmPanel.getBestSize(CodeMessages.DISASM, (analysis.getInstructionCounterModel().getLargestFunctionName().length() + 50) * this.mCharWidth);
        this.mColumnSizes[5] = DisasmPanel.getBestSize(CodeMessages.FILE, (analysis.getInstructionCounterModel().getImagesFile().getLargestFileName().length() + 6) * this.mCharWidth);
    }

    private void updateSizes() {
        Font font = Fonts.getSource();
        this.mCharWidth = FontInfo.get(font).getMaxWidth();
        this.mLineHeight = Math.max(FontInfo.get(font).getHeight(), this.mInlineImage.getBounds().height);
        this.mHeaderLineHeight = FontInfo.get(Fonts.getNormal()).getHeight();
        this.updateColumnSizes();
        ConsolidatedUIExec.exec(this, null, this, false);
    }

    private static final class DrawLinesEntryVisitor
    implements IInstructionsFile.IInstructionsFileEntryVisitor<Void, Void, RuntimeException> {
        private final @NonNull Rectangle bounds;
        private final @Nullable IDisasmPanelInstructionCounterRenderer counterColumnRenderer;
        private final @NonNull Font font;
        private final @NonNull GC gc;
        private final @NonNull Image inlineImage;
        private final int @NonNull [] mColumnSizes;
        private final int mLineHeight;
        private final @NonNull BitSet selection;
        private final int textYOffset;
        private final int y;

        public DrawLinesEntryVisitor(@NonNull GC gc, @NonNull Rectangle bounds, @NonNull BitSet selection, int y, int textYOffset, int mLineHeight, int @NonNull [] mColumnSizes, @NonNull Image inlineImage, @NonNull Font font, @Nullable IDisasmPanelInstructionCounterRenderer counterColumnRenderer) {
            this.gc = gc;
            this.bounds = bounds;
            this.selection = selection;
            this.y = y;
            this.textYOffset = textYOffset;
            this.mLineHeight = mLineHeight;
            this.mColumnSizes = mColumnSizes;
            this.inlineImage = inlineImage;
            this.font = font;
            this.counterColumnRenderer = counterColumnRenderer;
        }

        public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
            long count = entry.getBytesInBreak();
            this.gc.setBackground(Colors.lighten(Colors.getRed(), 95));
            this.gc.fillRectangle(this.bounds.x, this.y, this.bounds.width, this.mLineHeight);
            this.gc.setBackground(Colors.getWhite());
            this.gc.setForeground(Colors.getDarkRed());
            this.drawAtColumn(this.gc, MessageFormat.format(CodeMessages.BYTE_BREAK, count, Long.toHexString(count)), this.y + this.textYOffset, 4);
            return null;
        }

        public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
            @NonNull IFunction function = entry.getFunction();
            this.gc.setBackground(Colors.lighten(Colors.getBlue(), 95));
            this.gc.fillRectangle(this.bounds.x, this.y, this.bounds.width, this.mLineHeight);
            this.gc.setBackground(Colors.getWhite());
            this.gc.setForeground(Colors.getBlue());
            this.drawAtColumn(this.gc, function.getName(), this.y + this.textYOffset, 4);
            return null;
        }

        public Void visit(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry entry, Void data) throws RuntimeException {
            @Nullable IDisasmPanelInstructionCounterRenderer counterColumnRenderer = this.counterColumnRenderer;
            boolean isSelected = this.selection.get(entry.getIndex());
            int x = 2;
            int col = 0;
            if (isSelected) {
                this.gc.setBackground(Colors.getInstructionHighlight());
                this.gc.fillRectangle(this.bounds.x, this.y, this.bounds.width, this.mLineHeight);
            }
            if (counterColumnRenderer != null) {
                counterColumnRenderer.render(entry, this.gc, this.font, 2, x, this.y, this.mColumnSizes[col], this.mLineHeight);
            }
            x += this.mColumnSizes[col++] + 5;
            if (entry.isInlined()) {
                this.gc.drawImage(this.inlineImage, x, this.y);
            }
            int n = col++;
            this.gc.setForeground(Colors.getBlack());
            TextDrawing.drawString(this.gc, NumberUtils.formatAddress((long)entry.getAddress()), x += this.mColumnSizes[n] + 5, this.y + this.textYOffset, 16384);
            this.gc.setForeground(Colors.getGray());
            int opCode = entry.getFormattedOpcode();
            boolean is16Bit = entry.isOpcode16Bit();
            TextDrawing.drawString(this.gc, NumberUtils.formatHex((int)opCode, (int)(is16Bit ? 4 : 8), (boolean)false), x += this.mColumnSizes[col++] + 5, this.y + this.textYOffset, 16384);
            DisassemblyRenderer.draw(this.gc, this.font, x += this.mColumnSizes[col++] + 5, this.y + this.textYOffset, entry.getDisassembly(), false, false, entry.getType());
            x += this.mColumnSizes[col++] + 5;
            this.gc.setForeground(Colors.getGray());
            @Nullable SourceFile sourceFile = entry.getSourceFile();
            StringBuilder buffer = new StringBuilder(sourceFile != null ? FilePath.getLeafName((String)sourceFile.getName()) : "");
            int line = entry.getLine();
            if (line > 0 && sourceFile != null) {
                buffer.append(':');
                buffer.append(line);
            }
            TextDrawing.drawString(this.gc, buffer.toString(), x, this.y + this.textYOffset, 16384);
            return null;
        }

        private void drawAtColumn(GC gc, String text, int y, int col) {
            int x = 2;
            int i = 0;
            while (i < col) {
                x += this.mColumnSizes[i] + 5;
                ++i;
            }
            TextDrawing.drawString(gc, text, x, y, 16384);
        }
    }

    private static enum MouseState {
        MORE_DOWN,
        MORE_UP,
        NORMAL;

    }
}

