/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.databinding.ObservableLastSelectionFromListMapValue;
import com.arm.databinding.swt.TypedLabelProviderAdapter;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.InstructionCountersViewModel;
import com.arm.streamline.editortabs.InstructionCountersViewUtils;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeSummary;
import com.arm.streamline.editortabs.code.DisasmPanel;
import com.arm.streamline.editortabs.code.PathPrefixSubstitutionAction;
import com.arm.streamline.editortabs.code.RecentFunctionsAction;
import com.arm.streamline.editortabs.code.SourcePanel;
import com.arm.streamline.editortabs.code.ViewLayoutAction;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.iterable.SourceReferenceSelectionIterator;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterDecimalColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterHistogramColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterNumberColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterRatioColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileViews;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterRatioColumnWithValueAndPercentSubColumns;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.Splitter;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.utils.StreamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;

public class CodeTab
extends EditorTab
implements ICommandTarget,
ISelectionProvider,
ISelectionChangedListener {
    private static final @NonNull IInstructionCounterColumnDisplayTypeVisitor<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IInstructionCounter.InstructionCounterCodeColumns, @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata>, RuntimeException> EXTRACT_SUB_COLUMNS_VISITOR = new IInstructionCounterColumnDisplayTypeVisitor<IInstructionsFile.IInstructionsFileInstructionEntry, IInstructionCounter.InstructionCounterCodeColumns, Stream<InstructionCounterCodeColumnsWithMetadata>, RuntimeException>(){

        public @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata> displayAsHistogram(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionCounter.InstructionCounterCodeColumns data, @NonNull IInstructionCounterHistogramColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            IInstructionCounterHistogramColumn sourceColumn = (IInstructionCounterHistogramColumn)data.sourceLineColumn;
            return Stream.of(new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn, false));
        }

        public @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata> displayAsNumber(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionCounter.InstructionCounterCodeColumns data, @NonNull IInstructionCounterNumberColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            IInstructionCounterNumberColumn sourceColumn = (IInstructionCounterNumberColumn)data.sourceLineColumn;
            return Stream.of(new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn, false));
        }

        public @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata> displayAsDecimal(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionCounter.InstructionCounterCodeColumns data, @NonNull IInstructionCounterDecimalColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            IInstructionCounterDecimalColumn sourceColumn = (IInstructionCounterDecimalColumn)data.sourceLineColumn;
            return Stream.of(new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn, false));
        }

        public @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata> displayAsPercent(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionCounter.InstructionCounterCodeColumns data, @NonNull IInstructionCounterPercentColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            IInstructionCounterPercentColumn sourceColumn = (IInstructionCounterPercentColumn)data.sourceLineColumn;
            return Stream.of(new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn, false));
        }

        public @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata> displayAsPercentAndValue(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionCounter.InstructionCounterCodeColumns data, @NonNull IInstructionCounterPercentAndValueColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            IInstructionCounterPercentAndValueColumn sourceColumn = (IInstructionCounterPercentAndValueColumn)data.sourceLineColumn;
            return Stream.of(new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn, false), new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column.percentSubColumn(), (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn.percentSubColumn(), true), new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column.valueSubColumn(), (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn.valueSubColumn(), true));
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata> displayAsRatio(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionCounter.InstructionCounterCodeColumns data, @NonNull IInstructionCounterRatioColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            IInstructionCounterRatioColumn sourceColumn = (IInstructionCounterRatioColumn)data.sourceLineColumn;
            if (!$assertionsDisabled && column.valueSubColumns().length != sourceColumn.valueSubColumns().length) {
                throw new AssertionError();
            }
            @NonNull Stream zippedSubColumns = StreamUtils.zip(Arrays.stream(column.valueSubColumns()), Arrays.stream(sourceColumn.valueSubColumns()), (i, s) -> new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)i, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)s, true));
            return StreamUtils.concat((Stream[])new Stream[]{Stream.of(new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn, false)), zippedSubColumns});
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata> displayAsRatioWithValueAndPercentSubColumns(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionCounter.InstructionCounterCodeColumns data, @NonNull InstructionCounterRatioColumnWithValueAndPercentSubColumns<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            InstructionCounterRatioColumnWithValueAndPercentSubColumns sourceColumn = (InstructionCounterRatioColumnWithValueAndPercentSubColumns)data.sourceLineColumn;
            if (!$assertionsDisabled && column.valueSubColumns().length != sourceColumn.valueSubColumns().length) {
                throw new AssertionError();
            }
            @NonNull Stream zippedSubColumns = StreamUtils.zip(Arrays.stream(column.valueSubColumns()), Arrays.stream(sourceColumn.valueSubColumns()), (i, s) -> new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)i, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)s, true));
            return StreamUtils.concat((Stream[])new Stream[]{Stream.of(new InstructionCounterCodeColumnsWithMetadata((IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>)column, (IInstructionCounterColumn<IInstructionCounterSourcefileView>)sourceColumn, false)), zippedSubColumns});
        }
    };
    private DisasmPanel mDisasmPanel;
    private boolean mFirstInitialFocus;
    private RecentFunctionsAction mRecentFunctionsAction;
    private Set<ISelectionChangedListener> mSelectionListeners;
    private boolean mShowDisassembly;
    private SourcePanel mSourcePanel;
    private Splitter mSplitter;
    private CodeSummary mSummary;
    private ToolbarReadout mTotalsField;
    private ViewLayoutAction mViewLayoutAction;
    private ObservableLastSelectionFromListMapValue<IInstructionCounterSource, InstructionCounterCodeColumnsWithMetadata> selectedCounterProperty;

    protected static @NonNull Stream<@NonNull InstructionCounterCodeColumnsWithMetadata> extractSubcolumns(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IInstructionCounter.InstructionCounterCodeColumns column) {
        if (column == null) {
            return Stream.empty();
        }
        return (Stream)column.instructionColumn.acceptDisplayTypeVisitor(EXTRACT_SUB_COLUMNS_VISITOR, (Object)column);
    }

    public CodeTab(@NonNull AnalysisEditor editor) {
        super(editor);
        this.init();
    }

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.mSelectionListeners == null) {
            this.mSelectionListeners = new HashSet<ISelectionChangedListener>();
        }
        this.mSelectionListeners.add(listener);
    }

    @Override
    public void dispose() {
        @Nullable ObservableLastSelectionFromListMapValue<IInstructionCounterSource, InstructionCounterCodeColumnsWithMetadata> selectedCounterProperty = this.selectedCounterProperty;
        if (selectedCounterProperty != null) {
            selectedCounterProperty.dispose();
        }
        this.selectedCounterProperty = null;
        super.dispose();
    }

    public DisasmPanel getDisassemblyPanel() {
        return this.mDisasmPanel;
    }

    public ISelection getSelection() {
        return this.mSourcePanel.getSelection();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this;
    }

    public SourcePanel getSourcePanel() {
        return this.mSourcePanel;
    }

    public Splitter getSplitter() {
        return this.mSplitter;
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        if (!this.mSummary.handleCommand(command) && command.equals(ActionFactory.SELECT_ALL.getId())) {
            this.mSourcePanel.selectAll();
        }
    }

    @Override
    public void recomputeFromModel() {
        Task.callOnUIThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SourcePanel sourcePanel = CodeTab.this.getSourcePanel();
                if (!sourcePanel.isDisposed()) {
                    CodeTab.this.updateSummary(new SelectionChangedEvent((ISelectionProvider)CodeTab.this, sourcePanel.getSelection()));
                }
            }
        });
    }

    public synchronized void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.mSelectionListeners != null) {
            this.mSelectionListeners.remove(listener);
            if (this.mSelectionListeners.isEmpty()) {
                this.mSelectionListeners = null;
            }
        }
    }

    public void select(IFunction ... functions) {
        Task.callOnUIThread((Runnable)new ShowFunction(functions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(SelectionChangedEvent event) {
        ArrayList<ISelectionChangedListener> list = null;
        CodeTab codeTab = this;
        synchronized (codeTab) {
            if (this.mSelectionListeners != null) {
                list = new ArrayList<ISelectionChangedListener>(this.mSelectionListeners);
            }
        }
        if (list != null) {
            for (ISelectionChangedListener listener : list) {
                listener.selectionChanged(event);
            }
        }
        this.updateSummary(event);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean setFocus() {
        boolean result = this.mSourcePanel.setFocus();
        if (this.mFirstInitialFocus) {
            @NonNull IInstructionCounterCallPaths callPaths = this.getAnalysis().getInstructionCounterModel().getCallPaths();
            @NonNull @NonNull List roots = callPaths.getRootCallPaths();
            ICallPath firstEntryPoint = null;
            if (!roots.isEmpty()) {
                firstEntryPoint = ((ICallPath)roots.get(0)).getFirstNonEmptyNode();
            }
            if (firstEntryPoint != null) {
                this.setSelection((ISelection)new StructuredSelection((Object)firstEntryPoint.getFunction()));
            }
            this.mFirstInitialFocus = false;
        }
        return result;
    }

    public void setSelection(ISelection selection) {
        this.mDisasmPanel.setSelection(selection, true);
    }

    public boolean setShowDisassembly(boolean show) {
        if (this.mShowDisassembly != show) {
            this.mShowDisassembly = show;
            this.mSplitter.setMaximizedControl((Control)(this.mShowDisassembly ? null : this.mSourcePanel));
            this.mViewLayoutAction.adjustToCurrentState();
            return true;
        }
        return false;
    }

    public boolean showDisassembly() {
        return this.mShowDisassembly;
    }

    @Override
    public void sourceFilePathChanged(SourceFile[] files) {
        SourceFile srcFile = this.mSourcePanel.getSourceFile();
        SourceFile[] sourceFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            SourceFile file = sourceFileArray[n2];
            if (srcFile == file) {
                this.mSourcePanel.setSourceFile(file, true);
                break;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void widgetDisposed(DisposeEvent event) {
        CodeTab codeTab = this;
        synchronized (codeTab) {
            this.mSelectionListeners = null;
        }
        super.widgetDisposed(event);
    }

    @Override
    protected Composite createContent() {
        Splitter splitter;
        ObservableLastSelectionFromListMapValue selectedCounterProperty;
        final @NonNull InstructionCountersViewModel instructionCountersViewModel = this.getInstructionCounterViewModel();
        @NonNull IObservableValue<@Nullable IInstructionCounterSource> currentSelectedSource = instructionCountersViewModel.propertyCurrentSelectedSource();
        @NonNull ComputedList<@NonNull InstructionCounterCodeColumnsWithMetadata> extractedInstructionCounters = new ComputedList<InstructionCounterCodeColumnsWithMetadata>(){

            protected List<@NonNull InstructionCounterCodeColumnsWithMetadata> calculate() {
                return instructionCountersViewModel.propertyCurrentCodeCounters().stream().flatMap(CodeTab::extractSubcolumns).collect(Collectors.toList());
            }
        };
        this.selectedCounterProperty = selectedCounterProperty = new ObservableLastSelectionFromListMapValue(currentSelectedSource, (IObservableList)extractedInstructionCounters);
        this.mFirstInitialFocus = true;
        this.mSplitter = splitter = new Splitter(this, true);
        this.mSourcePanel = new SourcePanel((Composite)splitter, this, (IObservableValue<InstructionCounterCodeColumnsWithMetadata>)selectedCounterProperty);
        this.mDisasmPanel = new DisasmPanel((Composite)splitter, this, (IObservableValue<InstructionCounterCodeColumnsWithMetadata>)selectedCounterProperty);
        this.mSourcePanel.addSelectionChangedListener(this);
        this.mSplitter.setMaximizedControl((Control)this.mSourcePanel);
        return this.mSplitter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void fillToolbar(CustomToolbar toolbar) {
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCountersViewModel = this.getInstructionCounterViewModel();
        this.mViewLayoutAction = new ViewLayoutAction(this);
        this.mRecentFunctionsAction = new RecentFunctionsAction(this);
        toolbar.addAction(this.mViewLayoutAction);
        toolbar.addAction(this.mRecentFunctionsAction);
        toolbar.addAction(new OpenSourceFileAction(this, analysis::showPathSubstitutionDialog));
        toolbar.addAction(new PathPrefixSubstitutionAction(this.getAnalysis())).setLayoutData(new CustomToolbar.LayoutData().setGap(5));
        @NonNull Combo sourceComboBox = InstructionCountersViewUtils.createSelectCurrentSourceCombo(instructionCountersViewModel, this.ctx, toolbar, new CustomToolbar.LayoutData().setFillRowHeight().setMinimumWidth(50).setGap(5).setExcludeHidden());
        @NonNull Combo counterComboBox = new Combo((Composite)toolbar, 8);
        counterComboBox.setLayoutData((Object)new CustomToolbar.LayoutData().setFillRowHeight().setMinimumWidth(50).setGap(5).setExcludeHidden());
        @NonNull @NonNull IObservableList currentInstructionCounters = this.selectedCounterProperty.propertyCurrentValues();
        @NonNull ComboViewer comboViewer = new ComboViewer(counterComboBox);
        comboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new TypedLabelProviderAdapter(item -> {
            if (item.isSubColumn) {
                return String.format("  %s", item.instructionColumn.getTitle());
            }
            return item.instructionColumn.getTitle();
        }));
        comboViewer.setInput((Object)currentInstructionCounters);
        this.ctx.bindValue((IObservableValue)WidgetProperties.visible().observe((Widget)counterComboBox), (IObservableValue)WidgetProperties.visible().observe((Widget)sourceComboBox));
        this.ctx.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)counterComboBox), ComputedValue.create(() -> !currentInstructionCounters.isEmpty()));
        @NonNull @Nullable IViewerObservableValue selectionValue = ViewerProperties.singleSelection(InstructionCounterCodeColumnsWithMetadata.class).observe((Viewer)comboViewer);
        @Nullable InstructionCounterCodeColumnsWithMetadata initialSelection = (InstructionCounterCodeColumnsWithMetadata)this.selectedCounterProperty.getValue();
        this.ctx.bindValue((IObservableValue)selectionValue, this.selectedCounterProperty);
        selectionValue.setValue((Object)initialSelection);
        this.mSummary = new CodeSummary(this);
        this.mTotalsField = new ToolbarReadout(toolbar, CodeMessages.NA, 131072, CodeMessages.TOTAL_TOOLTIP);
        this.mTotalsField.setDesiredMinimumTextWidth(FontInfo.get(this.mTotalsField.getFont()).getWidth("0000000000000000"));
        this.mTotalsField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mTotalsField.computeSize((int)-1, (int)-1).x).setGap(2));
    }

    @Override
    protected String getHelpID() {
        return "com.arm.streamline.codeview";
    }

    @Override
    protected void initActionMap(Map<String, IAction> map) {
        this.addCommandAction(map, ActionFactory.FIND);
        this.addCommandAction(map, ActionFactory.SELECT_ALL);
    }

    private void addCommandAction(Map<String, IAction> map, ActionFactory factory) {
        String id = factory.getId();
        map.put(id, (IAction)new CommandAction(id, this));
    }

    private final @NonNull InstructionCountersViewModel getInstructionCounterViewModel() {
        return this.requireEditor().requireInstructionCountersViewModel();
    }

    RecentFunctionsAction getRecentFunctionsAction() {
        return this.mRecentFunctionsAction;
    }

    boolean isStillInInitialFocus() {
        return this.mFirstInitialFocus;
    }

    void updateSummary(SelectionChangedEvent event) {
        String text;
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        if (instructionCounterSource != null) {
            @NonNull IInstructionCounterSourcefileViews sourcefileViews = instructionCounterSource.getSourcefileViews();
            @NonNull ArrayList<E> references = new ArrayList();
            new SourceReferenceSelectionIterator(event.getSelection()).forEach(references::add);
            text = instructionCounterSource.calculateCodeTabSelectionText(StreamUtils.filterOutNull(references.stream().map(srcRef -> sourcefileViews.getSourceLineView(srcRef.getSourceFile(), srcRef.getStartLine()))));
        } else {
            text = CodeMessages.NA;
        }
        if (this.mTotalsField.setText(text)) {
            SafeUpdate.layout(this.getToolbar());
        }
    }

    public static final class InstructionCounterCodeColumnsWithMetadata {
        public final @NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> instructionColumn;
        public final boolean isSubColumn;
        public final @NonNull IInstructionCounterColumn<IInstructionCounterSourcefileView> sourceLineColumn;

        public InstructionCounterCodeColumnsWithMetadata(@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> instructionColumn, @NonNull IInstructionCounterColumn<IInstructionCounterSourcefileView> sourceLineColumn, boolean isSubColumn) {
            this.instructionColumn = instructionColumn;
            this.sourceLineColumn = sourceLineColumn;
            this.isSubColumn = isSubColumn;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InstructionCounterCodeColumnsWithMetadata) {
                InstructionCounterCodeColumnsWithMetadata that = (InstructionCounterCodeColumnsWithMetadata)obj;
                return this.isSubColumn == that.isSubColumn && this.instructionColumn.equals(that.instructionColumn) && this.sourceLineColumn.equals(that.sourceLineColumn);
            }
            return false;
        }

        public int hashCode() {
            return this.instructionColumn.hashCode() * 31 + this.sourceLineColumn.hashCode();
        }

        public String toString() {
            return this.instructionColumn.getTitle();
        }
    }

    private class ShowFunction
    implements Runnable {
        private IFunction[] mFunctions;

        public ShowFunction(IFunction ... functions) {
            this.mFunctions = functions;
        }

        @Override
        public void run() {
            CodeTab.this.setSelection((ISelection)new StructuredSelection((Object[])this.mFunctions));
        }
    }
}

