/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.editortabs.code.CodeMessages;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.TextField;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.utils.text.BasicNumberUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.actions.ActionFactory;

public class CodeSummary
implements KeyListener {
    private CodeTab mOwner;
    private TextField mFind;
    private ToolbarReadout mResults;
    private long mLastAddress = -1L;
    private int[] mDisasmIndexes = new int[0];
    private String mLastFunctionPrefix = "";
    private List<IFunction> mFunctions = new ArrayList<IFunction>();
    private int mJumpPos;
    private ISourceReference mJumpToSrcRef;
    private String mSrcRefDesc;

    private static String getSuffix(int chosen) {
        if (chosen > 10 && chosen < 20) {
            chosen = 4;
        }
        switch (chosen % 10) {
            case 1: {
                return CodeMessages.FIRST;
            }
            case 2: {
                return CodeMessages.SECOND;
            }
            case 3: {
                return CodeMessages.THIRD;
            }
        }
        return CodeMessages.REST;
    }

    public CodeSummary(CodeTab owner) {
        this.mOwner = owner;
        CustomToolbar toolbar = this.mOwner.getToolbar();
        this.mFind = new TextField(toolbar);
        this.mFind.setWatermark(CodeMessages.FIND);
        this.mFind.setToolTipText(CodeMessages.FIND_TOOLTIP);
        this.mFind.addKeyListener(this);
        this.mFind.addFieldModifiedListener(field -> this.adjustFind(false));
        this.mFind.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(100).setPreferredWidth(100).setGap(3));
        this.mResults = new ToolbarReadout(toolbar, "", 16384, CodeMessages.SUMMARY_RESULTS_TOOLTIP);
        this.mResults.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(50).setPreferredWidth(100).setGap(5));
    }

    public boolean handleCommand(String command) {
        if (command.equals(ActionFactory.SELECT_ALL.getId())) {
            if (this.mFind.isFocused()) {
                this.mFind.selectAll();
                return true;
            }
        } else if (command.equals(ActionFactory.FIND.getId())) {
            this.mFind.setFocus();
        }
        return false;
    }

    public void keyPressed(KeyEvent event) {
        char ch;
        if (event.doit && ((ch = event.character) == '\n' || ch == '\r')) {
            if (this.mJumpToSrcRef != null) {
                this.mOwner.getSourcePanel().setSelection((ISelection)new StructuredSelection((Object)this.mJumpToSrcRef));
            }
            this.adjustFind(true);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    private void adjustFind(boolean advance) {
        String text = this.mFind.getText();
        int chosen = 1;
        int count = 0;
        this.mJumpToSrcRef = null;
        if (text.length() > 0) {
            if (advance) {
                ++this.mJumpPos;
            }
            if (text.startsWith("0x")) {
                @NonNull IInstructionsFile instructions = this.mOwner.getAnalysis().getInstructionCounterModel().getInstructionsFile();
                long value = BasicNumberUtils.getNonLocalizedHexLong((String)text, (long)-1L);
                if (value != this.mLastAddress) {
                    this.mLastAddress = value;
                    this.mJumpPos = 0;
                    this.mDisasmIndexes = instructions.getIndexesForAddress(value);
                } else if (this.mJumpPos >= this.mDisasmIndexes.length) {
                    this.mJumpPos = 0;
                }
                if (this.mDisasmIndexes.length > 0) {
                    this.mJumpToSrcRef = IInstructionsFile.createSourceReference((IInstructionsFile)instructions, (int)this.mDisasmIndexes[this.mJumpPos]);
                    this.mSrcRefDesc = IInstructionsFile.getFunctionAddressDescription((IInstructionsFile)instructions, (int)this.mDisasmIndexes[this.mJumpPos]);
                    count = this.mDisasmIndexes.length;
                    chosen = this.mJumpPos + 1;
                }
            } else {
                if (!this.mLastFunctionPrefix.equals(text)) {
                    this.mLastFunctionPrefix = text;
                    this.mJumpPos = 0;
                    this.mFunctions.clear();
                    for (IFunction function : this.mOwner.getAnalysis().getInstructionCounterModel().getFunctions()) {
                        if (!function.getName().startsWith(text)) continue;
                        this.mFunctions.add(function);
                    }
                } else if (this.mJumpPos >= this.mFunctions.size()) {
                    this.mJumpPos = 0;
                }
                if (!this.mFunctions.isEmpty()) {
                    this.mJumpToSrcRef = (ISourceReference)this.mFunctions.get(this.mJumpPos);
                    this.mSrcRefDesc = this.mJumpToSrcRef.toString();
                    count = this.mFunctions.size();
                    chosen = this.mJumpPos + 1;
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        if (this.mJumpToSrcRef != null) {
            builder.append(this.mSrcRefDesc);
            if (count > 1) {
                builder.append(MessageFormat.format(CodeMessages.MATCHES, chosen, CodeSummary.getSuffix(chosen), count));
            }
        }
        this.mResults.setText(builder.toString());
    }
}

