/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.IUpdateOnDisplayTab;
import com.arm.streamline.editortabs.InstructionCounterOutlineUpdater;
import com.arm.streamline.editortabs.InstructionCountersViewModel;
import com.arm.streamline.editortabs.InstructionCountersViewUtils;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.editortabs.StreamlineContextMenu;
import com.arm.streamline.editortabs.callpath.CallPathColumn;
import com.arm.streamline.editortabs.callpath.CallPathFunctionColumn;
import com.arm.streamline.editortabs.callpath.CallPathFunctionContributor;
import com.arm.streamline.editortabs.callpath.CallPathFunctionRow;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.CallPathOutline;
import com.arm.streamline.editortabs.callpath.CallPathOutlineContributor;
import com.arm.streamline.editortabs.callpath.CallPathRow;
import com.arm.streamline.editortabs.callpath.ExpandCollapseAllAction;
import com.arm.streamline.editortabs.callpath.ICallPathColumn;
import com.arm.streamline.editortabs.callpath.ICallPathFunctionColumn;
import com.arm.streamline.editortabs.report.AnalysisOutline;
import com.arm.streamline.editortabs.report.ExportTableAction;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.FilterField;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.Splitter;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.Header;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.actions.ActionFactory;

public class CallPathTab
extends EditorTab
implements FilterField.IFilterMatcher,
ICommandTarget,
ISelectionChangedListener,
IUpdateOnDisplayTab {
    private AnalysisOutline<ICallPathFunction> mCallPathFunctionOutline;
    private CallPathOutline mCallPathOutline;
    private FilterField mFilterField;
    private Composite mFunctionArea;
    private ToolbarReadout mSamplesField;
    private TIntHashSet mSelectedIds;
    private ToolbarReadout mTotalsField;
    private InstructionCounterCallPathOutlineUpdater updateListener;

    private static void createPlaceholder(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        ControlHacks.setBackground((Control)wrapper, Colors.getListBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        Label label = new Label(wrapper, 0x1000040);
        label.setText(CallPathMessages.SELECT);
        ControlHacks.setBackground((Control)label, Colors.getListBackground());
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)label);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)new Label(parent, 258));
    }

    public CallPathTab(@NonNull AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
        super(editor, baseTimelineContent);
        this.init();
    }

    @Override
    public void dispose() {
        if (this.updateListener != null) {
            this.getInstructionCounterViewModel().propertyCurrentSelectedSource().removeValueChangeListener((IValueChangeListener)this.updateListener);
        }
        super.dispose();
    }

    @Override
    public void findMatches(FilterField field) {
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        String config = this.mCallPathOutline.getConfig();
        OutlineModel<EnumColumn<ICallPath>> model = this.mCallPathOutline.getModel();
        HashSet<ICallPath> selected = new HashSet<ICallPath>();
        for (Row row : model.getSelectionAsList()) {
            selected.add((ICallPath)((CallPathRow)row).getModelObject());
        }
        @NonNull ArrayList<@NonNull E> selection = new ArrayList();
        this.mCallPathOutline.setAllowLazyAdjust(false);
        boolean canNotify = model.getSelection().canNotify();
        model.getSelection().setNotify(false);
        model.removeAllRows();
        Pattern pattern = field.getPattern();
        boolean emptyPattern = pattern.pattern().isEmpty();
        if (instructionCounterSource != null) {
            this.getRootCallPaths(instructionCounterSource).forEach(link -> {
                if (emptyPattern) {
                    model.addRow(new CallPathRow((ICallPath)link), true);
                } else if (link.matches(pattern)) {
                    CallPathRow row = new CallPathRow((ICallPath)link, pattern);
                    model.addRow(row, true);
                    this.addSelectedChildren(row, selected, selection);
                }
            });
        }
        this.mCallPathOutline.applyConfig(config, true, true);
        this.mCallPathOutline.setAllowLazyAdjust(true);
        model.getSelection().setNotify(canNotify);
        this.mCallPathOutline.adjustScrollBarsForContent();
        if (emptyPattern && !selected.isEmpty()) {
            @NonNull ArrayList<@NonNull Row<EnumColumn<ICallPath>>> rows = new ArrayList<Row<EnumColumn<ICallPath>>>();
            for (Row<EnumColumn<ICallPath>> row : model.getTopLevelRows()) {
                this.collectMatches(rows, selected, row);
            }
            model.select(rows, false);
        } else if (!selection.isEmpty()) {
            model.select(selection, false);
        }
        this.mCallPathOutline.notifyOfSelectionChange();
    }

    public CallPathOutline getCallPathOutline() {
        return this.mCallPathOutline;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.mCallPathOutline;
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        if (!this.mFilterField.handleCommand(command)) {
            if (this.mCallPathFunctionOutline != null && this.mCallPathFunctionOutline.isFocusControl()) {
                this.mCallPathFunctionOutline.obeyCommand(commandAction);
            } else if (this.mCallPathOutline.isFocusControl()) {
                this.mCallPathOutline.obeyCommand(commandAction);
            }
        }
    }

    @Override
    public void onTabDisplayed() {
        TIntHashSet selectedPidsAndTids;
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        BaseTimelineContent baseTimelineContent = this.getBaseTimelineContent();
        TIntHashSet tIntHashSet = selectedPidsAndTids = baseTimelineContent == null ? null : baseTimelineContent.getSelectedProcessAndThreadIds();
        if (selectedPidsAndTids == null) {
            if (this.mSelectedIds.size() != 0) {
                this.mSelectedIds.clear();
                this.loadCallPathOutline(instructionCounterSource);
            }
            return;
        }
        if (this.mSelectedIds.equals((Object)selectedPidsAndTids)) {
            return;
        }
        this.mSelectedIds.clear();
        this.mSelectedIds.addAll((TIntCollection)selectedPidsAndTids);
        this.loadCallPathOutline(instructionCounterSource);
    }

    @Override
    public void recomputeFromModel() {
        final CallPathOutline callPathOutline = this.mCallPathOutline;
        Task.callOnUIThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!callPathOutline.isDisposed()) {
                    callPathOutline.getModel().sort();
                    callPathOutline.notifyOfSelectionChange();
                }
            }
        });
    }

    public void select(ICallPath ... paths) {
        OutlineModel<EnumColumn<ICallPath>> model = this.mCallPathOutline.getModel();
        ArrayList<@NonNull Row<EnumColumn<ICallPath>>> rows = new ArrayList<Row<EnumColumn<ICallPath>>>();
        HashSet<ICallPath> set = new HashSet<ICallPath>();
        ICallPath[] iCallPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            ICallPath iCallPath = iCallPathArray[n2];
            set.add(iCallPath);
            ++n2;
        }
        for (Row<EnumColumn<ICallPath>> row : model.getTopLevelRows()) {
            this.collectMatches(rows, set, row);
        }
        model.select(rows, false);
        this.mCallPathOutline.scrollSelectionIntoView(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        @NonNull List<Row<C>> rows = this.mCallPathOutline.getModel().getSelectionAsList();
        int count = rows.size();
        boolean needLayout = this.mTotalsField != null ? this.mTotalsField.setText(NumberUtils.prettyFormat((int)count)) : true;
        @NonNull String text = instructionCounterSource != null && !rows.isEmpty() ? instructionCounterSource.calculateCallPathTabSelectionText(rows.stream().map(row -> (CallPathRow)row).map(ReportRow::getModelObject)) : CallPathMessages.NA;
        if (needLayout |= this.mSamplesField != null ? this.mSamplesField.setText(text) : true) {
            SafeUpdate.layout(this.getToolbar());
        }
    }

    public boolean setFocus() {
        return this.mCallPathOutline.setFocus();
    }

    @Override
    public void sourceFilePathChanged(SourceFile[] files) {
        this.mCallPathOutline.redraw();
        if (this.mCallPathFunctionOutline != null) {
            this.mCallPathFunctionOutline.redraw();
        }
    }

    @Override
    protected Composite createContent() {
        Composite content = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(content);
        Splitter splitter = new Splitter(content, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)splitter);
        this.createCallPathOutline((Composite)splitter);
        this.createFunctionArea((Composite)splitter);
        splitter.setWeights(new int[]{70, 30});
        return content;
    }

    @Override
    protected void fillToolbar(CustomToolbar toolbar) {
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCountersViewModel = this.getInstructionCounterViewModel();
        @NonNull CallPathOutline mCallPathOutline = (CallPathOutline)NullChecking.neverNull((Object)this.mCallPathOutline);
        toolbar.addAction(new ExpandCollapseAllAction(mCallPathOutline, true));
        toolbar.addAction(new ExpandCollapseAllAction(mCallPathOutline, false));
        toolbar.addAction(new OpenSourceFileAction(mCallPathOutline, analysis::showPathSubstitutionDialog)).setLayoutData(new CustomToolbar.LayoutData().setGap(1));
        InstructionCountersViewUtils.createSelectCurrentSourceCombo(instructionCountersViewModel, this.ctx, toolbar, new CustomToolbar.LayoutData().setFillRowHeight().setMinimumWidth(50).setGap(5).setExcludeHidden());
        this.mFilterField = new FilterField(toolbar, this, CallPathMessages.FILTER, CallPathMessages.FILTER_TOOLTIP);
        this.mFilterField.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(100).setGap(5));
        this.mTotalsField = new ToolbarReadout(toolbar, NumberUtils.prettyFormat((int)0), 131072, CallPathMessages.TOTAL_TOOLTIP);
        this.mTotalsField.setDesiredMinimumTextWidth(FontInfo.get(this.mTotalsField.getFont()).getWidth("000"));
        this.mTotalsField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mTotalsField.computeSize((int)-1, (int)-1).x).setGap(5));
        this.mSamplesField = new ToolbarReadout(toolbar, CallPathMessages.NA, 131072, CallPathMessages.SAMPLES_TOOLTIP);
        this.mSamplesField.setDesiredMinimumTextWidth(FontInfo.get(this.mSamplesField.getFont()).getWidth("0000000000000000"));
        this.mSamplesField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mSamplesField.computeSize((int)-1, (int)-1).x).setGap(5));
        toolbar.addAction(new ExportTableAction(analysis, mCallPathOutline, "call_paths_for_{0}.csv"));
    }

    @Override
    protected String getHelpID() {
        return "com.arm.streamline.call_path";
    }

    @Override
    protected void initActionMap(Map<String, IAction> map) {
        String id = ActionFactory.SELECT_ALL.getId();
        map.put(id, (IAction)new CommandAction(id, this));
        id = ActionFactory.COPY.getId();
        map.put(id, (IAction)new CommandAction(id, this));
    }

    protected final void loadCallPathOutline(@Nullable IInstructionCounterSource instructionCounterSource) {
        Pattern pattern;
        String config = this.mCallPathOutline.getConfig();
        this.mCallPathOutline.setAllowLazyAdjust(false);
        OutlineModel outlineModel = this.mCallPathOutline.getModel();
        boolean canNotify = outlineModel.getSelection().canNotify();
        outlineModel.getSelection().setNotify(false);
        outlineModel.removeAllRows();
        Pattern pattern2 = pattern = this.mFilterField != null && !this.mFilterField.getText().trim().isEmpty() ? this.mFilterField.getPattern() : null;
        if (instructionCounterSource != null) {
            this.getRootCallPaths(instructionCounterSource).forEach(link -> {
                block3: {
                    block1: {
                        block2: {
                            if (this.mSelectedIds != null && !this.mSelectedIds.isEmpty() && !this.mSelectedIds.contains(link.getID())) break block1;
                            if (pattern != null) break block2;
                            outlineModel.addRow(new CallPathRow((ICallPath)link), true);
                            break block3;
                        }
                        if (!link.matches(pattern)) break block3;
                        CallPathRow row = new CallPathRow((ICallPath)link, pattern);
                        outlineModel.addRow(row, true);
                        break block3;
                    }
                    for (ICallPath child : link.getChildren()) {
                        if (!this.mSelectedIds.contains(child.getID()) || pattern != null && !link.matches(pattern)) continue;
                        outlineModel.addRow(new CallPathRow(child));
                    }
                }
            });
            if (outlineModel.getRecursiveRowCount() > 10000) {
                for (EnumColumn column : outlineModel.getColumns()) {
                    @NonNull ICallPathColumn one = (ICallPathColumn)column.getColumnEnum();
                    if (one.isHiddenFromUi()) continue;
                    column.setDefaultPreferredWidth(Math.min(one.getPreferredWidth(instructionCounterSource) + 12, column.getMaxWidth()));
                }
            }
        }
        this.mCallPathOutline.applyConfig(config, true, true);
        this.mCallPathOutline.setAllowLazyAdjust(true);
        this.mCallPathOutline.sizeColumnsToFit();
        outlineModel.getSelection().setNotify(canNotify);
        this.mCallPathOutline.getDefaultConfig();
        this.mCallPathOutline.adjustScrollBarsForContent();
        this.mCallPathOutline.openAllRows();
    }

    private void addSelectedChildren(CallPathRow row, Set<ICallPath> selected, List<Row<EnumColumn<ICallPath>>> selection) {
        if (selected.contains(row.getModelObject())) {
            selection.add(row);
        }
        if (row.hasChildren()) {
            for (Row child : (List)NullChecking.neverNull(row.getChildren())) {
                this.addSelectedChildren((CallPathRow)child, selected, selection);
            }
        }
    }

    private void collectMatches(List<Row<EnumColumn<ICallPath>>> rows, Set<ICallPath> set, Row<EnumColumn<ICallPath>> row) {
        if (row.hasChildren()) {
            for (Row child : (List)NullChecking.neverNull(row.getChildren())) {
                this.collectMatches(rows, set, child);
            }
        }
        if (set.contains(((CallPathRow)row).getModelObject())) {
            rows.add(row);
            row.disclose();
        }
    }

    private Composite createCallPathOutline(Composite parent) {
        TIntHashSet selectedPidsAndTids;
        CallPathOutline mCallPathOutline;
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        Composite wrapper = new Composite(parent, 0);
        ControlHacks.setBackground((Control)wrapper, Colors.getWidgetBackground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        Header header = new Header(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(header);
        OutlineModel<EnumColumn<ICallPath>> model = new OutlineModel<EnumColumn<ICallPath>>();
        this.mCallPathOutline = mCallPathOutline = new CallPathOutline(wrapper, model, (Class<?>)ICallPath.class, true);
        mCallPathOutline.setAnalysis(analysis);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mCallPathOutline);
        this.mSelectedIds = new TIntHashSet();
        BaseTimelineContent baseTimelineContent = this.getBaseTimelineContent();
        TIntHashSet tIntHashSet = selectedPidsAndTids = baseTimelineContent == null ? null : baseTimelineContent.getSelectedProcessAndThreadIds();
        if (selectedPidsAndTids != null) {
            this.mSelectedIds.addAll((TIntCollection)selectedPidsAndTids);
        }
        mCallPathOutline.addOutlineListener(new CallPathOutlineListener());
        mCallPathOutline.addSelectionChangedListener(this);
        mCallPathOutline.setHeader(header);
        ContextMenu cm = StreamlineContextMenu.createStdContextMenu(this.getEditor(), (Control)mCallPathOutline, EditorTabID.CALL_PATH);
        cm.add(new CallPathOutlineContributor());
        this.updateListener = new InstructionCounterCallPathOutlineUpdater(mCallPathOutline, (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue());
        instructionCounterViewModel.propertyCurrentSelectedSource().addValueChangeListener((IValueChangeListener)this.updateListener);
        return wrapper;
    }

    private Composite createFunctionArea(Composite parent) {
        this.mFunctionArea = new Composite(parent, 0);
        ControlHacks.setBackground((Control)this.mFunctionArea, Colors.getWidgetBackground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.mFunctionArea);
        CallPathTab.createPlaceholder(this.mFunctionArea);
        return this.mFunctionArea;
    }

    private @NonNull InstructionCountersViewModel getInstructionCounterViewModel() {
        return this.requireEditor().requireInstructionCountersViewModel();
    }

    private @NonNull Stream<@NonNull ICallPath> getRootCallPaths(@NonNull IInstructionCounterSource instructionCounterSource) {
        @NonNull Analysis analysis = this.getAnalysis();
        boolean showProcesses = analysis.shouldShowProcesses();
        @NonNull IInstructionCounterCallPaths callPaths = instructionCounterSource.getCallPaths();
        @NonNull Stream<@NonNull ICallPath> processes = callPaths.getRootCallPaths().stream();
        return showProcesses ? processes : processes.flatMap(c -> c.getChildren().stream());
    }

    protected final void loadCallPathFunctionOutline(@NonNull AnalysisOutline<ICallPathFunction> mCallPathFunctionOutline, @Nullable IInstructionCounterSource instructionCounterSource) {
        if (mCallPathFunctionOutline.isDisposed()) {
            return;
        }
        @NonNull String config = mCallPathFunctionOutline.getConfig();
        mCallPathFunctionOutline.setAllowLazyAdjust(false);
        @NonNull OutlineModel<EnumColumn<ICallPathFunction>> outlineModel = mCallPathFunctionOutline.getModel();
        boolean canNotify = outlineModel.getSelection().canNotify();
        outlineModel.getSelection().setNotify(false);
        outlineModel.removeAllRows();
        @NonNull OutlineModel<C> cpModel = this.mCallPathOutline.getModel();
        int selectionIndex = cpModel.getSelection().firstSelectedIndex();
        if (instructionCounterSource != null) {
            if (selectionIndex >= 0) {
                @NonNull ICallPath callPath = (ICallPath)((CallPathRow)cpModel.getRowAtIndex(selectionIndex)).getModelObject();
                for (ICallPathFunction cpf : instructionCounterSource.summarizeCallPath(callPath)) {
                    if (!cpf.hasAnyValues()) continue;
                    outlineModel.addRow(new CallPathFunctionRow(cpf), false);
                }
            }
            if (outlineModel.getRecursiveRowCount() > 10000) {
                for (EnumColumn column : outlineModel.getColumns()) {
                    @NonNull ICallPathFunctionColumn one = (ICallPathFunctionColumn)column.getColumnEnum();
                    column.setDefaultPreferredWidth(Math.min(one.getPreferredWidth(instructionCounterSource) + 12, column.getMaxWidth()));
                }
            }
        }
        mCallPathFunctionOutline.applyConfig(config, true, true);
        mCallPathFunctionOutline.setAllowLazyAdjust(true);
        mCallPathFunctionOutline.sizeColumnsToFit();
        outlineModel.getSelection().setNotify(canNotify);
        mCallPathFunctionOutline.getDefaultConfig();
        mCallPathFunctionOutline.adjustScrollBarsForContent();
    }

    protected static final @NonNull List<@NonNull CallPathFunctionContributor.ICallPathFunctionContributorSortProperties> createCallPathFunctionsMenuContributionSorters(@NonNull InstructionCountersViewModel instructionCounterViewModel) {
        return Arrays.asList(new CallPathFunctionContributor.ICallPathFunctionContributorSortProperties(){

            @Override
            public long getItemCount(@NonNull ICallPath callPath) {
                return callPath.getCounters().getSelfCounterValue(0, 0);
            }

            @Override
            public @NonNull String getName() {
                return CallPathMessages.TOP_LINKS;
            }

            @Override
            public long getTotalCount(@NonNull ICallPathFunction cpf) {
                return cpf.getCounterValue(0, 0);
            }
        });
    }

    private final class CallPathFunctionOutlineListener
    implements IOutlineListener<EnumColumn<ICallPathFunction>> {
        @Override
        public void deleteSelectionRequested(Outline<EnumColumn<ICallPathFunction>> outline) {
        }

        @Override
        public void editorChanged(Outline<EnumColumn<ICallPathFunction>> outline) {
        }

        @Override
        public void openSelectionRequested(Outline<EnumColumn<ICallPathFunction>> outline) {
            ArrayList paths = new ArrayList();
            OutlineModel<EnumColumn<ICallPathFunction>> model = outline.getModel();
            StdSelection selection = model.getSelection();
            int index = selection.firstSelectedIndex();
            while (index >= 0) {
                ICallPathFunction cpf = (ICallPathFunction)((CallPathFunctionRow)model.getRowAtIndex(index)).getModelObject();
                paths.addAll(cpf.getCallPaths());
                index = selection.nextSelectedIndex(index + 1);
            }
            if (!paths.isEmpty()) {
                CallPathTab.this.requireEditor().select(EditorTabID.CALL_PATH, (ISelection)new StructuredSelection(paths.toArray()));
            }
        }

        @Override
        public void selectionChanged(Outline<EnumColumn<ICallPathFunction>> outline) {
        }
    }

    private final class CallPathOutlineListener
    implements IOutlineListener<EnumColumn<ICallPath>> {
        private @Nullable InstructionCounterCallPathFunctionOutlineUpdater callPathFunctionUpdater;

        @Override
        public void deleteSelectionRequested(Outline<EnumColumn<ICallPath>> outline) {
        }

        @Override
        public void editorChanged(Outline<EnumColumn<ICallPath>> outline) {
        }

        @Override
        public void openSelectionRequested(Outline<EnumColumn<ICallPath>> outline) {
            ArrayList<ICallPath> paths = new ArrayList<ICallPath>();
            OutlineModel<EnumColumn<ICallPath>> model = outline.getModel();
            StdSelection selection = model.getSelection();
            int index = selection.firstSelectedIndex();
            while (index >= 0) {
                ICallPath path = (ICallPath)((CallPathRow)model.getRowAtIndex(index)).getModelObject();
                if (!path.isStructureOnlyNode()) {
                    paths.add(path);
                }
                index = selection.nextSelectedIndex(index + 1);
            }
            if (!paths.isEmpty()) {
                CallPathTab.this.requireEditor().select(EditorTabID.CODE, (ISelection)new StructuredSelection(paths.toArray()));
            }
        }

        @Override
        public void selectionChanged(Outline<EnumColumn<ICallPath>> outline) {
            @NonNull Analysis analysis = CallPathTab.this.getAnalysis();
            @NonNull InstructionCountersViewModel instructionCounterViewModel = CallPathTab.this.getInstructionCounterViewModel();
            @NonNull OutlineModel<EnumColumn<ICallPath>> model = outline.getModel();
            @Nullable AnalysisOutline<ICallPathFunction> callPathFunctionOutline = CallPathTab.this.mCallPathFunctionOutline;
            if (model.getSelectionCount() == 1) {
                if (callPathFunctionOutline == null) {
                    InstructionCounterCallPathFunctionOutlineUpdater callPathFunctionUpdater;
                    WidgetUtils.disposeAllChildren(CallPathTab.this.mFunctionArea);
                    Header header = new Header(CallPathTab.this.mFunctionArea);
                    GridDataFactory.fillDefaults().grab(true, false).applyTo(header);
                    OutlineModel subModel = new OutlineModel();
                    subModel.setUserRef(model.getUserRef());
                    AnalysisOutline<ICallPathFunction> mCallPathFunctionOutline = new AnalysisOutline<ICallPathFunction>(CallPathTab.this.mFunctionArea, subModel, IFunction.class, false);
                    CallPathTab.this.mCallPathFunctionOutline = mCallPathFunctionOutline;
                    mCallPathFunctionOutline.setAnalysis(analysis);
                    GridDataFactory.fillDefaults().grab(true, true).applyTo(mCallPathFunctionOutline);
                    mCallPathFunctionOutline.addOutlineListener(new CallPathFunctionOutlineListener());
                    mCallPathFunctionOutline.setHeader(header);
                    ContextMenu cm = StreamlineContextMenu.createStdContextMenu(CallPathTab.this.getEditor(), mCallPathFunctionOutline, new EditorTabID[0]);
                    cm.add(new CallPathFunctionContributor(() -> CallPathTab.createCallPathFunctionsMenuContributionSorters(instructionCounterViewModel)));
                    this.callPathFunctionUpdater = callPathFunctionUpdater = new InstructionCounterCallPathFunctionOutlineUpdater(mCallPathFunctionOutline, (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue());
                    instructionCounterViewModel.propertyCurrentSelectedSource().addValueChangeListener((IValueChangeListener)callPathFunctionUpdater);
                    CallPathTab.this.layout(true, true);
                } else {
                    CallPathTab.this.loadCallPathFunctionOutline(callPathFunctionOutline, (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue());
                }
            } else if (callPathFunctionOutline != null) {
                @Nullable InstructionCounterCallPathFunctionOutlineUpdater callPathFunctionUpdater = this.callPathFunctionUpdater;
                if (callPathFunctionUpdater != null) {
                    instructionCounterViewModel.propertyCurrentSelectedSource().removeValueChangeListener((IValueChangeListener)callPathFunctionUpdater);
                    this.callPathFunctionUpdater = null;
                }
                CallPathTab.this.mCallPathFunctionOutline = null;
                WidgetUtils.disposeAllChildren(CallPathTab.this.mFunctionArea);
                CallPathTab.createPlaceholder(CallPathTab.this.mFunctionArea);
                CallPathTab.this.layout(true, true);
            }
        }
    }

    public final class InstructionCounterCallPathFunctionOutlineUpdater
    extends InstructionCounterOutlineUpdater<ICallPathFunction, ICallPathFunctionColumn> {
        public InstructionCounterCallPathFunctionOutlineUpdater(@Nullable AnalysisOutline<ICallPathFunction> outline, IInstructionCounterSource instructionCounterSource) {
            super(outline, instructionCounterSource);
        }

        @Override
        protected @NonNull Iterable<@NonNull ICallPathFunctionColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource) {
            return CallPathFunctionColumn.aggregateColumns(instructionCounterSource);
        }

        @Override
        protected void populateOutline(@Nullable IInstructionCounterSource instructionCounterSource) {
            CallPathTab.this.loadCallPathFunctionOutline(this.outline, instructionCounterSource);
        }
    }

    public final class InstructionCounterCallPathOutlineUpdater
    extends InstructionCounterOutlineUpdater<ICallPath, ICallPathColumn> {
        public InstructionCounterCallPathOutlineUpdater(@Nullable AnalysisOutline<ICallPath> outline, IInstructionCounterSource instructionCounterSource) {
            super(outline, instructionCounterSource);
        }

        @Override
        protected @NonNull Iterable<@NonNull ICallPathColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource) {
            return CallPathColumn.aggregateColumns(instructionCounterSource);
        }

        @Override
        protected void populateOutline(@Nullable IInstructionCounterSource instructionCounterSource) {
            CallPathTab.this.loadCallPathOutline(instructionCounterSource);
        }
    }
}

