/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.model.timeline.ProcessIdentifierRegex;
import com.arm.streamline.report.model.ICallPath;
import com.arm.utils.collections.Pair;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class CallPathRow
extends ReportRow<ICallPath> {
    public CallPathRow(@NonNull ICallPath link) {
        super(link);
        if (link.hasChildren()) {
            this.setCanHaveChildren(true);
            for (ICallPath child : link.getChildren()) {
                this.addChild(new CallPathRow(child));
            }
        }
    }

    public CallPathRow(@NonNull ICallPath link, Pattern pattern) {
        super(link);
        if (link.hasChildren()) {
            this.setCanHaveChildren(true);
            for (ICallPath child : link.getChildren()) {
                if (!child.matches(pattern)) continue;
                this.addChild(new CallPathRow(child, pattern));
            }
            this.setOpen(true);
        }
    }

    public CallPathRow(@NonNull ICallPath link, ProcessIdentifierRegex childRegex) {
        super(link);
        if (link.hasChildren()) {
            this.setCanHaveChildren(true);
            for (ICallPath child : link.getChildren()) {
                Pair<String, Integer> childThreadNameAndTid = ProcessIdentifierRegex.getNameAndPidPair(child.getName());
                if (!childRegex.match(childThreadNameAndTid)) continue;
                this.addChild(new CallPathRow(child));
            }
            this.setOpen(true);
        }
    }
}

