/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.CallPathTab;
import com.arm.streamline.model.iterable.CallPathSelectionIterator;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.outline.Outline;
import com.arm.utils.NullChecking;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.MenuItem;

public class CallPathOutlineContributor
implements IContextMenuContributor {
    private @Nullable HashSet<ICallPath> mExpansion;

    @Override
    public void cleanup(ContextMenu cm) {
        this.mExpansion = null;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        if (CallPathMessages.EXPAND_TO_MATCHING.equals(commandID)) {
            @Nullable HashSet mExpansion = (HashSet)NullChecking.neverNull(this.mExpansion);
            CallPathTab tab = (CallPathTab)WidgetUtils.getAncestorOfType(cm.getHandlerControl(), CallPathTab.class);
            tab.select(mExpansion.toArray(new ICallPath[0]));
        } else if (CallPathMessages.COLLAPSE_UNSELECTED.equals(commandID)) {
            ((Outline)cm.getHandlerControl()).closeUnselectedRows();
        } else if (CallPathMessages.EXPAND_UNSELECTED.equals(commandID)) {
            ((Outline)cm.getHandlerControl()).openUnselectedRows();
        }
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        if (cm.getHandlerControl() instanceof Outline) {
            this.mExpansion = new HashSet();
            @NonNull HashSet<E> mExpansion = this.mExpansion;
            HashSet<ICallPath> selection = new HashSet<ICallPath>();
            for (ICallPath link : new CallPathSelectionIterator(cm.getSelection())) {
                IInstructionCounterFunctionView functionView;
                selection.add(link);
                IInstructionCounterFunctionView iInstructionCounterFunctionView = functionView = link != null ? link.getFunction() : null;
                if (functionView == null) continue;
                mExpansion.addAll(functionView.getAssociatedCallPaths());
            }
            cm.createConditionalSeparator();
            if (!selection.containsAll(mExpansion)) {
                cm.createMenuItem(this, CallPathMessages.EXPAND_TO_MATCHING, CallPathMessages.EXPAND_TO_MATCHING, true);
            }
            if (((Outline)cm.getHandlerControl()).areUnselectedRowsClosable()) {
                cm.createMenuItem(this, CallPathMessages.COLLAPSE_UNSELECTED, CallPathMessages.COLLAPSE_UNSELECTED, true);
            }
            if (((Outline)cm.getHandlerControl()).areUnselectedRowsOpenable()) {
                cm.createMenuItem(this, CallPathMessages.EXPAND_UNSELECTED, CallPathMessages.EXPAND_UNSELECTED, true);
            }
        }
    }
}

