/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.EditorTabsMessages;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.IReAnalysisProgressListener;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProcessingDialog
extends TitleAreaDialog
implements IReAnalysisProgressListener,
Runnable {
    private AnalysisEditor mAnalysisEditor;
    private EditorTabID mTab;
    private Composite mContent;
    private ProgressIndicator mProgress;

    public ProcessingDialog(AnalysisEditor editor, EditorTabID tab) {
        super(WorkspaceUtils.getShell());
        this.mAnalysisEditor = editor;
        this.mTab = tab;
    }

    public boolean close() {
        boolean result = super.close();
        @NonNull Analysis analysis = (Analysis)NullChecking.neverNull((Object)this.mAnalysisEditor.getAnalysis());
        analysis.removeReAnalysisListener(this);
        if (this.getReturnCode() == 1) {
            analysis.cancelReAnalysis();
        } else {
            this.mAnalysisEditor.setActivePage(this.mTab);
        }
        return result;
    }

    @Override
    public void reAnalysisFinished() {
        Task.callOnUIThread((Runnable)this);
    }

    @Override
    public void run() {
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EditorTabsMessages.PLEASE_WAIT);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(EditorTabsMessages.ANALYZING);
        this.setMessage(EditorTabsMessages.SELECTED_DATA_BEING_REANALYZED);
        this.mContent = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayoutFactory.swtDefaults().applyTo(this.mContent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContent);
        this.mProgress = new ProgressIndicator(this.mContent, 65794);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mProgress);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mContent, "com.arm.streamline.processing");
        this.mProgress.beginAnimatedTask();
        ((Analysis)NullChecking.neverNull((Object)this.mAnalysisEditor.getAnalysis())).addReAnalysisListener(this);
        return this.mContent;
    }
}

